/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.common.flogger.GoogleLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BackgroundRequestCoordinator {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final Map<String, Exchanger<Object>> exchangerMap = new HashMap<String, Exchanger<Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread waitForThreadStart(String requestId, Runnable runnable, long deadlineInMillis) throws InterruptedException, TimeoutException {
        ((GoogleLogger.Api)logger.atInfo()).log("Waiting until thread creation for %s", requestId);
        Exchanger<Object> exchanger = this.getOrCreateExchanger(requestId);
        try {
            Thread thread = (Thread)exchanger.exchange(runnable, deadlineInMillis, TimeUnit.MILLISECONDS);
            return thread;
        }
        finally {
            this.removeExchanger(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable waitForUserRunnable(String requestId, Thread thread, long deadLineInMillis) throws InterruptedException, TimeoutException {
        ((GoogleLogger.Api)logger.atInfo()).log("Got thread creation for %s", requestId);
        Exchanger<Object> exchanger = this.getOrCreateExchanger(requestId);
        try {
            Runnable runnable = (Runnable)exchanger.exchange(thread, deadLineInMillis, TimeUnit.MILLISECONDS);
            return runnable;
        }
        finally {
            this.removeExchanger(requestId);
        }
    }

    private synchronized void removeExchanger(String requestId) {
        this.exchangerMap.remove(requestId);
    }

    private synchronized Exchanger<Object> getOrCreateExchanger(String requestId) {
        Exchanger<Object> exchanger = this.exchangerMap.get(requestId);
        if (exchanger == null) {
            exchanger = new Exchanger();
            this.exchangerMap.put(requestId, exchanger);
        }
        return exchanger;
    }
}

