/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class FileEncodingSetter {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final ImmutableMap<String, Charset> KNOWN_CHARSETS = ImmutableMap.of("UTF-8", StandardCharsets.UTF_8, "US-ASCII", StandardCharsets.US_ASCII, "ANSI_X3.4-1968", StandardCharsets.US_ASCII);

    public static void set(Map<String, String> sysProps) {
        String fileEncoding = sysProps.get("appengine.file.encoding");
        Charset charset = KNOWN_CHARSETS.get(fileEncoding);
        if (charset != null) {
            sysProps.put("file.encoding", fileEncoding);
            FileEncodingSetter.overwriteDefaultCharset(charset);
        } else if (fileEncoding != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Unknown appengine.file.encoding %s", fileEncoding);
        }
    }

    static void overwriteDefaultCharset(Charset charset) {
        try {
            Field defaultCharset = Charset.class.getDeclaredField("defaultCharset");
            defaultCharset.setAccessible(true);
            defaultCharset.set(null, charset);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private FileEncodingSetter() {
    }
}

