/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.AppVersionFactory;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.AutoBuilder_JavaRuntime_Builder;
import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.apphosting.runtime.CloneControllerImpl;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.Logging;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.NullSandboxPlugin;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RequestRunner;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.apphosting.runtime.anyrpc.AnyRpcPlugin;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.auto.value.AutoBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.flogger.GoogleLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JavaRuntime
implements EvaluationRuntimeServerInterface {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String VAR_LOG_ENV_VAR = "WRITE_LOGS_TO_VAR_LOG";
    private static final String GOOGLE_CLOUD_PROJECT_ENV_VAR = "GOOGLE_CLOUD_PROJECT";
    private static final Path DEFAULT_JSON_LOG_OUTPUT_DIR = Paths.get("/var/log", new String[0]);
    private static final String JSON_LOG_OUTPUT_FILE = "app";
    private final ServletEngineAdapter servletEngine;
    private final NullSandboxPlugin sandboxPlugin;
    private final AnyRpcPlugin rpcPlugin;
    private final AppVersionFactory appVersionFactory;
    private final RequestManager requestManager;
    private final String runtimeVersion;
    private final ApplicationEnvironment.RuntimeConfiguration templateConfiguration;
    private final ApiDeadlineOracle deadlineOracle;
    private final Logging logging = new Logging();
    private final BackgroundRequestCoordinator coordinator;
    private final boolean compressResponse;
    private final boolean enableHotspotPerformanceMetrics;
    private final CloudDebuggerAgentWrapper cloudDebuggerAgent;
    private boolean cloudDebuggerEnabled;
    private final boolean pollForNetwork;
    private final boolean redirectStdoutStderr;
    private final boolean logJsonToFile;
    private final boolean clearLogHandlers;
    private final Path jsonLogDir;
    private ByteBuffer hotspotPerformanceData = null;
    private AppVersion appVersion;

    public static Builder builder() {
        return new AutoBuilder_JavaRuntime_Builder().setCompressResponse(true).setEnableHotspotPerformanceMetrics(true).setCloudDebuggerEnabled(false).setPollForNetwork(false).setDefaultToNativeUrlStreamHandler(false).setForceUrlfetchUrlStreamHandler(false).setIgnoreDaemonThreads(true).setUseEnvVarsFromAppInfo(false).setFixedApplicationPath(null).setRedirectStdoutStderr(true).setLogJsonToFile(false).setClearLogHandlers(true).setJsonLogDir(DEFAULT_JSON_LOG_OUTPUT_DIR);
    }

    JavaRuntime(ServletEngineAdapter servletEngine, NullSandboxPlugin sandboxPlugin, AnyRpcPlugin rpcPlugin, File sharedDirectory, RequestManager requestManager, String runtimeVersion, ApplicationEnvironment.RuntimeConfiguration configuration, ApiDeadlineOracle deadlineOracle, BackgroundRequestCoordinator coordinator, boolean compressResponse, boolean enableHotspotPerformanceMetrics, CloudDebuggerAgentWrapper cloudDebuggerAgent, boolean cloudDebuggerEnabled, boolean pollForNetwork, boolean defaultToNativeUrlStreamHandler, boolean forceUrlfetchUrlStreamHandler, boolean ignoreDaemonThreads, boolean useEnvVarsFromAppInfo, @Nullable String fixedApplicationPath, boolean redirectStdoutStderr, boolean logJsonToFile, boolean clearLogHandlers, Path jsonLogDir) {
        this.servletEngine = servletEngine;
        this.sandboxPlugin = sandboxPlugin;
        this.rpcPlugin = rpcPlugin;
        this.requestManager = requestManager;
        this.appVersionFactory = AppVersionFactory.builder().setSandboxPlugin(sandboxPlugin).setSharedDirectory(sharedDirectory).setRuntimeVersion(runtimeVersion).setDefaultToNativeUrlStreamHandler(defaultToNativeUrlStreamHandler).setForceUrlfetchUrlStreamHandler(forceUrlfetchUrlStreamHandler).setIgnoreDaemonThreads(ignoreDaemonThreads).setUseEnvVarsFromAppInfo(useEnvVarsFromAppInfo).setFixedApplicationPath(fixedApplicationPath).build();
        this.runtimeVersion = runtimeVersion;
        this.templateConfiguration = configuration;
        this.deadlineOracle = deadlineOracle;
        this.coordinator = coordinator;
        this.compressResponse = compressResponse;
        this.enableHotspotPerformanceMetrics = enableHotspotPerformanceMetrics;
        this.cloudDebuggerAgent = cloudDebuggerAgent;
        this.cloudDebuggerEnabled = cloudDebuggerEnabled;
        this.pollForNetwork = pollForNetwork;
        this.redirectStdoutStderr = redirectStdoutStderr;
        this.logJsonToFile = logJsonToFile;
        this.clearLogHandlers = clearLogHandlers;
        this.jsonLogDir = jsonLogDir;
    }

    public void start(ServletEngineAdapter.Config runtimeOptions) {
        Object response;
        ((GoogleLogger.Api)logger.atInfo()).log("JavaRuntime starting...");
        if (this.enableHotspotPerformanceMetrics) {
            try {
                try {
                    this.hotspotPerformanceData = this.getPerformanceDataByteBuffer("sun.misc.Perf");
                }
                catch (ClassNotFoundException e) {
                    this.hotspotPerformanceData = this.getPerformanceDataByteBuffer("jdk.internal.perf.Perf");
                }
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to access Hotspot performance data");
            }
        }
        SynchronousQueue<Object> rpcStarted = new SynchronousQueue<Object>();
        new Thread((Runnable)new RpcRunnable(rpcStarted), "Runtime Network Thread").start();
        this.servletEngine.start("Google App Engine/" + this.runtimeVersion, runtimeOptions);
        try {
            response = rpcStarted.take();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted while starting runtime", ex);
        }
        if (response instanceof Error) {
            throw (Error)response;
        }
        if (response instanceof RuntimeException) {
            throw (RuntimeException)response;
        }
        if (response instanceof Throwable) {
            throw new RuntimeException((Throwable)response);
        }
        if (!(response instanceof AnyRpcPlugin)) {
            throw new RuntimeException("Unknown response: " + response);
        }
    }

    private ByteBuffer getPerformanceDataByteBuffer(String perfClassName) throws ReflectiveOperationException {
        Class<?> perfClass = Class.forName(perfClassName);
        Method getPerfMethod = perfClass.getMethod("getPerf", new Class[0]);
        Object perf = getPerfMethod.invoke(null, new Object[0]);
        Method attachMethod = perf.getClass().getMethod("attach", Integer.TYPE, String.class);
        ByteBuffer buffer = (ByteBuffer)attachMethod.invoke(perf, 0, "r");
        if (buffer.capacity() == 0) {
            throw new RuntimeException("JVM does not export Hotspot performance data");
        }
        return buffer;
    }

    public void stop() {
        ((GoogleLogger.Api)logger.atInfo()).log("JavaRuntime stopping...");
        this.rpcPlugin.stopServer();
        ((GoogleLogger.Api)logger.atInfo()).log("JavaRuntime stopped.");
        this.servletEngine.stop();
    }

    @Override
    public void handleRequest(AnyRpcServerContext rpc, RuntimePb.UPRequest upRequest) {
        try {
            MutableUpResponse upResponse = new MutableUpResponse();
            AppVersionKey appVersionKey = AppVersionKey.fromUpRequest(upRequest);
            ((GoogleLogger.Api)logger.atFine()).log("Received handleRequest for %s", appVersionKey);
            if (this.appVersion == null) {
                RequestRunner.setFailure(upResponse, RuntimePb.UPResponse.ERROR.UNKNOWN_APP, "AddAppVersion not called");
                rpc.finishWithResponse(upResponse.build());
                return;
            }
            if (!this.appVersion.getKey().equals(appVersionKey)) {
                String message = String.format("App version %s should be %s", appVersionKey, this.appVersion.getKey());
                RequestRunner.setFailure(upResponse, RuntimePb.UPResponse.ERROR.UNKNOWN_APP, message);
                rpc.finishWithResponse(upResponse.build());
                return;
            }
            try {
                RequestRunner requestRunner = RequestRunner.builder().setAppVersion(this.appVersion).setRpc(rpc).setUpRequest(upRequest).setUpResponse(upResponse).setRequestManager(this.requestManager).setCoordinator(this.coordinator).setCompressResponse(this.compressResponse).setUpRequestHandler(this.servletEngine).build();
                this.appVersion.getThreadGroupPool().start("Request" + upRequest.getEventIdHash(), this.rpcPlugin.traceContextPropagating(requestRunner));
            }
            catch (InterruptedException ex) {
                RequestRunner.setFailure(upResponse, RuntimePb.UPResponse.ERROR.APP_FAILURE, "Interrupted while starting request thread: " + ex);
                rpc.finishWithResponse(upResponse.build());
            }
        }
        catch (Throwable th) {
            JavaRuntime.killCloneIfSeriousException(th);
            throw th;
        }
    }

    @Override
    public synchronized void addAppVersion(AnyRpcServerContext rpc, AppinfoPb.AppInfo appInfo) {
        if (this.appVersion != null) {
            rpc.finishWithAppError(1, "AddAppVersion already called with version " + this.appVersion);
            return;
        }
        try {
            AppEngineWebXml appEngineWebXml = this.appVersionFactory.readAppEngineWebXml(appInfo);
            this.appVersion = this.appVersionFactory.createAppVersion(appInfo, appEngineWebXml, this.templateConfiguration);
            ApplicationEnvironment env = this.appVersion.getEnvironment();
            if (this.cloudDebuggerEnabled && env.isCloudDebuggerDisabled()) {
                ((GoogleLogger.Api)logger.atInfo()).log("Cloud Debugger is disabled through appengine-web.xml");
                this.cloudDebuggerEnabled = false;
                this.requestManager.disableCloudDebugger();
            }
            if ("1.8".equals(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value())) {
                JavaRuntime.setEnvironmentVariables(env.getEnvironmentVariables());
            }
            System.getProperties().putAll(env.getSystemProperties());
            String identifier = env.getAppId() + "/" + env.getVersionId();
            String userLogConfigFilePath = env.getSystemProperties().get("java.util.logging.config.file");
            if (userLogConfigFilePath != null) {
                userLogConfigFilePath = env.getRootDirectory().getAbsolutePath() + "/" + userLogConfigFilePath;
            }
            System.setIn(new ByteArrayInputStream(new byte[0]));
            if (this.logJsonToFile || "1".equals(System.getenv(VAR_LOG_ENV_VAR))) {
                this.logging.logJsonToFile(System.getenv(GOOGLE_CLOUD_PROJECT_ENV_VAR), this.jsonLogDir.resolve(JSON_LOG_OUTPUT_FILE), this.clearLogHandlers);
            } else {
                this.sandboxPlugin.startCapturingApplicationLogs();
            }
            if (this.redirectStdoutStderr) {
                this.logging.redirectStdoutStderr(identifier);
            }
            this.logging.applyLogProperties(userLogConfigFilePath, this.sandboxPlugin.getApplicationClassLoader());
            this.servletEngine.addAppVersion(this.appVersion);
            if (this.cloudDebuggerEnabled) {
                try {
                    URLClassLoader urlLoader = (URLClassLoader)this.appVersion.getClassLoader();
                    this.cloudDebuggerAgent.setApplication(Iterables.toArray(JavaRuntime.urlsToPaths(urlLoader.getURLs()), String.class), this.appVersion);
                }
                catch (RuntimeException ex) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Error setting class path for Cloud Debugger:");
                }
            }
        }
        catch (Exception ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Error adding app version:");
            rpc.finishWithAppError(1, ex.toString());
            return;
        }
        rpc.finishWithResponse(EmptyMessage.getDefaultInstance());
    }

    @Override
    public synchronized void deleteAppVersion(AnyRpcServerContext rpc, AppinfoPb.AppInfo appInfo) {
        rpc.finishWithAppError(1, "Version deletion is unimplemented");
    }

    synchronized AppVersion findAppVersion(String appId, String versionId) {
        AppVersionKey key = AppVersionKey.of(appId, versionId);
        if (key.equals(this.appVersion.getKey())) {
            return this.appVersion;
        }
        return null;
    }

    public static void killCloneIfSeriousException(Throwable th) {
        if (RequestRunner.shouldKillCloneAfterException(th)) {
            try {
                System.err.println("Killing clone due to serious exception");
                th.printStackTrace();
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(th)).log("Killing clone due to serious exception");
            }
            finally {
                System.exit(1);
            }
        }
    }

    private static String urlToPath(URL url) {
        try {
            return Paths.get(url.toURI()).toFile().getAbsolutePath();
        }
        catch (URISyntaxException ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Failed to convert URL %s to string: ", url);
            return null;
        }
    }

    private static Iterable<String> urlsToPaths(URL[] urls) {
        return Arrays.stream(urls).map(JavaRuntime::urlToPath).filter(s -> s != null).collect(Collectors.toList());
    }

    private static void setEnvironmentVariables(Map<String, String> vars) {
        HashMap<String, String> allVars = new HashMap<String, String>(System.getenv());
        vars.forEach((k, v) -> {
            if (v == null) {
                ((GoogleLogger.Api)logger.atWarning()).log("Null value for $%s", k);
            }
            allVars.put((String)k, (String)v);
        });
        try {
            Class<?> pe = Class.forName("java.lang.ProcessEnvironment", true, null);
            Field f = pe.getDeclaredField("theUnmodifiableEnvironment");
            f.setAccessible(true);
            Field m = Field.class.getDeclaredField("modifiers");
            m.setAccessible(true);
            m.setInt(f, m.getInt(f) & 0xFFFFFFEF);
            f.set(null, Collections.unmodifiableMap(allVars));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("failed to set the environment variables", e);
        }
    }

    @VisibleForTesting
    class CloneControllerImplCallback
    implements CloneControllerImpl.Callback {
        CloneControllerImplCallback() {
        }

        @Override
        public void divertNetworkServices() {
            if (JavaRuntime.this.pollForNetwork) {
                this.pollNetworkingReady();
            }
        }

        @Override
        public AppVersion getAppVersion(String appId, String versionId) {
            return JavaRuntime.this.findAppVersion(appId, versionId);
        }

        private void sleep(int time) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void pollNetworkingReady() {
            ((GoogleLogger.Api)logger.atInfo()).log("Polling for if networking is ready.");
            long start = System.nanoTime();
            for (int i = 0; i < 100; ++i) {
                try {
                    InetAddress.getByName("google.com");
                    long finish = System.nanoTime();
                    ((GoogleLogger.Api)logger.atInfo()).log("Networking ready. Polled for %.3f s.", (double)(finish - start) / 1.0E9);
                    return;
                }
                catch (UnknownHostException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(e)).log("Couldn't connect");
                    this.sleep(100);
                    continue;
                }
            }
            ((GoogleLogger.Api)logger.atSevere()).log("Could not verify that networking is ready.");
            throw new RuntimeException("Cannot verify that networking is ready");
        }
    }

    private class RpcRunnable
    implements Runnable {
        private final SynchronousQueue<Object> rpcStarted;

        RpcRunnable(SynchronousQueue<Object> rpcStarted) {
            this.rpcStarted = rpcStarted;
        }

        @Override
        public void run() {
            try {
                this.startServer();
            }
            catch (Throwable ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(ex)).log("JavaRuntime server could not start");
                try {
                    this.rpcStarted.put(ex);
                }
                catch (InterruptedException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
        }

        private void startServer() throws Exception {
            CloneControllerImplCallback callback = new CloneControllerImplCallback();
            CloneControllerImpl controller = new CloneControllerImpl(callback, JavaRuntime.this.deadlineOracle, JavaRuntime.this.requestManager, JavaRuntime.this.hotspotPerformanceData, JavaRuntime.this.cloudDebuggerAgent);
            JavaRuntime.this.rpcPlugin.startServer(JavaRuntime.this, controller);
            this.rpcStarted.put(JavaRuntime.this.rpcPlugin);
            try {
                ((GoogleLogger.Api)logger.atInfo()).log("Beginning accept loop.");
                JavaRuntime.this.rpcPlugin.blockUntilShutdown();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setServletEngine(ServletEngineAdapter var1);

        public abstract ServletEngineAdapter servletEngine();

        public abstract Builder setSandboxPlugin(NullSandboxPlugin var1);

        public abstract Builder setRpcPlugin(AnyRpcPlugin var1);

        public abstract AnyRpcPlugin rpcPlugin();

        public abstract Builder setSharedDirectory(File var1);

        public abstract File sharedDirectory();

        public abstract Builder setRequestManager(RequestManager var1);

        public abstract Builder setRuntimeVersion(String var1);

        public abstract String runtimeVersion();

        public abstract Builder setConfiguration(ApplicationEnvironment.RuntimeConfiguration var1);

        public abstract ApplicationEnvironment.RuntimeConfiguration configuration();

        public abstract Builder setDeadlineOracle(ApiDeadlineOracle var1);

        public abstract ApiDeadlineOracle deadlineOracle();

        public abstract Builder setCoordinator(BackgroundRequestCoordinator var1);

        public abstract Builder setCompressResponse(boolean var1);

        public abstract boolean compressResponse();

        public abstract Builder setEnableHotspotPerformanceMetrics(boolean var1);

        public abstract boolean enableHotspotPerformanceMetrics();

        public abstract Builder setCloudDebuggerAgent(CloudDebuggerAgentWrapper var1);

        public abstract Builder setCloudDebuggerEnabled(boolean var1);

        public abstract boolean cloudDebuggerEnabled();

        public abstract Builder setPollForNetwork(boolean var1);

        public abstract boolean pollForNetwork();

        public abstract Builder setDefaultToNativeUrlStreamHandler(boolean var1);

        public abstract boolean defaultToNativeUrlStreamHandler();

        public abstract Builder setForceUrlfetchUrlStreamHandler(boolean var1);

        public abstract boolean forceUrlfetchUrlStreamHandler();

        public abstract Builder setIgnoreDaemonThreads(boolean var1);

        public abstract boolean ignoreDaemonThreads();

        public abstract Builder setUseEnvVarsFromAppInfo(boolean var1);

        public abstract boolean useEnvVarsFromAppInfo();

        public abstract Builder setFixedApplicationPath(String var1);

        public abstract String fixedApplicationPath();

        public abstract Builder setRedirectStdoutStderr(boolean var1);

        public abstract boolean redirectStdoutStderr();

        public abstract Builder setLogJsonToFile(boolean var1);

        public abstract boolean logJsonToFile();

        public abstract Builder setClearLogHandlers(boolean var1);

        public abstract Builder setJsonLogDir(Path var1);

        public abstract Path jsonLogDir();

        public abstract JavaRuntime build();
    }
}

