/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.ApiHostClientFactory;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.apphosting.runtime.CloudDebuggerAgent;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.CloudDebuggerCallback;
import com.google.apphosting.runtime.JavaRuntime;
import com.google.apphosting.runtime.JavaRuntimeParams;
import com.google.apphosting.runtime.NullRpcPlugin;
import com.google.apphosting.runtime.NullSandboxPlugin;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RuntimeLogSink;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.apphosting.runtime.anyrpc.AnyRpcPlugin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class JavaRuntimeFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    @VisibleForTesting
    JavaRuntimeFactory() {
    }

    public static void startRuntime(NullSandboxPlugin sandboxPlugin, String[] args) {
        JavaRuntimeFactory factory = new JavaRuntimeFactory();
        factory.getStartedRuntime(sandboxPlugin, args);
    }

    public JavaRuntime getStartedRuntime(NullSandboxPlugin sandboxPlugin, String[] args) {
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs(args);
        List<String> unknownParams = params.getUnknownParams();
        if (!unknownParams.isEmpty()) {
            ((GoogleLogger.Api)logger.atWarning()).log("Unknown command line arguments: %s", unknownParams);
        }
        RuntimeLogSink logSink = new RuntimeLogSink(params.getMaxRuntimeLogPerRequest());
        logSink.addHandlerToRootLogger();
        JavaRuntimeFactory.maybeConfigureProfiler(params);
        if (params.getLogJettyExceptionsToAppLogs()) {
            System.setProperty("appengine.jetty.also_log_to_apiproxy", "true");
        }
        if (params.getUrlfetchDeriveResponseMessage()) {
            System.setProperty("appengine.urlfetch.deriveResponseMessage", "true");
        }
        if (params.getMailSupportExtendedAttachmentEncodings()) {
            System.setProperty("appengine.mail.supportExtendedAttachmentEncodings", "true");
        }
        if (params.getForceReadaheadOnCloudsqlSocket()) {
            System.setProperty("appengine.jdbc.forceReadaheadOnCloudsqlSocket", "true");
        }
        if (params.getMailFilenamePreventsInlining()) {
            System.setProperty("appengine.mail.filenamePreventsInlining", "true");
        }
        ServletEngineAdapter servletEngine = JavaRuntimeFactory.createServletEngine(params);
        ApiDeadlineOracle deadlineOracle = new ApiDeadlineOracle.Builder().initDeadlineMap(params.getApiCallDeadline(), params.getApiCallDeadlineMap(), params.getMaxApiCallDeadline(), params.getMaxApiCallDeadlineMap()).initOfflineDeadlineMap(params.getOfflineApiCallDeadline(), params.getOfflineApiCallDeadlineMap(), params.getMaxOfflineApiCallDeadline(), params.getMaxOfflineApiCallDeadlineMap()).build();
        AnyRpcPlugin rpcPlugin = JavaRuntimeFactory.loadRpcPlugin(params);
        rpcPlugin.initialize(params.getPort());
        ApiHostClientFactory apiHostFactory = new ApiHostClientFactory();
        BackgroundRequestCoordinator coordinator = new BackgroundRequestCoordinator();
        CloudDebuggerAgentWrapperImpl cloudDebuggerAgent = new CloudDebuggerAgentWrapperImpl();
        boolean cloudDebuggerEnabled = false;
        if (params.getEnableCloudDebugger()) {
            try {
                cloudDebuggerAgent.bind(JavaRuntimeFactory.class.getClassLoader());
                cloudDebuggerEnabled = true;
            }
            catch (Throwable ex) {
                ((GoogleLogger.Api)logger.atWarning()).log("Failed to bind to Cloud Debugger agent");
            }
        }
        ApiProxyImpl apiProxyImpl = ApiProxyImpl.builder().setApiHost(apiHostFactory.newAPIHost(params.getTrustedHost(), OptionalInt.of(params.getCloneMaxOutstandingApiRpcs()))).setDeadlineOracle(deadlineOracle).setExternalDatacenterName(params.getExternalDatacenterName()).setByteCountBeforeFlushing(params.getByteCountBeforeFlushing()).setMaxLogLineSize(params.getMaxLogLineSize()).setMaxLogFlushTime(Duration.ofSeconds(params.getMaxLogFlushSeconds())).setCoordinator(coordinator).setCloudSqlJdbcConnectivityEnabled(params.getEnableGaeCloudSqlJdbcConnectivity()).setDisableApiCallLogging(params.getDisableApiCallLogging()).build();
        RequestManager.Builder requestManagerBuilder = RequestManager.builder().setSoftDeadlineDelay(params.getJavaSoftDeadlineMs()).setHardDeadlineDelay(params.getJavaHardDeadlineMs()).setDisableDeadlineTimers(params.getUseCloneControllerForDeadlines()).setRuntimeLogSink(Optional.of(logSink)).setApiProxyImpl(apiProxyImpl).setMaxOutstandingApiRpcs(params.getCloneMaxOutstandingApiRpcs()).setThreadStopTerminatesClone(params.getThreadStopTerminatesClone()).setInterruptFirstOnSoftDeadline(params.getInterruptThreadsFirstOnSoftDeadline()).setCloudDebuggerAgent(cloudDebuggerAgent).setEnableCloudDebugger(cloudDebuggerEnabled).setCyclesPerSecond(params.getCyclesPerSecond()).setWaitForDaemonRequestThreads(params.getWaitForDaemonRequestThreads());
        RequestManager requestManager = this.makeRequestManager(requestManagerBuilder);
        apiProxyImpl.setRequestManager(requestManager);
        ApplicationEnvironment.RuntimeConfiguration configuration = ApplicationEnvironment.RuntimeConfiguration.builder().setCloudSqlJdbcConnectivityEnabled(params.getEnableGaeCloudSqlJdbcConnectivity()).setUseGoogleConnectorJ(params.getDefaultUseGoogleConnectorj()).build();
        JavaRuntime.Builder runtimeBuilder = JavaRuntime.builder().setServletEngine(servletEngine).setSandboxPlugin(sandboxPlugin).setRpcPlugin(rpcPlugin).setSharedDirectory(new File(params.getApplicationRoot())).setRequestManager(requestManager).setRuntimeVersion("Google App Engine/" + params.getAppengineReleaseName()).setConfiguration(configuration).setDeadlineOracle(deadlineOracle).setCoordinator(coordinator).setCompressResponse(params.getRuntimeHttpCompression()).setEnableHotspotPerformanceMetrics(params.getEnableHotspotPerformanceMetrics()).setCloudDebuggerAgent(cloudDebuggerAgent).setCloudDebuggerEnabled(cloudDebuggerEnabled).setPollForNetwork(params.getPollForNetwork()).setDefaultToNativeUrlStreamHandler(params.getDefaultToNativeUrlStreamHandler()).setForceUrlfetchUrlStreamHandler(params.getForceUrlfetchUrlStreamHandler()).setIgnoreDaemonThreads(!params.getWaitForDaemonRequestThreads()).setUseEnvVarsFromAppInfo(params.getUseEnvVarsFromAppInfo()).setFixedApplicationPath(params.getFixedApplicationPath()).setRedirectStdoutStderr(!params.getUseJettyHttpProxy()).setLogJsonToFile(params.getLogJsonToVarLog());
        JavaRuntime runtime = this.makeRuntime(runtimeBuilder);
        ApiProxy.setDelegate((ApiProxy.Delegate)apiProxyImpl);
        ServletEngineAdapter.Config runtimeOptions = ServletEngineAdapter.Config.builder().setUseJettyHttpProxy(params.getUseJettyHttpProxy()).setApplicationRoot(params.getApplicationRoot()).setFixedApplicationPath(params.getFixedApplicationPath()).setJettyHttpAddress(HostAndPort.fromParts("0.0.0.0", params.getJettyHttpPort())).setJettyRequestHeaderSize(params.getJettyRequestHeaderSize()).setJettyResponseHeaderSize(params.getJettyResponseHeaderSize()).setEvaluationRuntimeServerInterface(runtime).build();
        try {
            runtime.start(runtimeOptions);
        }
        catch (Exception e) {
            try {
                runtime.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException("Could not start server", e);
        }
        return runtime;
    }

    public JavaRuntime makeRuntime(JavaRuntime.Builder runtimeBuilder) {
        return runtimeBuilder.build();
    }

    public RequestManager makeRequestManager(RequestManager.Builder builder) {
        return builder.build();
    }

    private static AnyRpcPlugin loadRpcPlugin(JavaRuntimeParams params) {
        if (params.getUseJettyHttpProxy()) {
            return new NullRpcPlugin();
        }
        try {
            Class<AnyRpcPlugin> pluginClass = Class.forName("com.google.apphosting.runtime.grpc.GrpcPlugin").asSubclass(AnyRpcPlugin.class);
            Constructor<AnyRpcPlugin> pluginConstructor = pluginClass.getConstructor(new Class[0]);
            return pluginConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load RPC plugin", e);
        }
    }

    private static ServletEngineAdapter createServletEngine(JavaRuntimeParams params) {
        Class<? extends ServletEngineAdapter> engineClazz = params.getServletEngine();
        if (engineClazz == null) {
            throw new RuntimeException("No servlet engine (--servlet_engine) defined in the parameters.");
        }
        try {
            return engineClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Failed to instantiate " + engineClazz, ex);
        }
    }

    private static void maybeConfigureProfiler(JavaRuntimeParams params) {
        if (params.getEnableCloudCpuProfiler() || params.getEnableCloudHeapProfiler()) {
            try {
                Class<?> profilerClass = Class.forName("com.google.cloud.profiler.agent.Profiler");
                Class<?> profilerConfigClass = Class.forName("com.google.cloud.profiler.agent.Profiler$Config");
                Object profilerConfig = profilerConfigClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method setCpuProfilerEnabled = profilerConfigClass.getMethod("setCpuProfilerEnabled", Boolean.TYPE);
                Method setHeapProfilerEnabled = profilerConfigClass.getMethod("setHeapProfilerEnabled", Boolean.TYPE);
                setCpuProfilerEnabled.invoke(profilerConfig, params.getEnableCloudCpuProfiler());
                setHeapProfilerEnabled.invoke(profilerConfig, params.getEnableCloudHeapProfiler());
                Method start = profilerClass.getMethod("start", profilerConfigClass);
                start.invoke(null, profilerConfig);
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to start the profiler");
            }
        }
    }

    static class CloudDebuggerAgentWrapperImpl
    implements CloudDebuggerAgentWrapper {
        CloudDebuggerAgentWrapperImpl() {
        }

        @Override
        public void bind(ClassLoader debuggerInternalsClassLoader) {
            CloudDebuggerAgent.bind(debuggerInternalsClassLoader);
        }

        @Override
        public void setApplication(String[] classPath, CloudDebuggerCallback callback) {
            CloudDebuggerAgent.setApplication(classPath, callback);
        }

        @Override
        public void setActiveBreakpoints(byte[][] breakpoints) {
            CloudDebuggerAgent.setActiveBreakpoints(breakpoints);
        }

        @Override
        public boolean hasBreakpointUpdates() {
            return CloudDebuggerAgent.hasBreakpointUpdates();
        }

        @Override
        public byte[][] dequeueBreakpointUpdates() {
            return CloudDebuggerAgent.dequeueBreakpointUpdates();
        }
    }
}

