/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.apphosting.runtime.ParameterFactory;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.util.List;
import java.util.Random;

@Parameters(separators="=")
final class JavaRuntimeParams {
    private Class<? extends ServletEngineAdapter> servletEngineClass;
    @Parameter(description="Root path for application data on the local filesystem.", names={"--application_root"})
    private String applicationRoot = "appdata";
    @Parameter(description="Port number to expose our EvaluationRuntime service on.", names={"--port"})
    private int port = 0;
    @Parameter(description="Specification used for connecting back to the appserver.", names={"--trusted_host"})
    private String trustedHost = "";
    @Parameter(description="Number of milliseconds before the deadline for a request to throw an uncatchable exception.", names={"--java_hard_deadline_ms"})
    private int javaHardDeadlineMs = 200;
    @Parameter(description="Number of milliseconds before the deadline for a request to throw a catchable exception.", names={"--java_soft_deadline_ms"})
    private int javaSoftDeadlineMs = 600;
    @Parameter(description="Default deadline for all API RPCs, in seconds.", names={"--api_call_deadline"})
    private double apiCallDeadline = 5.0;
    @Parameter(description="Maximum deadline for all API RPCs, in seconds.", names={"--max_api_call_deadline"})
    private double maxApiCallDeadline = 10.0;
    @Parameter(description="Default deadline for all API RPCs by package in seconds.", names={"--api_call_deadline_map"})
    private String apiCallDeadlineMap = "";
    @Parameter(description="Maximum deadline for all API RPCs by package in seconds.", names={"--max_api_call_deadline_map"})
    private String maxApiCallDeadlineMap = "";
    @Parameter(description="Default deadline for all offline API RPCs, in seconds.", names={"--offline_api_call_deadline"})
    private double offlineApiCallDeadline = 5.0;
    @Parameter(description="Maximum deadline for all offline API RPCs, in seconds.", names={"--max_offline_api_call_deadline"})
    private double maxOfflineApiCallDeadline = 10.0;
    @Parameter(description="Default deadline for all offline API RPCs by package in seconds.", names={"--offline_api_call_deadline_map"})
    private String offlineApiCallDeadlineMap = "";
    @Parameter(description="Maximum deadline for all offline API RPCs by package in seconds.", names={"--max_offline_api_call_deadline_map"})
    private String maxOfflineApiCallDeadlineMap = "";
    @Parameter(description="A base-64 encoded string of entropy for the CSPRNG.", names={"--entropy_string"})
    private String entropyString = JavaRuntimeParams.pseudoRandomBytes();
    @Parameter(description="The name for the current release of Google App Engine.", names={"--appengine_release_name"})
    private String appengineReleaseName = "unknown";
    @Parameter(description="If true, exceptions logged by Jetty also go to app logs.", names={"--log_jetty_exceptions_to_app_logs"}, arity=1)
    private boolean logJettyExceptionsToAppLogs = true;
    @Parameter(description="Identifier for this datacenter.", names={"--external_datacenter_name"})
    private String externalDatacenterName = null;
    @Parameter(description="The maximum number of simultaneous APIHost RPCs.", names={"--clone_max_outstanding_api_rpcs"})
    private int cloneMaxOutstandingApiRpcs = 100;
    @Parameter(description="Always terminate the clone when Thread.stop() is used.", names={"--thread_stop_terminates_clone"}, arity=1)
    private boolean threadStopTerminatesClone = true;
    @Parameter(description="Deprecated.", names={"--default_max_api_request_size"})
    private int maxApiRequestSize = 0x100000;
    @Parameter(description="Deprecated.", names={"--max_api_request_size_map"})
    private String maxApiRequestSizeMap = "";
    @Parameter(description="Flush application logs when they grow to this size.", names={"--byte_count_before_flushing"})
    private long byteCountBeforeFlushing = 102400L;
    @Parameter(description="Maximum application log line size.", names={"--max_log_line_size"})
    private int maxLogLineSize = 16384;
    @Parameter(description="Maximum number of seconds a log record should be allowed to to be cached in the runtime before being flushed to the appserver (only applies to non-frontend requests).", names={"--max_log_flush_seconds"})
    private int maxLogFlushSeconds = 60;
    @Parameter(description="Should we use CloneController.sendDeadline for request deadlines instead of using timers.", names={"--use_clone_controller_for_deadlines"}, arity=1)
    private boolean useCloneControllerForDeadlines = false;
    @Parameter(description="Compress HTTP responses in the runtime.", names={"--runtime_http_compression"}, arity=1)
    private boolean runtimeHttpCompression = false;
    @Parameter(description="The maximum allowed size in bytes of the Runtime Log per request, returned in the UPResponse.", names={"--max_runtime_log_per_request"})
    private long maxRuntimeLogPerRequest = 0x2EE000L;
    @Parameter(description="Whether to use the JDBC connectivity for accessing Cloud SQL through the AppEngine Java applications.", names={"--enable_gae_cloud_sql_jdbc_connectivity"}, arity=1)
    private boolean enableGaeCloudSqlJdbcConnectivity = false;
    @Parameter(description="Whether to use google connector-j by default even if it's not explicitly set in appengine-web.xml.", names={"--default_use_google_connectorj"}, arity=1)
    private boolean defaultUseGoogleConnectorj = false;
    @Parameter(description="On a soft deadline, attempt to interrupt application threads first, then stop them only if necessary", names={"--interrupt_threads_first_on_soft_deadline"}, arity=1)
    private boolean interruptThreadsFirstOnSoftDeadline = false;
    @Parameter(description="Whether to enable exporting of hotspot performance metrics.", names={"--enable_hotspot_performance_metrics"}, arity=1)
    private boolean enableHotspotPerformanceMetrics = false;
    @Parameter(description="Enables Java Cloud Debugger JVMTI agent loaded in the process.", names={"--enable_cloud_debugger"}, arity=1)
    private boolean enableCloudDebugger = false;
    @Parameter(description="Enables Java Cloud Profiler CPU usage agent in the process.", names={"--enable_cloud_cpu_profiler"}, arity=1)
    private boolean enableCloudCpuProfiler = false;
    @Parameter(description="Enables Java Cloud Profiler heap usage agent in the process.", names={"--enable_cloud_heap_profiler"}, arity=1)
    private boolean enableCloudHeapProfiler = false;
    @Parameter(description="Allows URLFetch to generate response messages based on HTTP return codes.", names={"--urlfetch_derive_response_message"}, arity=1)
    private boolean urlfetchDeriveResponseMessage = true;
    @Parameter(description="Prevent the Mail API from inlining attachments with filenames.", names={"--mail_filename_prevents_inlining"}, arity=1)
    private boolean mailFilenamePreventsInlining = false;
    @Parameter(description="Support byte[] and nested Multipart-encoded Mail attachments", names={"--mail_support_extended_attachment_encodings"}, arity=1)
    private boolean mailSupportExtendedAttachmentEncodings = false;
    @Parameter(description="Always enable readahead on a CloudSQL socket", names={"--force_readahead_on_cloudsql_socket"}, arity=1)
    private boolean forceReadaheadOnCloudsqlSocket = false;
    @Parameter(description="Speed of the processor in clock cycles per second.", names={"--cycles_per_second"}, arity=1)
    private long cyclesPerSecond = 0L;
    @Parameter(description="Wait for request threads with the daemon bit set before considering a request complete.", names={"--wait_for_daemon_request_threads"}, arity=1)
    private boolean waitForDaemonRequestThreads = true;
    @Parameter(description="Poll for network connectivity before running application code.", names={"--poll_for_network"}, arity=1)
    private boolean pollForNetwork = false;
    @Parameter(description="Default url-stream-handler to 'native' instead of 'urlfetch'.", names={"--default_to_native_url_stream_handler", "--default_to_builtin_url_stream_handler"}, arity=1)
    private boolean defaultToNativeUrlStreamHandler = false;
    @Parameter(description="Force url-stream-handler to 'urlfetch' irrespective of the contents of the appengine-web.xml descriptor.", names={"--force_urlfetch_url_stream_handler"}, arity=1)
    private boolean forceUrlfetchUrlStreamHandler = false;
    @Parameter(description="Enable synchronization inside of AppLogsWriter.", names={"--enable_synchronized_app_logs_writer"}, arity=1)
    private boolean enableSynchronizedAppLogsWriter = true;
    @Parameter(description="Use environment variables from the AppInfo instead of those in the appengine-web.xml descriptor.", names={"--use_env_vars_from_app_info"}, arity=1)
    private boolean useEnvVarsFromAppInfo = false;
    @Parameter(description="Fixed path to use for the application root directory, irrespective of the application id and version. Ignored if empty.", names={"--fixed_application_path"})
    private String fixedApplicationPath = null;
    @Parameter(description="Enable a Jetty server listening to HTTP requests and forwarding via RPC to the java runtime.", names={"--use_jetty_http_proxy"}, arity=1)
    private boolean useJettyHttpProxy = false;
    @Parameter(description="Jetty HTTP Port number to use for http access to the runtime.", names={"--jetty_http_port"})
    private int jettyHttpPort = 8080;
    @Parameter(description="Jetty server's max size for HTTP request headers.", names={"--jetty_request_header_size"})
    private int jettyRequestHeaderSize = 16384;
    @Parameter(description="Jetty server's max size for HTTP response headers.", names={"--jetty_response_header_size"})
    private int jettyResponseHeaderSize = 16384;
    @Parameter(description="Disable API call logging in the runtime.", names={"--disable_api_call_logging"}, arity=1)
    private boolean disableApiCallLogging = false;
    @Parameter(description="Configure java.util.logging to log JSON messages to /var/log/app.", names={"--log_json_to_var_log"}, arity=1)
    private boolean logJsonToVarLog = false;
    @Parameter(description="Enable using riptide for user code.", names={"--java8_riptide"}, arity=1)
    private boolean java8Riptide = false;
    private List<String> unknownParams;

    private static String pseudoRandomBytes() {
        byte[] bytes = new byte[32];
        new Random().nextBytes(bytes);
        return BaseEncoding.base64().encode(bytes);
    }

    private JavaRuntimeParams() {
    }

    public static JavaRuntimeParams parseArgs(String ... args) {
        ImmutableList<String> argsList = ImmutableList.copyOf(args);
        argsList = ParameterFactory.expandBooleanParams(argsList, JavaRuntimeParams.class);
        args = argsList.toArray(new String[0]);
        JavaRuntimeParams parameters = new JavaRuntimeParams();
        JCommander jCommander = new JCommander(parameters);
        jCommander.setProgramName("JavaRuntimeParams");
        jCommander.addConverterFactory(new ParameterFactory());
        jCommander.setAllowParameterOverwriting(true);
        jCommander.setAcceptUnknownOptions(true);
        try {
            jCommander.parse(args);
            parameters.initServletEngineClass();
        }
        catch (ParameterException exception) {
            jCommander.usage();
            throw exception;
        }
        parameters.unknownParams = jCommander.getUnknownOptions();
        return parameters;
    }

    boolean getLogJettyExceptionsToAppLogs() {
        return this.logJettyExceptionsToAppLogs;
    }

    boolean getEnableCloudDebugger() {
        return this.enableCloudDebugger;
    }

    boolean getEnableCloudCpuProfiler() {
        return this.enableCloudCpuProfiler;
    }

    boolean getEnableCloudHeapProfiler() {
        return this.enableCloudHeapProfiler;
    }

    Class<? extends ServletEngineAdapter> getServletEngine() {
        return this.servletEngineClass;
    }

    private void initServletEngineClass() {
        String servletEngine = "com.google.apphosting.runtime.jetty94.JettyServletEngineAdapter";
        try {
            this.servletEngineClass = Class.forName(servletEngine).asSubclass(ServletEngineAdapter.class);
        }
        catch (ClassNotFoundException nfe) {
            throw new ParameterException("No class name with the given name " + servletEngine + " could be found");
        }
        catch (ClassCastException cce) {
            throw new ParameterException("Not a subtype of " + ServletEngineAdapter.class.getName());
        }
    }

    String getApplicationRoot() {
        return this.applicationRoot;
    }

    int getPort() {
        return this.port;
    }

    String getTrustedHost() {
        return this.trustedHost;
    }

    int getJavaHardDeadlineMs() {
        return this.javaHardDeadlineMs;
    }

    int getJavaSoftDeadlineMs() {
        return this.javaSoftDeadlineMs;
    }

    double getApiCallDeadline() {
        return this.apiCallDeadline;
    }

    double getMaxApiCallDeadline() {
        return this.maxApiCallDeadline;
    }

    String getApiCallDeadlineMap() {
        return this.apiCallDeadlineMap;
    }

    String getMaxApiCallDeadlineMap() {
        return this.maxApiCallDeadlineMap;
    }

    double getOfflineApiCallDeadline() {
        return this.offlineApiCallDeadline;
    }

    double getMaxOfflineApiCallDeadline() {
        return this.maxOfflineApiCallDeadline;
    }

    String getOfflineApiCallDeadlineMap() {
        return this.offlineApiCallDeadlineMap;
    }

    String getMaxOfflineApiCallDeadlineMap() {
        return this.maxOfflineApiCallDeadlineMap;
    }

    String getEntropyString() {
        return this.entropyString;
    }

    String getAppengineReleaseName() {
        return this.appengineReleaseName;
    }

    String getExternalDatacenterName() {
        return this.externalDatacenterName;
    }

    int getCloneMaxOutstandingApiRpcs() {
        return this.cloneMaxOutstandingApiRpcs;
    }

    boolean getThreadStopTerminatesClone() {
        return this.threadStopTerminatesClone;
    }

    int getMaxApiRequestSize() {
        return this.maxApiRequestSize;
    }

    String getMaxApiRequestSizeMap() {
        return this.maxApiRequestSizeMap;
    }

    long getByteCountBeforeFlushing() {
        return this.byteCountBeforeFlushing;
    }

    int getMaxLogLineSize() {
        return this.maxLogLineSize;
    }

    int getMaxLogFlushSeconds() {
        return this.maxLogFlushSeconds;
    }

    boolean getUseCloneControllerForDeadlines() {
        return this.useCloneControllerForDeadlines;
    }

    boolean getRuntimeHttpCompression() {
        return this.runtimeHttpCompression;
    }

    long getMaxRuntimeLogPerRequest() {
        return this.maxRuntimeLogPerRequest;
    }

    boolean getEnableGaeCloudSqlJdbcConnectivity() {
        return this.enableGaeCloudSqlJdbcConnectivity;
    }

    boolean getDefaultUseGoogleConnectorj() {
        return this.defaultUseGoogleConnectorj;
    }

    boolean getInterruptThreadsFirstOnSoftDeadline() {
        return this.interruptThreadsFirstOnSoftDeadline;
    }

    boolean getEnableHotspotPerformanceMetrics() {
        return this.enableHotspotPerformanceMetrics;
    }

    boolean getUrlfetchDeriveResponseMessage() {
        return this.urlfetchDeriveResponseMessage;
    }

    boolean getMailFilenamePreventsInlining() {
        return this.mailFilenamePreventsInlining;
    }

    boolean getMailSupportExtendedAttachmentEncodings() {
        return this.mailSupportExtendedAttachmentEncodings;
    }

    boolean getForceReadaheadOnCloudsqlSocket() {
        return this.forceReadaheadOnCloudsqlSocket;
    }

    long getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    boolean getWaitForDaemonRequestThreads() {
        return this.waitForDaemonRequestThreads;
    }

    boolean getPollForNetwork() {
        return this.pollForNetwork;
    }

    boolean getDefaultToNativeUrlStreamHandler() {
        return this.defaultToNativeUrlStreamHandler;
    }

    boolean getForceUrlfetchUrlStreamHandler() {
        return this.forceUrlfetchUrlStreamHandler;
    }

    boolean getEnableSynchronizedAppLogsWriter() {
        return this.enableSynchronizedAppLogsWriter;
    }

    boolean getUseEnvVarsFromAppInfo() {
        return this.useEnvVarsFromAppInfo;
    }

    boolean getUseJettyHttpProxy() {
        return this.useJettyHttpProxy;
    }

    int getJettyHttpPort() {
        return this.jettyHttpPort;
    }

    int getJettyRequestHeaderSize() {
        return this.jettyRequestHeaderSize;
    }

    int getJettyResponseHeaderSize() {
        return this.jettyResponseHeaderSize;
    }

    String getFixedApplicationPath() {
        return this.fixedApplicationPath;
    }

    boolean getDisableApiCallLogging() {
        return Boolean.getBoolean("disable_api_call_logging_in_apiproxy") || this.disableApiCallLogging;
    }

    boolean getLogJsonToVarLog() {
        return this.logJsonToVarLog;
    }

    boolean getJava8Riptide() {
        return this.java8Riptide;
    }

    List<String> getUnknownParams() {
        return this.unknownParams;
    }
}

