/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.JsonLogHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.annotation.Nullable;

public final class Logging {
    private static final Logger logger = Logger.getLogger(Logging.class.getName());
    private final Logger rootLogger;

    public Logging() {
        this(Logger.getLogger(""));
    }

    Logging(Logger rootLogger) {
        this.rootLogger = rootLogger;
    }

    static Properties loadUserLogProperties(String userLogConfigFilePath) {
        Properties configProps = new Properties();
        if (userLogConfigFilePath != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(userLogConfigFilePath), StandardCharsets.UTF_8));){
                configProps.load(br);
            }
            catch (IOException | IllegalArgumentException e) {
                logger.log(Level.WARNING, "Unable to read the java.util.logging configuration file.", e);
            }
        }
        return configProps;
    }

    private static void processLogConfigSection(Properties configProps, ClassLoader appClassLoader) {
        String configClasses = configProps.getProperty("config");
        if (configClasses == null) {
            return;
        }
        for (String configClass : Logging.splitList(configClasses)) {
            try {
                Class<?> configType = appClassLoader.loadClass(configClass);
                configType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to instantiate config object: " + configClass, e);
            }
        }
        configProps.remove("config");
    }

    private void processLogHandlersAndLevels(Properties configProps) {
        Properties logManagerProperties = null;
        try {
            Field propsField = LogManager.class.getDeclaredField("props");
            propsField.setAccessible(true);
            logManagerProperties = (Properties)propsField.get(LogManager.getLogManager());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to access the LogManager properties.", e);
            return;
        }
        Set<String> handlers = Logging.splitList(configProps.getProperty("handlers"));
        for (String property : configProps.stringPropertyNames()) {
            if (!property.endsWith(".level")) continue;
            String name = property.substring(0, property.length() - ".level".length());
            if (handlers.contains(name)) {
                configProps.remove(property);
                continue;
            }
            logManagerProperties.put(name + ".level", configProps.getProperty(property));
        }
        configProps.remove("handlers");
        String globalLevel = configProps.getProperty(".level");
        if (globalLevel != null) {
            try {
                this.rootLogger.setLevel(Level.parse(globalLevel));
                this.rootLogger.setUseParentHandlers(false);
                logManagerProperties.put(".level", globalLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static Set<String> splitList(String list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<String> tokens = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(list, " ,");
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    void redirectStdoutStderr(String identifier) {
        String prefix = "[" + identifier + "].";
        System.setOut(new LogPrintStream(new LogStream(Level.INFO, Logger.getLogger(prefix + "<stdout>"))));
        System.setErr(new LogPrintStream(new LogStream(Level.WARNING, Logger.getLogger(prefix + "<stderr>"))));
    }

    public void applyLogProperties(String userLogConfigFilePath, ClassLoader appClassLoader) {
        Properties configProps = Logging.loadUserLogProperties(userLogConfigFilePath);
        Logging.processLogConfigSection(configProps, appClassLoader);
        this.processLogHandlersAndLevels(configProps);
    }

    public void logJsonToFile(@Nullable String projectId, Path logPath, boolean clearLogHandlers) {
        PrintStream printStream;
        try {
            printStream = new PrintStream(logPath.toFile());
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "Unable to create log handler to " + logPath, e);
            return;
        }
        Formatter formatter = new SimpleFormatter();
        for (Handler handler : this.rootLogger.getHandlers()) {
            if (clearLogHandlers) {
                this.rootLogger.removeHandler(handler);
            }
            if (handler.getFormatter() == null) continue;
            formatter = handler.getFormatter();
        }
        JsonLogHandler logHandler = new JsonLogHandler(printStream, false, projectId, formatter);
        if (clearLogHandlers) {
            logHandler.init(this.rootLogger);
        } else {
            this.rootLogger.addHandler(logHandler);
        }
    }

    static class LogStream
    extends OutputStream {
        private final Logger logger;
        private final Level level;
        private ByteArrayOutputStream output = new ByteArrayOutputStream(4096);

        public LogStream(Level level, Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger argument must not be null");
            }
            this.level = level;
            this.logger = logger;
        }

        @Override
        public void write(int b) throws IOException {
            this.output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            byte[] buffer = this.output.toByteArray();
            if (buffer.length == 0) {
                return;
            }
            String msg = new String(buffer, StandardCharsets.UTF_8);
            LogRecord record = new LogRecord(this.level, msg);
            record.setSourceClassName(null);
            record.setSourceMethodName(null);
            record.setLoggerName(this.logger.getName());
            this.logger.log(record);
            this.output.reset();
        }
    }

    private static class LogPrintStream
    extends PrintStream {
        public LogPrintStream(OutputStream out) {
            super(out, false);
        }

        @Override
        public void println(Object x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(String x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(char[] x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(double x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(float x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(long x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(int x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(char x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println(boolean x) {
            super.println(x);
            this.flush();
        }

        @Override
        public void println() {
            super.println();
            this.flush();
        }

        @Override
        public void print(char c) {
            super.print(c);
            if (c == '\n') {
                this.flush();
            }
        }

        @Override
        public void print(char[] s) {
            boolean flush = false;
            super.print(s);
            for (int i = 0; i < s.length; ++i) {
                if (s[i] != '\n') continue;
                flush = true;
            }
            if (flush) {
                this.flush();
            }
        }

        @Override
        public void print(String s) {
            super.print(s);
            if (s != null && s.indexOf(10) != -1) {
                this.flush();
            }
        }

        @Override
        public void print(Object obj) {
            this.print(String.valueOf(obj));
        }
    }
}

