/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.List;

public class MutableUpResponse {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final RuntimePb.UPResponse.Builder builder = RuntimePb.UPResponse.newBuilder();

    public synchronized RuntimePb.UPResponse build() {
        if (this.builder.hasHttpResponse()) {
            HttpPb.HttpResponse httpResponse = this.builder.getHttpResponse();
            if (!httpResponse.hasResponse()) {
                this.setHttpResponseResponse(ByteString.EMPTY);
            }
            if (!httpResponse.hasResponsecode()) {
                ((GoogleLogger.Api)logger.atWarning()).log("UPResponse missing http_response.response_code");
                this.setHttpResponseCode(400);
            }
        }
        try {
            return this.builder.build();
        }
        catch (Throwable t) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(t)).log("Cannot build UPResponse");
            return this.builder.buildPartial();
        }
    }

    boolean isInitialized() {
        return this.builder.isInitialized();
    }

    public synchronized int getError() {
        return this.builder.getError();
    }

    public synchronized void setError(int error) {
        this.builder.setError(error);
    }

    public synchronized void setErrorMessage(String message) {
        this.builder.setErrorMessage(message);
    }

    synchronized boolean hasSerializedTrace() {
        return this.builder.hasSerializedTrace();
    }

    synchronized ByteString getSerializedTrace() {
        return this.builder.getSerializedTrace();
    }

    synchronized void setSerializedTrace(ByteString bytes) {
        this.builder.setSerializedTrace(bytes);
    }

    synchronized int getAppLogCount() {
        return this.builder.getAppLogCount();
    }

    @VisibleForTesting
    public AppLogsPb.AppLogLine getAppLog(int i) {
        return this.builder.getAppLog(i);
    }

    synchronized ImmutableList<AppLogsPb.AppLogLine> getAndClearAppLogList() {
        ImmutableList<AppLogsPb.AppLogLine> logList = ImmutableList.copyOf(this.builder.getAppLogList());
        this.builder.clearAppLog();
        return logList;
    }

    synchronized void addAppLog(AppLogsPb.AppLogLine line) {
        this.builder.addAppLog(line);
    }

    synchronized void addAppLog(AppLogsPb.AppLogLine.Builder line) {
        this.builder.addAppLog(line);
    }

    synchronized void setPendingCloudDebuggerActionBreakpointUpdates(boolean x) {
        this.builder.getPendingCloudDebuggerActionBuilder().setBreakpointUpdates(x);
    }

    synchronized void setPendingCloudDebuggerActionDebuggeeRegistration(boolean x) {
        this.builder.getPendingCloudDebuggerActionBuilder().setDebuggeeRegistration(x);
    }

    synchronized boolean hasPendingCloudDebuggerAction() {
        return this.builder.hasPendingCloudDebuggerAction();
    }

    synchronized RuntimePb.PendingCloudDebuggerAction getPendingCloudDebuggerAction() {
        return this.builder.getPendingCloudDebuggerAction();
    }

    synchronized void setUserMcycles(long cycles) {
        this.builder.setUserMcycles(cycles);
    }

    synchronized void addAllRuntimeLogLine(Collection<RuntimePb.UPResponse.RuntimeLogLine> lines) {
        this.builder.addAllRuntimeLogLine(lines);
    }

    synchronized int getRuntimeLogLineCount() {
        return this.builder.getRuntimeLogLineCount();
    }

    synchronized RuntimePb.UPResponse.RuntimeLogLine getRuntimeLogLine(int i) {
        return this.builder.getRuntimeLogLine(i);
    }

    synchronized boolean getTerminateClone() {
        return this.builder.getTerminateClone();
    }

    synchronized void setTerminateClone(boolean terminate) {
        this.builder.setTerminateClone(terminate);
    }

    synchronized boolean hasCloneIsInUncleanState() {
        return this.builder.hasCloneIsInUncleanState();
    }

    synchronized boolean getCloneIsInUncleanState() {
        return this.builder.getCloneIsInUncleanState();
    }

    synchronized void setCloneIsInUncleanState(boolean unclean) {
        this.builder.setCloneIsInUncleanState(unclean);
    }

    synchronized List<HttpPb.ParsedHttpHeader> getRuntimeHeadersList() {
        return this.builder.getRuntimeHeadersList();
    }

    synchronized void addRuntimeHeaders(HttpPb.ParsedHttpHeader.Builder header) {
        this.builder.addRuntimeHeaders(header);
    }

    public synchronized void clearHttpResponse() {
        this.builder.clearHttpResponse();
    }

    public synchronized boolean hasHttpResponse() {
        return this.builder.hasHttpResponse();
    }

    public synchronized HttpPb.HttpResponse getHttpResponse() {
        return this.builder.getHttpResponse();
    }

    public synchronized boolean hasHttpResponseResponse() {
        return this.builder.getHttpResponseBuilder().hasResponse();
    }

    public synchronized ByteString getHttpResponseResponse() {
        return this.builder.getHttpResponseBuilder().getResponse();
    }

    public synchronized void setHttpResponseResponse(ByteString string) {
        this.builder.getHttpResponseBuilder().setResponse(string);
    }

    public synchronized void setHttpResponseCodeAndResponse(int code, String string) {
        this.builder.getHttpResponseBuilder().setResponsecode(code).setResponse(ByteString.copyFromUtf8(string));
    }

    public synchronized void setHttpResponseCode(int code) {
        this.builder.getHttpResponseBuilder().setResponsecode(code);
    }

    synchronized void setHttpUncompressedSize(long size) {
        this.builder.getHttpResponseBuilder().setUncompressedSize(size);
    }

    synchronized void setHttpUncompressForClient(boolean uncompress) {
        this.builder.getHttpResponseBuilder().setUncompressForClient(uncompress);
    }

    public synchronized void addHttpResponseHeader(HttpPb.ParsedHttpHeader.Builder header) {
        this.builder.getHttpResponseBuilder().addOutputHeaders(header);
    }

    public synchronized List<HttpPb.ParsedHttpHeader> getHttpOutputHeadersList() {
        return this.builder.getHttpResponseBuilder().getOutputHeadersList();
    }

    public synchronized void addHttpOutputHeaders(HttpPb.ParsedHttpHeader.Builder header) {
        this.builder.getHttpResponseBuilder().addOutputHeaders(header);
    }
}

