/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.AppLogsWriter;
import com.google.apphosting.runtime.LogHandler;
import java.util.logging.LogRecord;

public final class NullSandboxLogHandler
extends LogHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            String message = null;
            Exception exception = null;
            NullSandboxLogHandler nullSandboxLogHandler = this;
            synchronized (nullSandboxLogHandler) {
                try {
                    message = this.getFormatter().format(record);
                }
                catch (Exception ex) {
                    exception = ex;
                }
            }
            if (exception != null) {
                this.reportError(null, exception, 5);
                return;
            }
            if (message != null) {
                ApiProxy.log((ApiProxy.LogRecord)this.convertLogRecord(record, message));
            }
        }
    }

    private boolean logSourceLocationFor(LogRecord record) {
        return record.getSourceClassName() != null && record.getSourceMethodName() != null;
    }

    private ApiProxy.LogRecord convertLogRecord(LogRecord record, String message) {
        ApiProxy.LogRecord.Level level = AppLogsWriter.convertLogLevel(record.getLevel());
        long timestamp = record.getMillis() * 1000L;
        if (this.logSourceLocationFor(record)) {
            StackTraceElement stackFrame = new StackTraceElement(record.getSourceClassName(), record.getSourceMethodName(), null, -1);
            return new ApiProxy.LogRecord(level, timestamp, message, stackFrame);
        }
        return new ApiProxy.LogRecord(level, timestamp, message);
    }

    @Override
    public void flush() {
        ApiProxy.flushLogs();
    }

    @Override
    public void close() {
        this.flush();
    }
}

