/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ApplicationClassLoader;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.ClassPathUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NullSandboxPlugin {
    private static final Logger rootLogger = Logger.getLogger("");
    static final String ALWAYS_SCAN_CLASS_DIRS_PROPERTY = "com.google.appengine.always.scan.class.dirs";
    private volatile ClassLoader runtimeLoader;
    private volatile ClassLoader applicationLoader;
    private volatile ClassPathUtils classPathUtils;
    private ClassLoader sharedClassLoader;

    public NullSandboxPlugin() {
    }

    public NullSandboxPlugin(ClassLoader runtimeLoader, ClassLoader sharedLoader, ClassPathUtils classPathUtils) {
        this.sharedClassLoader = sharedLoader;
        this.classPathUtils = classPathUtils;
        this.runtimeLoader = runtimeLoader;
    }

    public ClassLoader createRuntimeClassLoader(ClassPathUtils classPathUtils, String appsRoot) {
        if (this.runtimeLoader != null) {
            throw new IllegalStateException("createRuntimeClassLoader already called");
        }
        ClassLoader loader = this.doCreateRuntimeClassLoader(classPathUtils, appsRoot);
        this.classPathUtils = classPathUtils;
        this.runtimeLoader = loader;
        return loader;
    }

    protected ClassLoader doCreateRuntimeClassLoader(ClassPathUtils classPathUtils, String appsRoot) {
        this.sharedClassLoader = new URLClassLoader(classPathUtils.getRuntimeSharedUrls());
        return new URLClassLoader(classPathUtils.getRuntimeImplUrls(), this.sharedClassLoader);
    }

    public ClassLoader getApplicationClassLoader() {
        this.checkApplicationClassLoader();
        return this.applicationLoader;
    }

    public ClassLoader createApplicationClassLoader(URL[] userUrls, File contextRoot, ApplicationEnvironment environment) {
        ClassLoader loader;
        this.checkRuntimeClassLoader();
        this.applicationLoader = loader = this.doCreateApplicationClassLoader(userUrls, contextRoot, environment);
        return loader;
    }

    protected ClassLoader doCreateApplicationClassLoader(URL[] userUrls, File contextRoot, ApplicationEnvironment environment) {
        URL[] prebundledUrls = this.getClassPathUtils().getPrebundledUrls();
        userUrls = NullSandboxPlugin.append(userUrls, prebundledUrls);
        if (environment.getRuntimeConfiguration().getCloudSqlJdbcConnectivityEnabled() && environment.getUseGoogleConnectorJ()) {
            URL[] urls = this.getClassPathUtils().getConnectorJUrls();
            userUrls = NullSandboxPlugin.append(urls, userUrls);
        }
        URL[] legacyUrls = this.getClassPathUtils().getLegacyJarUrls();
        boolean alwaysScanClassDirs = "true".equalsIgnoreCase(environment.getSystemProperties().get(ALWAYS_SCAN_CLASS_DIRS_PROPERTY));
        return new ApplicationClassLoader(userUrls, legacyUrls, this.sharedClassLoader, alwaysScanClassDirs);
    }

    public ClassPathUtils getClassPathUtils() {
        this.checkRuntimeClassLoader();
        return this.classPathUtils;
    }

    private void checkRuntimeClassLoader() {
        if (this.runtimeLoader == null) {
            throw new IllegalStateException("must call createRuntimeClassLoader first");
        }
    }

    private void checkApplicationClassLoader() {
        if (this.applicationLoader == null) {
            throw new IllegalStateException("must call createApplicationClassLoader first");
        }
    }

    private static <T> T[] append(T[] first, T[] second) {
        T[] newArray = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, newArray, first.length, second.length);
        return newArray;
    }

    public void startCapturingApplicationLogs() {
        try {
            Class<?> handlerClass = Class.forName("com.google.apphosting.runtime.NullSandboxLogHandler", true, this.runtimeLoader);
            Object logHandler = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = handlerClass.getMethod("init", Logger.class);
            m.invoke(logHandler, rootLogger);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("failed to install the LogHandler for application logs", e);
        }
    }

    public static void chdir(String path) throws IOException {
        try {
            NullSandboxPlugin.chdir0(path);
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger(NullSandboxPlugin.class.getName()).log(Level.WARNING, "Could not call native chdir", e);
        }
    }

    private static native void chdir0(String var0) throws IOException;
}

