/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.LifecycleManager;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.AutoBuilder_RequestManager_Builder;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.HardDeadlineExceededError;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestState;
import com.google.apphosting.runtime.RuntimeLogSink;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.timer.CpuRatioTimer;
import com.google.apphosting.runtime.timer.JmxGcTimerSet;
import com.google.apphosting.runtime.timer.JmxHotspotTimerSet;
import com.google.apphosting.runtime.timer.TimerFactory;
import com.google.auto.value.AutoBuilder;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class RequestManager {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int SCHEDULER_THREADS = 1;
    private static final String SIMPLE_DATE_FORMAT_STRING = "yyyy/MM/dd HH:mm:ss.SSS z";
    private static final int MAXIMUM_DEADLOCK_STACK_LENGTH = 20;
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";
    private static final Duration CANCEL_ASYNC_FUTURES_WAIT_TIME = Duration.ofMillis(150L);
    private static final Duration THREAD_INTERRUPT_WAIT_TIME = Duration.ofSeconds(1L);
    private final long softDeadlineDelay;
    private final long hardDeadlineDelay;
    private final boolean disableDeadlineTimers;
    private final ScheduledThreadPoolExecutor executor;
    private final TimerFactory timerFactory;
    private final Optional<RuntimeLogSink> runtimeLogSink;
    private final ApiProxyImpl apiProxyImpl;
    private final boolean threadStopTerminatesClone;
    private final Map<String, RequestToken> requests;
    private final boolean interruptFirstOnSoftDeadline;
    private int maxOutstandingApiRpcs;
    @Nullable
    private final CloudDebuggerAgentWrapper cloudDebuggerAgent;
    private final AtomicBoolean enableCloudDebugger;
    private final boolean waitForDaemonRequestThreads;
    private final AtomicBoolean debugletStartNotified = new AtomicBoolean(false);
    private final Map<String, String> environmentVariables;

    public static Builder builder() {
        return new AutoBuilder_RequestManager_Builder().setEnvironment(System.getenv());
    }

    RequestManager(long softDeadlineDelay, long hardDeadlineDelay, boolean disableDeadlineTimers, Optional<RuntimeLogSink> runtimeLogSink, ApiProxyImpl apiProxyImpl, int maxOutstandingApiRpcs, boolean threadStopTerminatesClone, boolean interruptFirstOnSoftDeadline, @Nullable CloudDebuggerAgentWrapper cloudDebuggerAgent, boolean enableCloudDebugger, long cyclesPerSecond, boolean waitForDaemonRequestThreads, ImmutableMap<String, String> environment) {
        this.softDeadlineDelay = softDeadlineDelay;
        this.hardDeadlineDelay = hardDeadlineDelay;
        this.disableDeadlineTimers = disableDeadlineTimers;
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.timerFactory = new TimerFactory(cyclesPerSecond, new JmxHotspotTimerSet(), new JmxGcTimerSet());
        this.runtimeLogSink = runtimeLogSink;
        this.apiProxyImpl = apiProxyImpl;
        this.maxOutstandingApiRpcs = maxOutstandingApiRpcs;
        this.threadStopTerminatesClone = threadStopTerminatesClone;
        this.interruptFirstOnSoftDeadline = interruptFirstOnSoftDeadline;
        this.cloudDebuggerAgent = cloudDebuggerAgent;
        this.enableCloudDebugger = new AtomicBoolean(enableCloudDebugger);
        this.waitForDaemonRequestThreads = waitForDaemonRequestThreads;
        this.requests = Collections.synchronizedMap(new HashMap());
        this.environmentVariables = environment;
    }

    public void setMaxOutstandingApiRpcs(int maxOutstandingApiRpcs) {
        this.maxOutstandingApiRpcs = maxOutstandingApiRpcs;
    }

    public void disableCloudDebugger() {
        this.enableCloudDebugger.set(false);
    }

    public RequestToken startRequest(AppVersion appVersion, AnyRpcServerContext rpc, RuntimePb.UPRequest upRequest, MutableUpResponse upResponse, ThreadGroup requestThreadGroup) {
        Runnable endAction;
        long remainingTime = this.getAdjustedRpcDeadline(rpc, 60000L);
        long softDeadlineMillis = Math.max(this.getAdjustedRpcDeadline(rpc, -1L) - this.softDeadlineDelay, -1L);
        long millisUntilSoftDeadline = remainingTime - this.softDeadlineDelay;
        Thread thread = Thread.currentThread();
        String requestId = String.format("%1$016x", rpc.getGlobalId());
        ((GoogleLogger.Api)logger.atInfo()).log("Beginning request %s remaining millis : %d", (Object)requestId, remainingTime);
        if (RequestManager.isSnapshotRequest(upRequest)) {
            ((GoogleLogger.Api)logger.atInfo()).log("Received snapshot request");
            endAction = new DisableApiHostAction();
        } else {
            this.apiProxyImpl.enable();
            endAction = new NullAction();
        }
        TraceWriter traceWriter = TraceWriter.getTraceWriterForRequest(upRequest, upResponse);
        if (traceWriter != null) {
            URL requestURL = null;
            try {
                requestURL = new URL(upRequest.getRequest().getUrl());
            }
            catch (MalformedURLException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to extract path for trace due to malformed request URL: %s", upRequest.getRequest().getUrl());
            }
            if (requestURL != null) {
                traceWriter.startRequestSpan(requestURL.getPath());
            } else {
                traceWriter.startRequestSpan("Unparsable URL");
            }
        }
        CpuRatioTimer timer = this.timerFactory.getCpuRatioTimer(thread);
        List<Future<?>> asyncFutures = Collections.synchronizedList(new ArrayList());
        Semaphore outstandingApiRpcSemaphore = new Semaphore(this.maxOutstandingApiRpcs);
        RequestState state = new RequestState();
        state.recordRequestThread(Thread.currentThread());
        ApiProxyImpl.EnvironmentImpl environment = this.apiProxyImpl.createEnvironment(appVersion, upRequest, upResponse, traceWriter, timer, requestId, asyncFutures, outstandingApiRpcSemaphore, requestThreadGroup, state, millisUntilSoftDeadline);
        String instanceId = this.environmentVariables.get("GAE_INSTANCE");
        if (!Strings.isNullOrEmpty(instanceId)) {
            environment.getAttributes().putIfAbsent(INSTANCE_ID_ENV_ATTRIBUTE, instanceId);
        }
        RequestToken token = new RequestToken(thread, upResponse, requestId, upRequest.getSecurityTicket(), timer, asyncFutures, appVersion, softDeadlineMillis, rpc, rpc.getStartTimeMillis(), traceWriter, state, endAction);
        this.requests.put(upRequest.getSecurityTicket(), token);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environment);
        this.setPendingStartCloudDebugger(upResponse);
        timer.start();
        if (!this.disableDeadlineTimers) {
            ((GoogleLogger.Api)logger.atInfo()).log("Scheduling soft deadline in %d ms for %s", millisUntilSoftDeadline, (Object)requestId);
            token.addScheduledFuture(this.schedule(new DeadlineRunnable(this, token, false), millisUntilSoftDeadline));
        }
        return token;
    }

    public void finishRequest(RequestToken requestToken) {
        this.verifyRequestAndThread(requestToken);
        requestToken.getState().setAllowNewRequestThreadCreation(false);
        for (Thread thread : this.getActiveThreads(requestToken)) {
            ((GoogleLogger.Api)logger.atWarning()).log("Interrupting %s", thread);
            thread.interrupt();
        }
        if (this.enableCloudDebugger.get() && this.cloudDebuggerAgent.hasBreakpointUpdates()) {
            this.setPendingCloudDebuggerBreakpointUpdates(requestToken.getUpResponse());
        }
        this.waitForUserCodeToComplete(requestToken);
        this.requests.remove(requestToken.getSecurityTicket());
        requestToken.setFinished();
        CpuRatioTimer timer = requestToken.getRequestTimer();
        timer.stop();
        for (Future<?> future : new ArrayList(requestToken.getScheduledFutures())) {
            if (future.isDone()) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Future failed execution: %s", future);
                }
                continue;
            }
            if (future.cancel(false)) {
                ((GoogleLogger.Api)logger.atFine()).log("Removed scheduled future: %s", future);
                continue;
            }
            ((GoogleLogger.Api)logger.atFine()).log("Unable to remove scheduled future: %s", future);
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Stopped timer for request %s %s", (Object)requestToken.getRequestId(), (Object)timer);
        requestToken.getUpResponse().setUserMcycles(timer.getCycleCount() / 1000000L);
        if (requestToken.getTraceWriter() != null) {
            requestToken.getTraceWriter().endRequestSpan();
            requestToken.getTraceWriter().flushTrace();
        }
        requestToken.runEndAction();
        ApiProxy.clearEnvironmentForCurrentThread();
        this.runtimeLogSink.ifPresent(x -> x.flushLogs(requestToken.getUpResponse()));
    }

    private static boolean isSnapshotRequest(RuntimePb.UPRequest request) {
        try {
            URI uri = new URI(request.getRequest().getUrl());
            if (!"/_ah/snapshot".equals(uri.getPath())) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        for (HttpPb.ParsedHttpHeader header : request.getRequest().getHeadersList()) {
            if (!"X-AppEngine-Snapshot".equalsIgnoreCase(header.getKey())) continue;
            return true;
        }
        return false;
    }

    public void sendDeadline(String securityTicket, boolean isUncatchable) {
        ((GoogleLogger.Api)logger.atInfo()).log("Looking up token for security ticket %s", securityTicket);
        this.sendDeadline(this.requests.get(securityTicket), isUncatchable);
    }

    public void sendDeadline(RequestToken token, boolean isUncatchable) {
        if (token == null) {
            ((GoogleLogger.Api)logger.atInfo()).log("No token, can't send deadline");
            return;
        }
        this.checkForDeadlocks(token);
        Thread targetThread = token.getRequestThread();
        ((GoogleLogger.Api)logger.atInfo()).log("Sending deadline: %s, %s, %b", targetThread, token.getRequestId(), isUncatchable);
        if (this.interruptFirstOnSoftDeadline && !isUncatchable) {
            token.getState().setAllowNewRequestThreadCreation(false);
            this.cancelPendingAsyncFutures(token.getAsyncFutures());
            this.waitForResponseDuringSoftDeadline(CANCEL_ASYNC_FUTURES_WAIT_TIME);
            if (!token.isFinished()) {
                ((GoogleLogger.Api)logger.atInfo()).log("Interrupting all request threads.");
                for (Thread thread : this.getActiveThreads(token)) {
                    thread.interrupt();
                }
                this.waitForResponseDuringSoftDeadline(THREAD_INTERRUPT_WAIT_TIME);
            }
        }
        if (isUncatchable) {
            token.getState().setHardDeadlinePassed(true);
        } else {
            token.getState().setSoftDeadlinePassed(true);
        }
        if (!token.isFinished()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(SIMPLE_DATE_FORMAT_STRING);
            Throwable throwable = this.createDeadlineThrowable("This request (" + token.getRequestId() + ") started at " + dateFormat.format(token.getStartTimeMillis()) + " and was still executing at " + dateFormat.format(System.currentTimeMillis()) + ".", isUncatchable);
            boolean terminateClone = false;
            StackTraceElement[] stackTrace = targetThread.getStackTrace();
            if (this.threadStopTerminatesClone || isUncatchable || this.inClassInitialization(stackTrace)) {
                terminateClone = true;
            }
            throwable.setStackTrace(stackTrace);
            if (!token.isFinished()) {
                token.getUpResponse().setTerminateClone(terminateClone);
                if (terminateClone) {
                    token.getUpResponse().setCloneIsInUncleanState(true);
                }
                ((GoogleLogger.Api)logger.atInfo()).log("Stopping request thread.");
                AccessController.doPrivileged(() -> {
                    try {
                        ThreadStop0Holder.threadStop0.invoke((Object)targetThread, throwable);
                    }
                    catch (Exception e) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to stop thread");
                    }
                    return null;
                });
            }
        }
    }

    private void setPendingStartCloudDebugger(MutableUpResponse upResponse) {
        if (!this.enableCloudDebugger.get()) {
            return;
        }
        if (this.debugletStartNotified.compareAndSet(false, true)) {
            upResponse.setPendingCloudDebuggerActionDebuggeeRegistration(true);
        }
    }

    private void setPendingCloudDebuggerBreakpointUpdates(MutableUpResponse upResponse) {
        if (!this.enableCloudDebugger.get()) {
            return;
        }
        upResponse.setPendingCloudDebuggerActionBreakpointUpdates(true);
    }

    private String threadDump(Collection<Thread> threads, String prefix) {
        StringBuilder message = new StringBuilder(prefix);
        for (Thread thread : threads) {
            message.append(thread).append(" in state ").append((Object)thread.getState()).append("\n");
            StackTraceElement[] stack = thread.getStackTrace();
            if (stack.length == 0) {
                message.append("... empty stack\n");
            } else {
                for (StackTraceElement element : thread.getStackTrace()) {
                    message.append("... ").append(element).append("\n");
                }
            }
            message.append("\n");
        }
        return message.toString();
    }

    private void waitForUserCodeToComplete(RequestToken requestToken) {
        RequestState state = requestToken.getState();
        if (Thread.interrupted()) {
            ((GoogleLogger.Api)logger.atInfo()).log("Interrupt bit set in waitForUserCodeToComplete, resetting.");
        }
        try {
            Set<Thread> threads;
            if (state.hasHardDeadlinePassed()) {
                ((GoogleLogger.Api)logger.atInfo()).log("Hard deadline has already passed; skipping wait for async futures.");
            } else {
                this.waitForPendingAsyncFutures(requestToken.getAsyncFutures());
            }
            while (!(threads = this.getActiveThreads(requestToken)).isEmpty()) {
                if (state.hasHardDeadlinePassed()) {
                    requestToken.getUpResponse().setError(19);
                    requestToken.getUpResponse().clearHttpResponse();
                    String messageString = this.threadDump(threads, "Thread(s) still running after request:\n");
                    ((GoogleLogger.Api)logger.atWarning()).log("%s", messageString);
                    requestToken.addAppLogMessage(ApiProxy.LogRecord.Level.fatal, messageString);
                    return;
                }
                try {
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                    if (Boolean.getBoolean("com.google.appengine.force.thread.pool.shutdown")) {
                        this.attemptThreadPoolShutdown(threads);
                    }
                    for (Thread thread : threads) {
                        ((GoogleLogger.Api)logger.atInfo()).log("Waiting for completion of thread: %s", thread);
                        thread.join(10000L);
                        if (!thread.isAlive()) continue;
                        String message = this.threadDump(threads, "Threads still running after 10 seconds:\n");
                        ((GoogleLogger.Api)logger.atWarning()).log("%s", message);
                        requestToken.addAppLogMessage(ApiProxy.LogRecord.Level.warn, message);
                        thread.join();
                    }
                    ((GoogleLogger.Api)logger.atInfo()).log("All request threads have completed.");
                }
                catch (DeadlineExceededException deadlineExceededException) {
                }
                catch (HardDeadlineExceededError hardDeadlineExceededError) {}
            }
        }
        catch (Throwable ex) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Exception thrown while waiting for background work to complete:");
        }
    }

    private void attemptThreadPoolShutdown(Collection<Thread> threads) {
        for (Thread t : threads) {
            Runnable runnable;
            if (!(t instanceof ApiProxyImpl.CurrentRequestThread) || !(runnable = ((ApiProxyImpl.CurrentRequestThread)t).userRunnable()).getClass().getName().equals("java.util.concurrent.ThreadPoolExecutor$Worker")) continue;
            try {
                Field outerField = runnable.getClass().getDeclaredField("this$0");
                outerField.setAccessible(true);
                Object outer = outerField.get(runnable);
                if (!(outer instanceof ThreadPoolExecutor)) continue;
                ThreadPoolExecutor executor = (ThreadPoolExecutor)outer;
                executor.shutdown();
            }
            catch (ReflectiveOperationException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(e)).log("ThreadPoolExecutor reflection failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingAsyncFutures(Collection<Future<?>> asyncFutures) throws InterruptedException {
        int size = asyncFutures.size();
        if (size > 0) {
            ArrayList snapshot;
            ((GoogleLogger.Api)logger.atWarning()).log("Waiting for %d pending async futures.", size);
            Collection<Future<?>> collection = asyncFutures;
            synchronized (collection) {
                snapshot = new ArrayList(asyncFutures);
            }
            for (Future future : snapshot) {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(ex.getCause())).log("Async future failed:");
                }
            }
            ((GoogleLogger.Api)logger.atWarning()).log("Done waiting for pending async futures.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPendingAsyncFutures(Collection<Future<?>> asyncFutures) {
        int size = asyncFutures.size();
        if (size > 0) {
            ArrayList snapshot;
            ((GoogleLogger.Api)logger.atInfo()).log("Canceling %d pending async futures.", size);
            Collection<Future<?>> collection = asyncFutures;
            synchronized (collection) {
                snapshot = new ArrayList(asyncFutures);
            }
            for (Future future : snapshot) {
                future.cancel(true);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("Done canceling pending async futures.");
        }
    }

    private void waitForResponseDuringSoftDeadline(Duration responseWaitTimeMs) {
        try {
            Thread.sleep(responseWaitTimeMs.toMillis());
        }
        catch (InterruptedException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause(e)).log("Interrupted while waiting for response during soft deadline");
        }
    }

    private Set<Thread> getActiveThreads(RequestToken token) {
        Set<Thread> threads;
        if (this.waitForDaemonRequestThreads) {
            threads = token.getState().requestThreads();
        } else {
            LinkedHashSet<Thread> nonDaemonThreads = new LinkedHashSet<Thread>();
            for (Thread thread : token.getState().requestThreads()) {
                if (thread.isDaemon()) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Ignoring daemon thread: %s", thread);
                    continue;
                }
                if (!thread.isAlive()) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Ignoring dead thread: %s", thread);
                    continue;
                }
                nonDaemonThreads.add(thread);
            }
            threads = nonDaemonThreads;
        }
        LinkedHashSet<Thread> activeThreads = new LinkedHashSet<Thread>(threads);
        activeThreads.remove(Thread.currentThread());
        return activeThreads;
    }

    private void verifyRequestAndThread(RequestToken requestToken) {
        if (requestToken.getRequestThread() != Thread.currentThread()) {
            throw new IllegalStateException("Called from " + Thread.currentThread() + ", should be " + requestToken.getRequestThread());
        }
    }

    private Future<?> schedule(Runnable runnable, long time) {
        ((GoogleLogger.Api)logger.atFine()).log("Scheduling %s to run in %d ms.", (Object)runnable, time);
        return this.executor.schedule(runnable, time, TimeUnit.MILLISECONDS);
    }

    private long getAdjustedRpcDeadline(AnyRpcServerContext rpc, long defaultValue) {
        if (rpc.getTimeRemaining().compareTo(Duration.ofNanos(Long.MAX_VALUE)) >= 0 || rpc.getStartTimeMillis() == 0L) {
            ((GoogleLogger.Api)logger.atWarning()).log("Did not receive enough RPC information to calculate adjusted deadline: %s", rpc);
            return defaultValue;
        }
        long elapsedMillis = System.currentTimeMillis() - rpc.getStartTimeMillis();
        if (rpc.getTimeRemaining().compareTo(Duration.ofSeconds(30L)) < 0) {
            ((GoogleLogger.Api)logger.atWarning()).log("RPC deadline is less than padding.  Not adjusting deadline");
            return rpc.getTimeRemaining().minusMillis(elapsedMillis).toMillis();
        }
        return rpc.getTimeRemaining().minusSeconds(30L).minusMillis(elapsedMillis).toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRequests(RequestToken token) {
        this.checkForDeadlocks(token);
        ((GoogleLogger.Api)logger.atInfo()).log("Calling shutdown hooks for %s", token.getAppVersionKey());
        MutableUpResponse response = token.getUpResponse();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(token.getAppVersion().getClassLoader());
        try {
            LifecycleManager.getInstance().beginShutdown(token.getDeadline());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.logMemoryStats();
        this.logAllStackTraces();
        response.setError(0);
        response.setHttpResponseCodeAndResponse(200, "OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Thread> getRequestThreads(AppVersionKey appVersionKey) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Map<String, RequestToken> map = this.requests;
        synchronized (map) {
            for (RequestToken token : this.requests.values()) {
                if (!appVersionKey.equals(token.getAppVersionKey())) continue;
                threads.add(token.getRequestThread());
            }
        }
        return threads;
    }

    private void checkForDeadlocks(RequestToken token) {
        AccessController.doPrivileged(() -> {
            long[] deadlockedThreadsIds = THREAD_MX.findDeadlockedThreads();
            if (deadlockedThreadsIds != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("Detected a deadlock across " + deadlockedThreadsIds.length + " threads:");
                for (ThreadInfo info : THREAD_MX.getThreadInfo(deadlockedThreadsIds, 20)) {
                    builder.append(info);
                    builder.append("\n");
                }
                String message = builder.toString();
                token.addAppLogMessage(ApiProxy.LogRecord.Level.fatal, message);
                token.logAndKillRuntime(message);
            }
            return null;
        });
    }

    private void logMemoryStats() {
        Runtime runtime = Runtime.getRuntime();
        ((GoogleLogger.Api)logger.atInfo()).log("maxMemory=%d totalMemory=%d freeMemory=%d", runtime.maxMemory(), runtime.totalMemory(), runtime.freeMemory());
    }

    private void logAllStackTraces() {
        AccessController.doPrivileged(() -> {
            long[] allthreadIds = THREAD_MX.getAllThreadIds();
            StringBuilder builder = new StringBuilder();
            builder.append("Dumping thread info for all " + allthreadIds.length + " runtime threads:");
            for (ThreadInfo info : THREAD_MX.getThreadInfo(allthreadIds, 20)) {
                builder.append(info);
                builder.append("\n");
            }
            String message = builder.toString();
            ((GoogleLogger.Api)logger.atInfo()).log("%s", message);
            return null;
        });
    }

    private Throwable createDeadlineThrowable(String message, boolean isUncatchable) {
        if (isUncatchable) {
            return new HardDeadlineExceededError(message);
        }
        return new DeadlineExceededException(message);
    }

    private boolean inClassInitialization(StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            if (!"<clinit>".equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public class DeadlineRunnable
    implements Runnable {
        private final RequestManager requestManager;
        private final RequestToken token;
        private final boolean isUncatchable;

        public DeadlineRunnable(RequestManager requestManager, RequestToken token, boolean isUncatchable) {
            this.requestManager = requestManager;
            this.token = token;
            this.isUncatchable = isUncatchable;
        }

        @Override
        public void run() {
            this.requestManager.sendDeadline(this.token, this.isUncatchable);
            if (!this.token.isFinished()) {
                if (!this.isUncatchable) {
                    this.token.addScheduledFuture(RequestManager.this.schedule(new DeadlineRunnable(this.requestManager, this.token, true), RequestManager.this.softDeadlineDelay - RequestManager.this.hardDeadlineDelay));
                }
                ((GoogleLogger.Api)logger.atInfo()).log("Finished execution of %s", this);
            }
        }

        public String toString() {
            return "DeadlineRunnable(" + this.token.getRequestThread() + ", " + this.token.getRequestId() + ", " + this.isUncatchable + ")";
        }
    }

    public static class RequestToken {
        private final Thread requestThread;
        private final MutableUpResponse upResponse;
        private final Collection<Future<?>> scheduledFutures;
        private final Collection<Future<?>> asyncFutures;
        private final String requestId;
        private final String securityTicket;
        private final CpuRatioTimer requestTimer;
        @Nullable
        private final TraceWriter traceWriter;
        private volatile boolean finished;
        private final AppVersion appVersion;
        private final long deadline;
        private final AnyRpcServerContext rpc;
        private final long startTimeMillis;
        private final RequestState state;
        private final Runnable endAction;

        RequestToken(Thread requestThread, MutableUpResponse upResponse, String requestId, String securityTicket, CpuRatioTimer requestTimer, Collection<Future<?>> asyncFutures, AppVersion appVersion, long deadline, AnyRpcServerContext rpc, long startTimeMillis, @Nullable TraceWriter traceWriter, RequestState state, Runnable endAction) {
            this.requestThread = requestThread;
            this.upResponse = upResponse;
            this.requestId = requestId;
            this.securityTicket = securityTicket;
            this.requestTimer = requestTimer;
            this.asyncFutures = asyncFutures;
            this.scheduledFutures = new ArrayList();
            this.finished = false;
            this.appVersion = appVersion;
            this.deadline = deadline;
            this.rpc = rpc;
            this.startTimeMillis = startTimeMillis;
            this.traceWriter = traceWriter;
            this.state = state;
            this.endAction = endAction;
        }

        public RequestState getState() {
            return this.state;
        }

        Thread getRequestThread() {
            return this.requestThread;
        }

        MutableUpResponse getUpResponse() {
            return this.upResponse;
        }

        CpuRatioTimer getRequestTimer() {
            return this.requestTimer;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getSecurityTicket() {
            return this.securityTicket;
        }

        public AppVersion getAppVersion() {
            return this.appVersion;
        }

        public AppVersionKey getAppVersionKey() {
            return this.appVersion.getKey();
        }

        public long getDeadline() {
            return this.deadline;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        Collection<Future<?>> getScheduledFutures() {
            return this.scheduledFutures;
        }

        void addScheduledFuture(Future<?> future) {
            this.scheduledFutures.add(future);
        }

        Collection<Future<?>> getAsyncFutures() {
            return this.asyncFutures;
        }

        @Nullable
        TraceWriter getTraceWriter() {
            return this.traceWriter;
        }

        boolean isFinished() {
            return this.finished;
        }

        void setFinished() {
            this.finished = true;
        }

        public void addAppLogMessage(ApiProxy.LogRecord.Level level, String message) {
            this.upResponse.addAppLog(AppLogsPb.AppLogLine.newBuilder().setLevel(level.ordinal()).setTimestampUsec(System.currentTimeMillis() * 1000L).setMessage(message));
        }

        void logAndKillRuntime(String errorMessage) {
            ((GoogleLogger.Api)logger.atSevere()).log("LOG(FATAL): %s", errorMessage);
            this.upResponse.clearHttpResponse();
            this.upResponse.setError(7);
            this.upResponse.setErrorMessage(errorMessage);
            this.rpc.finishWithResponse(this.upResponse.build());
        }

        void runEndAction() {
            this.endAction.run();
        }
    }

    private static class ThreadStop0Holder {
        private static final Method threadStop0;

        private ThreadStop0Holder() {
        }

        static {
            try {
                threadStop0 = Thread.class.getDeclaredMethod("stop0", Object.class);
                threadStop0.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class NullAction
    implements Runnable {
        private NullAction() {
        }

        @Override
        public void run() {
        }
    }

    private class DisableApiHostAction
    implements Runnable {
        private DisableApiHostAction() {
        }

        @Override
        public void run() {
            RequestManager.this.apiProxyImpl.disable();
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setSoftDeadlineDelay(long var1);

        public abstract long softDeadlineDelay();

        public abstract Builder setHardDeadlineDelay(long var1);

        public abstract long hardDeadlineDelay();

        public abstract Builder setDisableDeadlineTimers(boolean var1);

        public abstract boolean disableDeadlineTimers();

        public abstract Builder setRuntimeLogSink(Optional<RuntimeLogSink> var1);

        public abstract Builder setApiProxyImpl(ApiProxyImpl var1);

        public abstract Builder setMaxOutstandingApiRpcs(int var1);

        public abstract int maxOutstandingApiRpcs();

        public abstract Builder setThreadStopTerminatesClone(boolean var1);

        public abstract boolean threadStopTerminatesClone();

        public abstract Builder setInterruptFirstOnSoftDeadline(boolean var1);

        public abstract boolean interruptFirstOnSoftDeadline();

        public abstract Builder setCloudDebuggerAgent(@Nullable CloudDebuggerAgentWrapper var1);

        public abstract Builder setEnableCloudDebugger(boolean var1);

        public abstract boolean enableCloudDebugger();

        public abstract Builder setCyclesPerSecond(long var1);

        public abstract long cyclesPerSecond();

        public abstract Builder setWaitForDaemonRequestThreads(boolean var1);

        public abstract boolean waitForDaemonRequestThreads();

        public abstract Builder setEnvironment(Map<String, String> var1);

        public abstract RequestManager build();
    }
}

