/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.AutoBuilder_RequestRunner_Builder;
import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.apphosting.runtime.HttpCompression;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.ThreadGroupPool;
import com.google.apphosting.runtime.UPRequestHandler;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.auto.value.AutoBuilder;
import com.google.common.base.Ascii;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;

public class RequestRunner
implements Runnable {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final long WAIT_FOR_USER_RUNNABLE_DEADLINE = 60000L;
    private final UPRequestHandler upRequestHandler;
    private final RequestManager requestManager;
    private final BackgroundRequestCoordinator coordinator;
    private final boolean compressResponse;
    private final AppVersion appVersion;
    private final AnyRpcServerContext rpc;
    private final RuntimePb.UPRequest upRequest;
    private final MutableUpResponse upResponse;

    public static Builder builder() {
        return new AutoBuilder_RequestRunner_Builder();
    }

    public RequestRunner(UPRequestHandler upRequestHandler, RequestManager requestManager, BackgroundRequestCoordinator coordinator, boolean compressResponse, AppVersion appVersion, AnyRpcServerContext rpc, RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) {
        this.upRequestHandler = upRequestHandler;
        this.requestManager = requestManager;
        this.coordinator = coordinator;
        this.compressResponse = compressResponse;
        this.appVersion = appVersion;
        this.rpc = rpc;
        this.upRequest = upRequest;
        this.upResponse = upResponse;
    }

    public static void setFailure(MutableUpResponse response, RuntimePb.UPResponse.ERROR error, String message) {
        ((GoogleLogger.Api)logger.atWarning()).log("Runtime failed: %s, %s", (Object)error, (Object)message);
        if (response.getError() == 0) {
            response.setError(error.getNumber());
            response.setErrorMessage(message);
        }
    }

    private String formatLogLine(String message, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        ex.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static boolean shouldKillCloneAfterException(Throwable th) {
        while (th != null) {
            if (th instanceof OutOfMemoryError) {
                return true;
            }
            try {
                Throwable[] suppressed = th.getSuppressed();
                if (suppressed != null) {
                    for (Throwable s : suppressed) {
                        if (!RequestRunner.shouldKillCloneAfterException(s)) continue;
                        return true;
                    }
                }
            }
            catch (OutOfMemoryError ex) {
                return true;
            }
            th = th.getCause();
        }
        return false;
    }

    private String getBackgroundRequestId(RuntimePb.UPRequest upRequest) {
        for (HttpPb.ParsedHttpHeader header : upRequest.getRequest().getHeadersList()) {
            if (!Ascii.equalsIgnoreCase(header.getKey(), "X-AppEngine-BackgroundRequest")) continue;
            return header.getValue();
        }
        throw new IllegalArgumentException("Did not receive a background request identifier.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        RequestManager.RequestToken requestToken = this.requestManager.startRequest(this.appVersion, this.rpc, this.upRequest, this.upResponse, currentThreadGroup);
        try {
            this.dispatchRequest(requestToken);
        }
        catch (Throwable ex) {
            this.handleException(ex, requestToken);
        }
        finally {
            this.requestManager.finishRequest(requestToken);
        }
        this.rpc.finishWithResponse(this.upResponse.build());
        if (this.upRequest.getRequestType() == RuntimePb.UPRequest.RequestType.BACKGROUND) {
            Thread.currentThread().interrupt();
        }
    }

    private void dispatchRequest(RequestManager.RequestToken requestToken) throws InterruptedException, TimeoutException, ServletException, IOException {
        switch (this.upRequest.getRequestType()) {
            case SHUTDOWN: {
                ((GoogleLogger.Api)logger.atInfo()).log("Shutting down requests");
                this.requestManager.shutdownRequests(requestToken);
                break;
            }
            case BACKGROUND: {
                this.dispatchBackgroundRequest();
                break;
            }
            case OTHER: {
                this.dispatchServletRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchBackgroundRequest() throws InterruptedException, TimeoutException {
        String requestId = this.getBackgroundRequestId(this.upRequest);
        CountDownLatch latch = ThreadGroupPool.resetCurrentThread();
        ThreadProxy thread = new ThreadProxy();
        Runnable runnable = this.coordinator.waitForUserRunnable(requestId, thread, 60000L);
        latch.await();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.appVersion.getClassLoader());
        try {
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.upResponse.setError(0);
        if (!this.upResponse.hasHttpResponse()) {
            this.upResponse.setHttpResponseCodeAndResponse(200, "OK");
        }
    }

    private void dispatchServletRequest() throws ServletException, IOException {
        this.upRequestHandler.serviceRequest(this.upRequest, this.upResponse);
        if (this.compressResponse) {
            try {
                HttpCompression compression = new HttpCompression();
                compression.attemptCompression(this.upRequest, this.upResponse);
            }
            catch (IOException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Error attempting the compression of the response.");
            }
            catch (RuntimeException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Error attempting the compression of the response.");
            }
        }
    }

    private void handleException(Throwable ex, RequestManager.RequestToken requestToken) {
        ServletException sex;
        if (ex instanceof ServletException && (sex = (ServletException)ex).getRootCause() != null) {
            ex = sex.getRootCause();
        }
        String msg = "Uncaught exception from servlet";
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("%s", msg);
        requestToken.addAppLogMessage(ApiProxy.LogRecord.Level.fatal, this.formatLogLine(msg, ex));
        if (RequestRunner.shouldKillCloneAfterException(ex)) {
            ((GoogleLogger.Api)logger.atSevere()).log("Detected a dangerous exception, shutting down clone nicely.");
            this.upResponse.setTerminateClone(true);
        }
        RuntimePb.UPResponse.ERROR error = RuntimePb.UPResponse.ERROR.APP_FAILURE;
        RequestRunner.setFailure(this.upResponse, error, "Unexpected exception from servlet: " + ex);
    }

    private static class ThreadProxy
    extends Thread {
        private final Thread proxy = Thread.currentThread();

        private ThreadProxy() {
            super(Thread.currentThread().getThreadGroup().getParent(), Thread.currentThread().getName() + "-proxy");
        }

        @Override
        public synchronized void start() {
            this.proxy.start();
            super.start();
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
            this.proxy.setUncaughtExceptionHandler(eh);
        }

        @Override
        public void run() {
            Uninterruptibles.joinUninterruptibly(this.proxy);
        }
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setUpRequestHandler(UPRequestHandler var1);

        public abstract Builder setRequestManager(RequestManager var1);

        public abstract Builder setCoordinator(BackgroundRequestCoordinator var1);

        public abstract Builder setCompressResponse(boolean var1);

        public abstract Builder setAppVersion(AppVersion var1);

        public abstract Builder setRpc(AnyRpcServerContext var1);

        public abstract Builder setUpRequest(RuntimePb.UPRequest var1);

        public abstract Builder setUpResponse(MutableUpResponse var1);

        public abstract RequestRunner build();
    }
}

