/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.MutableUpResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RuntimeLogSink {
    private static final Logger rootLogger = Logger.getLogger("");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MMdd HH:mm:ss.SSS");
    private final Collection<RuntimePb.UPResponse.RuntimeLogLine> pendingLogLines = new ArrayList<RuntimePb.UPResponse.RuntimeLogLine>();
    private final HashMap<String, String> mapExceptionDate = new HashMap();
    private final long maxSizeBytes;
    private long currentSizeBytes = 0L;

    public RuntimeLogSink(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public synchronized void addHandlerToRootLogger() {
        RuntimeLogHandler handler = new RuntimeLogHandler();
        rootLogger.addHandler(handler);
    }

    synchronized void addLog(RuntimePb.UPResponse.RuntimeLogLine logLine) {
        this.pendingLogLines.add(logLine);
    }

    public synchronized void flushLogs(MutableUpResponse response) {
        response.addAllRuntimeLogLine(this.pendingLogLines);
        this.pendingLogLines.clear();
        this.mapExceptionDate.clear();
        this.currentSizeBytes = 0L;
    }

    boolean maxSizeReached() {
        return this.currentSizeBytes >= this.maxSizeBytes;
    }

    private final class CustomFormatter
    extends Formatter {
        private CustomFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized String format(LogRecord record) {
            String date;
            StringBuilder sb = new StringBuilder();
            DateFormat dateFormat = DATE_FORMAT;
            synchronized (dateFormat) {
                date = DATE_FORMAT.format(new Date());
            }
            sb.append(date);
            sb.append(": ");
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            sb.append("\n");
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    try (PrintWriter pw = new PrintWriter(sw);){
                        record.getThrown().printStackTrace(pw);
                    }
                    String exceptionText = sw.toString();
                    if (RuntimeLogSink.this.mapExceptionDate.containsKey(exceptionText)) {
                        sb.append("See duplicated exception at date: " + (String)RuntimeLogSink.this.mapExceptionDate.get(exceptionText));
                    } else {
                        sb.append(exceptionText);
                        RuntimeLogSink.this.mapExceptionDate.put(exceptionText, date);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }

    class RuntimeLogHandler
    extends Handler {
        RuntimeLogHandler() {
            this.setLevel(Level.INFO);
            this.setFilter(null);
            this.setFormatter(new CustomFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            String message;
            if (!this.isLoggable(record)) {
                return;
            }
            if (RuntimeLogSink.this.maxSizeReached()) {
                return;
            }
            try {
                message = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            RuntimeLogSink.this.currentSizeBytes = RuntimeLogSink.this.currentSizeBytes + 2L * (long)message.length();
            if (RuntimeLogSink.this.maxSizeReached()) {
                message = "Maximum runtime log size reached: " + RuntimeLogSink.this.maxSizeBytes;
            }
            RuntimePb.UPResponse.RuntimeLogLine logLine = RuntimePb.UPResponse.RuntimeLogLine.newBuilder().setSeverity(this.convertSeverity(record.getLevel())).setMessage(message).build();
            RuntimeLogSink.this.addLog(logLine);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.flush();
        }

        private int convertSeverity(Level level) {
            if (level.intValue() >= Level.SEVERE.intValue()) {
                return 2;
            }
            if (level.intValue() >= Level.WARNING.intValue()) {
                return 1;
            }
            return 0;
        }
    }
}

