/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.grpc;

import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.primitives.Ints;
import io.grpc.Status;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GrpcApplicationError {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    final String namespace;
    final int appErrorCode;
    final String errorDetail;
    private static final Pattern ERROR_PATTERN = Pattern.compile("SPACE<([^>]+)> CODE<(\\d+)> (.*)");

    GrpcApplicationError(String namespace, int appErrorCode, String errorDetail) {
        Preconditions.checkArgument(namespace.indexOf(62) < 0);
        this.namespace = namespace;
        this.appErrorCode = appErrorCode;
        this.errorDetail = errorDetail;
    }

    Status encode() {
        return Status.INVALID_ARGUMENT.withDescription(String.format("SPACE<%s> CODE<%d> %s", this.namespace, this.appErrorCode, this.errorDetail));
    }

    static Optional<GrpcApplicationError> decode(Status status) {
        Matcher matcher;
        if (status.getCode().equals((Object)Status.Code.INVALID_ARGUMENT) && (matcher = ERROR_PATTERN.matcher(status.getDescription())).matches()) {
            String namespace = matcher.group(1);
            Integer appErrorCode = Ints.tryParse(matcher.group(2));
            String errorDetail = matcher.group(3);
            if (appErrorCode == null) {
                ((GoogleLogger.Api)logger.atWarning()).log("Could not parse app error out of: %s", status.getDescription());
            } else {
                return Optional.of(new GrpcApplicationError(namespace, appErrorCode, errorDetail));
            }
        }
        return Optional.empty();
    }
}

