/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.grpc;

import com.google.apphosting.base.protos.Status;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.grpc.GrpcApplicationError;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class GrpcClientContext
implements AnyRpcClientContext {
    private final Clock clock;
    private Optional<Long> deadlineNanos = Optional.empty();
    private int applicationError;
    private String errorDetail;
    private Status.StatusProto status = Status.StatusProto.getDefaultInstance();
    private Throwable exception;
    private ClientCall<?, ?> currentCall;
    private long currentCallStartTimeMillis;
    private static final int UNKNOWN_ERROR_CODE = 1;
    private static final int INTERNAL_CANONICAL_CODE = 13;
    private static final int INTERNAL_CODE = 3;
    private static final int DEADLINE_EXCEEDED_CODE = 4;
    private static final int CANCELLED_CODE = 6;

    public GrpcClientContext(Clock clock) {
        this.clock = clock;
    }

    public <ReqT, RespT> void call(Channel channel, MethodDescriptor<ReqT, RespT> method, ReqT request, StreamObserver<RespT> responseObserver) {
        Preconditions.checkState(this.currentCall == null);
        ClientCall<ReqT, RespT> clientCall = channel.newCall(method, this.getCallOptions());
        this.currentCall = clientCall;
        this.currentCallStartTimeMillis = this.clock.millis();
        ClientCalls.asyncUnaryCall(clientCall, request, responseObserver);
    }

    private CallOptions getCallOptions() {
        CallOptions callOptions = CallOptions.DEFAULT;
        if (this.deadlineNanos.isPresent()) {
            callOptions = callOptions.withDeadlineAfter(this.deadlineNanos.get(), TimeUnit.NANOSECONDS);
        }
        return callOptions;
    }

    @Override
    public long getStartTimeMillis() {
        return this.currentCallStartTimeMillis;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    void setException(Throwable exception) {
        Status grpcStatus = Status.fromThrowable(exception);
        Optional<GrpcApplicationError> maybeAppError = GrpcApplicationError.decode(grpcStatus);
        if (maybeAppError.isPresent()) {
            GrpcApplicationError appError = maybeAppError.get();
            this.applicationError = appError.appErrorCode;
            this.errorDetail = appError.errorDetail;
            this.status = Status.StatusProto.newBuilder().setSpace(appError.namespace).setCode(appError.appErrorCode).setCanonicalCode(appError.appErrorCode).setMessage(appError.errorDetail).build();
        } else {
            int canonicalCode;
            int code;
            switch (grpcStatus.getCode()) {
                case DEADLINE_EXCEEDED: {
                    code = 4;
                    canonicalCode = 4;
                    break;
                }
                case CANCELLED: {
                    code = 6;
                    canonicalCode = 6;
                    break;
                }
                case INTERNAL: {
                    code = 3;
                    canonicalCode = 13;
                    break;
                }
                default: {
                    code = 1;
                    canonicalCode = 1;
                }
            }
            this.applicationError = 0;
            this.errorDetail = exception.toString();
            this.status = Status.StatusProto.newBuilder().setSpace("RPC").setCode(code).setCanonicalCode(canonicalCode).setMessage(this.errorDetail).build();
            this.exception = exception;
        }
    }

    @Override
    public int getApplicationError() {
        return this.applicationError;
    }

    @Override
    public String getErrorDetail() {
        return this.errorDetail;
    }

    @Override
    public Status.StatusProto getStatus() {
        return this.status;
    }

    @Override
    public void setDeadline(double seconds) {
        Preconditions.checkArgument(seconds >= 0.0);
        double nanos = 1.0E9 * seconds;
        Preconditions.checkArgument(nanos <= 9.223372036854776E18);
        this.deadlineNanos = Optional.of((long)nanos);
    }

    @Override
    public void startCancel() {
        this.currentCall.cancel("GrpcClientContext.cancel() called", null);
    }
}

