/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.grpc;

import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.grpc.GrpcApplicationError;
import com.google.protobuf.MessageLite;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class GrpcServerContext<ResponseT extends MessageLite>
implements AnyRpcServerContext {
    private final Class<ResponseT> responseClass;
    private final StreamObserver<ResponseT> streamObserver;
    private final long startTimeMillis;
    private final long globalId;
    private final Context context;
    private static final IdGenerator idGenerator = new IdGenerator();

    GrpcServerContext(Class<ResponseT> responseClass, StreamObserver<ResponseT> streamObserver) {
        this.responseClass = responseClass;
        this.streamObserver = streamObserver;
        this.startTimeMillis = System.currentTimeMillis();
        this.globalId = idGenerator.nextId();
        this.context = Context.current();
    }

    @Override
    public void finishWithResponse(MessageLite response) {
        MessageLite typedResponse = (MessageLite)this.responseClass.cast(response);
        this.streamObserver.onNext(typedResponse);
        this.streamObserver.onCompleted();
    }

    @Override
    public void finishWithAppError(int appErrorCode, String errorDetail) {
        GrpcApplicationError appError = new GrpcApplicationError("AppError", appErrorCode, errorDetail);
        Status status = appError.encode();
        this.streamObserver.onError(new StatusException(status));
    }

    @Override
    public Duration getTimeRemaining() {
        Deadline deadline = this.context.getDeadline();
        if (deadline == null) {
            return Duration.ofNanos(Long.MAX_VALUE);
        }
        return Duration.ofNanos(deadline.timeRemaining(TimeUnit.NANOSECONDS));
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public long getGlobalId() {
        return this.globalId;
    }

    private static class IdGenerator {
        private long lastId;

        private IdGenerator() {
        }

        synchronized long nextId() {
            long id = System.currentTimeMillis();
            if (id <= this.lastId) {
                id = this.lastId + 1L;
            }
            this.lastId = id;
            return id;
        }
    }
}

