/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.runtime.http.HttpApiHostClient;
import java.util.OptionalInt;

final class AutoValue_HttpApiHostClient_Config
extends HttpApiHostClient.Config {
    private final double extraTimeoutSeconds;
    private final OptionalInt maxConnectionsPerDestination;
    private final boolean ignoreContentLength;
    private final boolean treatClosedChannelAsCancellation;

    private AutoValue_HttpApiHostClient_Config(double extraTimeoutSeconds, OptionalInt maxConnectionsPerDestination, boolean ignoreContentLength, boolean treatClosedChannelAsCancellation) {
        this.extraTimeoutSeconds = extraTimeoutSeconds;
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
        this.ignoreContentLength = ignoreContentLength;
        this.treatClosedChannelAsCancellation = treatClosedChannelAsCancellation;
    }

    @Override
    double extraTimeoutSeconds() {
        return this.extraTimeoutSeconds;
    }

    @Override
    OptionalInt maxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    @Override
    boolean ignoreContentLength() {
        return this.ignoreContentLength;
    }

    @Override
    boolean treatClosedChannelAsCancellation() {
        return this.treatClosedChannelAsCancellation;
    }

    public String toString() {
        return "Config{extraTimeoutSeconds=" + this.extraTimeoutSeconds + ", maxConnectionsPerDestination=" + this.maxConnectionsPerDestination + ", ignoreContentLength=" + this.ignoreContentLength + ", treatClosedChannelAsCancellation=" + this.treatClosedChannelAsCancellation + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpApiHostClient.Config) {
            HttpApiHostClient.Config that = (HttpApiHostClient.Config)o;
            return Double.doubleToLongBits(this.extraTimeoutSeconds) == Double.doubleToLongBits(that.extraTimeoutSeconds()) && this.maxConnectionsPerDestination.equals(that.maxConnectionsPerDestination()) && this.ignoreContentLength == that.ignoreContentLength() && this.treatClosedChannelAsCancellation == that.treatClosedChannelAsCancellation();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.extraTimeoutSeconds) >>> 32 ^ Double.doubleToLongBits(this.extraTimeoutSeconds));
        h$ *= 1000003;
        h$ ^= this.maxConnectionsPerDestination.hashCode();
        h$ *= 1000003;
        h$ ^= this.ignoreContentLength ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.treatClosedChannelAsCancellation ? 1231 : 1237;
    }

    @Override
    HttpApiHostClient.Config.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends HttpApiHostClient.Config.Builder {
        private Double extraTimeoutSeconds;
        private OptionalInt maxConnectionsPerDestination = OptionalInt.empty();
        private Boolean ignoreContentLength;
        private Boolean treatClosedChannelAsCancellation;

        Builder() {
        }

        private Builder(HttpApiHostClient.Config source) {
            this.extraTimeoutSeconds = source.extraTimeoutSeconds();
            this.maxConnectionsPerDestination = source.maxConnectionsPerDestination();
            this.ignoreContentLength = source.ignoreContentLength();
            this.treatClosedChannelAsCancellation = source.treatClosedChannelAsCancellation();
        }

        @Override
        HttpApiHostClient.Config.Builder setExtraTimeoutSeconds(double extraTimeoutSeconds) {
            this.extraTimeoutSeconds = extraTimeoutSeconds;
            return this;
        }

        @Override
        HttpApiHostClient.Config.Builder setMaxConnectionsPerDestination(OptionalInt maxConnectionsPerDestination) {
            if (maxConnectionsPerDestination == null) {
                throw new NullPointerException("Null maxConnectionsPerDestination");
            }
            this.maxConnectionsPerDestination = maxConnectionsPerDestination;
            return this;
        }

        @Override
        HttpApiHostClient.Config.Builder setIgnoreContentLength(boolean ignoreContentLength) {
            this.ignoreContentLength = ignoreContentLength;
            return this;
        }

        @Override
        HttpApiHostClient.Config.Builder setTreatClosedChannelAsCancellation(boolean treatClosedChannelAsCancellation) {
            this.treatClosedChannelAsCancellation = treatClosedChannelAsCancellation;
            return this;
        }

        @Override
        HttpApiHostClient.Config build() {
            if (this.extraTimeoutSeconds == null || this.ignoreContentLength == null || this.treatClosedChannelAsCancellation == null) {
                StringBuilder missing = new StringBuilder();
                if (this.extraTimeoutSeconds == null) {
                    missing.append(" extraTimeoutSeconds");
                }
                if (this.ignoreContentLength == null) {
                    missing.append(" ignoreContentLength");
                }
                if (this.treatClosedChannelAsCancellation == null) {
                    missing.append(" treatClosedChannelAsCancellation");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_HttpApiHostClient_Config(this.extraTimeoutSeconds, this.maxConnectionsPerDestination, this.ignoreContentLength, this.treatClosedChannelAsCancellation);
        }
    }
}

