/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;

class JettyHttpApiHostClient
extends HttpApiHostClient {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final AtomicInteger threadCount = new AtomicInteger();
    private final String url;
    private final HttpClient httpClient;

    private JettyHttpApiHostClient(String url, HttpClient httpClient, HttpApiHostClient.Config config) {
        super(config);
        this.url = url;
        this.httpClient = httpClient;
    }

    static JettyHttpApiHostClient create(String url, HttpApiHostClient.Config config) {
        Preconditions.checkNotNull(url);
        HttpClient httpClient = new HttpClient();
        String schedulerName = HttpClient.class.getSimpleName() + "@" + httpClient.hashCode() + "-scheduler";
        ClassLoader myLoader = JettyHttpApiHostClient.class.getClassLoader();
        ThreadGroup myThreadGroup = Thread.currentThread().getThreadGroup();
        boolean daemon = false;
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler(schedulerName, daemon, myLoader, myThreadGroup);
        ThreadFactory factory = runnable -> {
            Thread t = new Thread(myThreadGroup, runnable);
            t.setName("JettyHttpApiHostClient-" + threadCount.incrementAndGet());
            t.setDaemon(true);
            return t;
        };
        httpClient.setExecutor(Executors.newCachedThreadPool(factory));
        httpClient.setScheduler(scheduler);
        config.maxConnectionsPerDestination().ifPresent(httpClient::setMaxConnectionsPerDestination);
        try {
            httpClient.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JettyHttpApiHostClient(url, httpClient, config);
    }

    @Override
    void send(byte[] requestBytes, HttpApiHostClient.Context context, AnyRpcCallback<RuntimePb.APIResponse> callback) {
        Request request = this.httpClient.newRequest(this.url).method(HttpMethod.POST).content(new BytesContentProvider(new byte[][]{requestBytes}), "application/octet-stream");
        for (Map.Entry header : HEADERS.entrySet()) {
            request.header((String)header.getKey(), (String)header.getValue());
        }
        if (context.getDeadlineNanos().isPresent()) {
            double deadlineSeconds = (double)context.getDeadlineNanos().get().longValue() / 1.0E9;
            request.header("X-Google-RPC-Service-Deadline", Double.toString(deadlineSeconds));
            double fallbackDeadlineSeconds = deadlineSeconds + this.config().extraTimeoutSeconds();
            request.timeout((long)(fallbackDeadlineSeconds * 1.0E9), TimeUnit.NANOSECONDS);
        }
        Listener completeListener = new Listener(context, callback);
        request.send(completeListener);
    }

    @Override
    public synchronized void disable() {
        try {
            this.httpClient.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void enable() {
        try {
            this.httpClient.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Listener
    extends Response.Listener.Adapter {
        private static final int MAX_LENGTH = 52432896;
        private final HttpApiHostClient.Context context;
        private final AnyRpcCallback<RuntimePb.APIResponse> callback;
        private byte[] buffer;
        private int offset;

        Listener(HttpApiHostClient.Context context, AnyRpcCallback<RuntimePb.APIResponse> callback) {
            this.context = context;
            this.callback = callback;
        }

        @Override
        public void onHeaders(Response response) {
            Long length;
            HttpFields headers = response.getHeaders();
            String lengthString = headers.get(HttpHeader.CONTENT_LENGTH.asString());
            Long l = length = lengthString == null ? null : Longs.tryParse(lengthString);
            if (length == null || JettyHttpApiHostClient.this.config().ignoreContentLength()) {
                this.buffer = new byte[2048];
            } else {
                if (length > 52432896L) {
                    this.abortBecauseTooLarge(response);
                    return;
                }
                this.buffer = new byte[length.intValue()];
            }
            this.offset = 0;
        }

        @Override
        public void onContent(Response response, ByteBuffer byteBuffer) {
            int byteCount = byteBuffer.remaining();
            if (this.offset + byteCount > 52432896) {
                this.abortBecauseTooLarge(response);
                return;
            }
            int bufferRemaining = this.buffer.length - this.offset;
            if (byteCount > bufferRemaining) {
                int newSize = Math.max((int)((double)this.buffer.length * 1.5), this.offset + byteCount);
                ((GoogleLogger.Api)logger.atInfo()).log("Had to resize buffer, %d > %d; resizing to %d", byteCount, bufferRemaining, newSize);
                this.buffer = Arrays.copyOf(this.buffer, newSize);
                bufferRemaining = this.buffer.length - this.offset;
                Preconditions.checkState(byteCount <= bufferRemaining);
            }
            byteBuffer.get(this.buffer, this.offset, byteCount);
            this.offset += byteCount;
        }

        private void abortBecauseTooLarge(Response response) {
            response.abort((Throwable)new ApiProxy.ResponseTooLargeException(null, null));
        }

        @Override
        public void onComplete(Result result) {
            if (result.isFailed()) {
                Throwable failure = result.getFailure();
                if (failure instanceof ApiProxy.ResponseTooLargeException) {
                    HttpApiHostClient.responseTooBig(this.callback);
                } else if (failure instanceof TimeoutException) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("HTTP communication timed out");
                    HttpApiHostClient.timeout(this.callback);
                } else if (failure instanceof EofException && failure.getCause() instanceof ClosedByInterruptException) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("HTTP communication interrupted");
                    HttpApiHostClient.cancelled(this.callback);
                } else if ((failure instanceof ClosedChannelException || failure instanceof ClosedSelectorException) && JettyHttpApiHostClient.this.config().treatClosedChannelAsCancellation()) {
                    ((GoogleLogger.Api)logger.atWarning()).log("Treating %s as cancellation", failure.getClass().getSimpleName());
                    HttpApiHostClient.cancelled(this.callback);
                } else if (failure instanceof RejectedExecutionException) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("API connection appears to be disabled");
                    HttpApiHostClient.cancelled(this.callback);
                } else if (failure instanceof HttpResponseException) {
                    HttpResponseException hre = (HttpResponseException)failure;
                    Response response = hre.getResponse();
                    String httpError = response.getStatus() + " " + response.getReason();
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("HTTP communication failed: %s", httpError);
                    if (hre.getCause() == null) {
                        failure = new Exception(httpError, hre);
                    }
                    HttpApiHostClient.communicationFailure(this.context, failure + ": " + httpError, this.callback, failure);
                } else {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("HTTP communication failed");
                    HttpApiHostClient.communicationFailure(this.context, String.valueOf(failure), this.callback, failure);
                }
            } else {
                Response response = result.getResponse();
                if (response.getStatus() == 200) {
                    HttpApiHostClient.receivedResponse(this.buffer, this.offset, this.context, this.callback);
                } else {
                    String httpError = response.getStatus() + " " + response.getReason();
                    ((GoogleLogger.Api)logger.atWarning()).log("HTTP communication got error: %s", httpError);
                    HttpApiHostClient.communicationFailure(this.context, httpError, this.callback, null);
                }
            }
        }
    }
}

