/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.apphosting.api.ApiProxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Logger;

public class JettyLogger
extends JavaUtilLog {
    private static final boolean LOG_TO_API_PROXY = Boolean.getBoolean("appengine.jetty.also_log_to_apiproxy");

    public JettyLogger() {
        this(null);
    }

    public JettyLogger(String name) {
        super("JettyLogger(" + name + ")");
    }

    @Override
    public void warn(String msg, Throwable th) {
        super.warn(msg, th);
        if (LOG_TO_API_PROXY && ApiProxy.getCurrentEnvironment() != null && th != null) {
            ApiProxy.log((ApiProxy.LogRecord)this.createLogRecord(msg, th));
        }
    }

    @Override
    protected Logger newLogger(String name) {
        return new JettyLogger(name);
    }

    public String toString() {
        return this.getName();
    }

    private ApiProxy.LogRecord createLogRecord(String message, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        if (ex != null) {
            ex.printStackTrace(printWriter);
        }
        return new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.warn, System.currentTimeMillis() * 1000L, stringWriter.toString());
    }
}

