/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.apphosting.utils.servlet.MultipartMimeUtils;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class ParseBlobUploadHandler
extends HandlerWrapper {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final String UPLOAD_HEADER = "X-AppEngine-BlobUpload";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String UPLOADED_BLOBINFO_ATTR = "com.google.appengine.api.blobstore.upload.blobinfos";
    static final String UPLOAD_CREATION_HEADER = "X-AppEngine-Upload-Creation";
    static final String CLOUD_STORAGE_OBJECT_HEADER = "X-AppEngine-Cloud-Storage-Object";
    static final String CONTENT_LENGTH_HEADER = "Content-Length";

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.getDispatcherType() == DispatcherType.REQUEST && request.getHeader(UPLOAD_HEADER) != null) {
            HashMap<String, List> blobKeys = new HashMap<String, List>();
            HashMap<String, ArrayList<Map<String, String>>> blobInfos = new HashMap<String, ArrayList<Map<String, String>>>();
            HashMap<String, List<String>> otherParams = new HashMap<String, List<String>>();
            try {
                MimeMultipart multipart = MultipartMimeUtils.parseMultipartRequest(request);
                int parts = multipart.getCount();
                for (int i = 0; i < parts; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    String fieldName = MultipartMimeUtils.getFieldName(part);
                    if (part.getFileName() != null) {
                        ContentType contentType = new ContentType(part.getContentType());
                        if (!"message/external-body".equals(contentType.getBaseType())) continue;
                        String blobKeyString = contentType.getParameter("blob-key");
                        List keys = blobKeys.computeIfAbsent(fieldName, k -> new ArrayList());
                        keys.add(blobKeyString);
                        ArrayList<Map<String, String>> infos = (ArrayList<Map<String, String>>)blobInfos.get(fieldName);
                        if (infos == null) {
                            infos = new ArrayList<Map<String, String>>();
                            blobInfos.put(fieldName, infos);
                        }
                        infos.add(this.getInfoFromBody(MultipartMimeUtils.getTextContent(part), blobKeyString));
                        continue;
                    }
                    List values = otherParams.computeIfAbsent(fieldName, k -> new ArrayList());
                    values.add(MultipartMimeUtils.getTextContent(part));
                }
                request.setAttribute(UPLOADED_BLOBKEY_ATTR, blobKeys);
                request.setAttribute(UPLOADED_BLOBINFO_ATTR, blobInfos);
            }
            catch (MessagingException ex) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(ex)).log("Could not parse multipart message:");
            }
            super.handle(target, baseRequest, (HttpServletRequest)new ParameterServletWrapper((ServletRequest)request, otherParams), response);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private Map<String, String> getInfoFromBody(String bodyContent, String key) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart(new ByteArrayInputStream(bodyContent.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> info = Maps.newHashMapWithExpectedSize(6);
        info.put("key", key);
        info.put("content-type", part.getContentType());
        info.put("creation-date", part.getHeader(UPLOAD_CREATION_HEADER)[0]);
        info.put("filename", part.getFileName());
        info.put("size", part.getHeader(CONTENT_LENGTH_HEADER)[0]);
        info.put("md5-hash", part.getContentMD5());
        String[] headers = part.getHeader(CLOUD_STORAGE_OBJECT_HEADER);
        if (headers != null && headers.length == 1) {
            info.put("gs-name", headers[0]);
        }
        return info;
    }

    private static class ParameterServletWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, List<String>> otherParams;

        ParameterServletWrapper(ServletRequest request, Map<String, List<String>> otherParams) {
            super((HttpServletRequest)request);
            this.otherParams = otherParams;
        }

        public Map getParameterMap() {
            Map parameters = super.getParameterMap();
            if (this.otherParams.isEmpty()) {
                return parameters;
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>(parameters);
            for (Map.Entry<String, List<String>> entry : this.otherParams.entrySet()) {
                map.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
            return Collections.unmodifiableMap(map);
        }

        public Enumeration getParameterNames() {
            ArrayList allNames = new ArrayList();
            Enumeration names = super.getParameterNames();
            while (names.hasMoreElements()) {
                allNames.add(names.nextElement());
            }
            allNames.addAll(this.otherParams.keySet());
            return Collections.enumeration(allNames);
        }

        public String[] getParameterValues(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).toArray(new String[0]);
            }
            return super.getParameterValues(name);
        }

        public String getParameter(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).get(0);
            }
            return super.getParameter(name);
        }
    }
}

