/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.jetty9.AppEngineAuthentication;
import com.google.apphosting.runtime.jetty9.ParseBlobUploadHandler;
import com.google.apphosting.runtime.jetty9.RequestListener;
import com.google.apphosting.runtime.jetty9.TransactionCleanupListener;
import com.google.apphosting.runtime.jetty94.IgnoreContentLengthResponseWrapper;
import com.google.apphosting.runtime.jetty94.NamedDefaultServlet;
import com.google.apphosting.runtime.jetty94.NamedJspServlet;
import com.google.apphosting.runtime.jetty94.ResourceFileServlet;
import com.google.apphosting.utils.servlet.DeferredTaskServlet;
import com.google.apphosting.utils.servlet.JdbcMySqlConnectionCleanupFilter;
import com.google.apphosting.utils.servlet.SessionCleanupServlet;
import com.google.apphosting.utils.servlet.SnapshotServlet;
import com.google.apphosting.utils.servlet.WarmupServlet;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;

public class AppEngineWebAppContext
extends WebAppContext {
    private static final int MAX_RESPONSE_SIZE = 0x2000000;
    private static final boolean APP_IS_ASYNC = Boolean.getBoolean("com.google.appengine.enable_async");
    private static final String JETTY_PACKAGE = "org.eclipse.jetty.";
    private static final String IGNORE_CONTENT_LENGTH = "/base/java8_runtime/appengine.ignore-content-length";
    private final String serverInfo;
    private final boolean extractWar;
    private final List<RequestListener> requestListeners = new CopyOnWriteArrayList<RequestListener>();
    private final boolean ignoreContentLength;
    private static final ImmutableSet<HolderMatcher> DEPRECATED_SERVLETS_FILTERS = ImmutableSet.of(new HolderMatcher("AbandonedTransactionDetector", "com.google.apphosting.utils.servlet.TransactionCleanupFilter"), new HolderMatcher("SaveSessionFilter", "com.google.apphosting.runtime.jetty9.SaveSessionFilter"), new HolderMatcher("_ah_ParseBlobUploadFilter", "com.google.apphosting.utils.servlet.ParseBlobUploadFilter"), new HolderMatcher("_ah_default", "com.google.apphosting.runtime.jetty9.ResourceFileServlet"), new HolderMatcher("default", "com.google.apphosting.runtime.jetty9.NamedDefaultServlet"), new HolderMatcher("jsp", "com.google.apphosting.runtime.jetty9.NoJspSerlvet"), new HolderMatcher[]{new HolderMatcher(null, "com.google.appengine.tools.appstats.AppstatsFilter"), new HolderMatcher(null, "com.google.appengine.tools.appstats.AppstatsServlet")});

    @Override
    public boolean checkAlias(String path, Resource resource) {
        return true;
    }

    public AppEngineWebAppContext(File appDir, String serverInfo) {
        this(appDir, serverInfo, true);
    }

    public AppEngineWebAppContext(File appDir, String serverInfo, boolean extractWar) {
        super(appDir.getPath(), "/");
        this.extractWar = extractWar;
        this.setThrowUnavailableOnStartupException(true);
        if (extractWar) {
            Resource webApp = null;
            try {
                webApp = Resource.newResource(appDir.getAbsolutePath());
                if (appDir.isDirectory()) {
                    this.setWar(appDir.getPath());
                    this.setBaseResource(webApp);
                }
                File extractedWebAppDir = AppEngineWebAppContext.createTempDir();
                extractedWebAppDir.mkdir();
                extractedWebAppDir.deleteOnExit();
                Resource jarWebWpp = JarResource.newJarResource(webApp);
                jarWebWpp.copyTo(extractedWebAppDir);
                this.setBaseResource(Resource.newResource(extractedWebAppDir.getAbsolutePath()));
                this.setWar(extractedWebAppDir.getPath());
            }
            catch (Exception e) {
                throw new IllegalStateException("cannot create AppEngineWebAppContext:", e);
            }
        } else {
            this.setWar(appDir.getPath());
        }
        this.serverInfo = serverInfo;
        this._scontext = new AppEngineServletContext();
        AppEngineAuthentication.configureSecurityHandler((ConstraintSecurityHandler)this.getSecurityHandler());
        this.setMaxFormContentSize(0x2000000);
        this.insertHandler(new ParseBlobUploadHandler());
        this.ignoreContentLength = AppEngineWebAppContext.isAppIdForNonContentLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAppIdForNonContentLength() {
        String projectId = System.getenv("GOOGLE_CLOUD_PROJECT");
        if (projectId == null) {
            return false;
        }
        try (Scanner s = new Scanner(new File(IGNORE_CONTENT_LENGTH), StandardCharsets.UTF_8.name());){
            do {
                if (!s.hasNext()) return false;
            } while (!projectId.equals(s.next()));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ignore) {
            return false;
        }
    }

    @Override
    public void addEventListener(EventListener listener) {
        super.addEventListener(listener);
        if (listener instanceof RequestListener) {
            this.requestListeners.add((RequestListener)listener);
        }
    }

    @Override
    public void removeEventListener(EventListener listener) {
        super.removeEventListener(listener);
        if (listener instanceof RequestListener) {
            this.requestListeners.remove((RequestListener)listener);
        }
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.addEventListener(new TransactionCleanupListener(this.getClassLoader()));
    }

    @Override
    protected void startWebapp() throws Exception {
        ServletHandler servletHandler = this.getServletHandler();
        TrimmedFilters trimmedFilters = new TrimmedFilters(servletHandler.getFilters(), servletHandler.getFilterMappings(), DEPRECATED_SERVLETS_FILTERS);
        trimmedFilters.ensure("CloudSqlConnectionCleanupFilter", JdbcMySqlConnectionCleanupFilter.class, "/*");
        TrimmedServlets trimmedServlets = new TrimmedServlets(servletHandler.getServlets(), servletHandler.getServletMappings(), DEPRECATED_SERVLETS_FILTERS);
        trimmedServlets.ensure("_ah_warmup", WarmupServlet.class, "/_ah/warmup");
        trimmedServlets.ensure("_ah_sessioncleanup", SessionCleanupServlet.class, "/_ah/sessioncleanup");
        trimmedServlets.ensure("_ah_queue_deferred", DeferredTaskServlet.class, "/_ah/queue/__deferred__");
        trimmedServlets.ensure("_ah_snapshot", SnapshotServlet.class, "/_ah/snapshot");
        trimmedServlets.ensure("_ah_default", ResourceFileServlet.class, "/");
        trimmedServlets.ensure("default", NamedDefaultServlet.class);
        trimmedServlets.ensure("jsp", NamedJspServlet.class);
        trimmedServlets.instantiateJettyServlets();
        trimmedFilters.instantiateJettyFilters();
        this.instantiateJettyListeners();
        servletHandler.setFilters(trimmedFilters.getHolders());
        servletHandler.setFilterMappings(trimmedFilters.getMappings());
        servletHandler.setServlets(trimmedServlets.getHolders());
        servletHandler.setServletMappings(trimmedServlets.getMappings());
        servletHandler.setAllowDuplicateMappings(true);
        ConstraintSecurityHandler security = this.getChildHandlerByClass(ConstraintSecurityHandler.class);
        Constraint c = new Constraint("deferred_queue", "admin");
        c.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(c);
        cm.setPathSpec("/_ah/queue/__deferred__");
        security.addConstraintMapping(cm);
        super.startWebapp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ListIterator<RequestListener> iter = this.requestListeners.listIterator();
        while (iter.hasNext()) {
            iter.next().requestReceived(this, baseRequest);
        }
        try {
            if (this.ignoreContentLength) {
                response = new IgnoreContentLengthResponseWrapper((HttpServletResponse)response);
            }
            super.doHandle(target, baseRequest, request, (HttpServletResponse)response);
        }
        finally {
            while (iter.hasPrevious()) {
                iter.previous().requestComplete(this, baseRequest);
            }
        }
    }

    @Override
    protected ServletHandler newServletHandler() {
        ServletHandler handler = new ServletHandler();
        handler.setAllowDuplicateMappings(true);
        return handler;
    }

    private void instantiateJettyListeners() throws ReflectiveOperationException {
        ListenerHolder[] listeners = this.getServletHandler().getListeners();
        if (listeners != null) {
            for (ListenerHolder h : listeners) {
                if (!h.getClassName().startsWith(JETTY_PACKAGE)) continue;
                Class<EventListener> listener = ServletHandler.class.getClassLoader().loadClass(h.getClassName()).asSubclass(EventListener.class);
                h.setListener(listener.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
    }

    private static File createTempDir() {
        File baseDir = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory ");
    }

    @Override
    public File getTempDirectory() {
        if (this.extractWar) {
            return new File(this.getWar());
        }
        return super.getTempDirectory();
    }

    @Override
    public void setTempDirectory(File dir) {
        if (dir != null && !dir.exists()) {
            dir.mkdir();
        }
        super.setTempDirectory(dir);
    }

    private static class TrimmedFilters {
        private final Map<String, FilterHolder> holders = new HashMap<String, FilterHolder>();
        private final List<FilterMapping> mappings = new ArrayList<FilterMapping>();

        TrimmedFilters(FilterHolder[] holders, FilterMapping[] mappings, Set<HolderMatcher> deprecations) {
            for (FilterHolder filterHolder : holders) {
                boolean deprecated = false;
                filterHolder.setAsyncSupported(APP_IS_ASYNC);
                for (HolderMatcher m : deprecations) {
                    deprecated |= m.appliesTo(filterHolder);
                }
                if (deprecated) continue;
                this.holders.put(filterHolder.getName(), filterHolder);
            }
            for (Dumpable dumpable : mappings) {
                this.mappings.add((FilterMapping)dumpable);
            }
        }

        void ensure(String name, Class<? extends Filter> filter, String pathSpec) throws Exception {
            for (FilterHolder h : this.holders.values()) {
                if (!filter.getName().equals(h.getClassName())) continue;
                h.setFilter(filter.getConstructor(new Class[0]).newInstance(new Object[0]));
                h.setAsyncSupported(APP_IS_ASYNC);
            }
            FilterHolder holder = this.holders.get(name);
            if (holder == null) {
                holder = new FilterHolder(filter.getConstructor(new Class[0]).newInstance(new Object[0]));
                holder.setName(name);
                this.holders.put(name, holder);
                holder.setAsyncSupported(APP_IS_ASYNC);
            }
            boolean mapped = false;
            block1: for (FilterMapping mapping : this.mappings) {
                for (String ps : mapping.getPathSpecs()) {
                    if (!pathSpec.equals(ps) || !name.equals(mapping.getFilterName())) continue;
                    mapped = true;
                    continue block1;
                }
            }
            if (!mapped) {
                FilterMapping mapping = new FilterMapping();
                mapping.setFilterName(name);
                mapping.setPathSpec(pathSpec);
                mapping.setDispatches(1);
                this.mappings.add(mapping);
            }
        }

        void instantiateJettyFilters() throws ReflectiveOperationException {
            for (FilterHolder h : this.holders.values()) {
                if (!h.getClassName().startsWith(AppEngineWebAppContext.JETTY_PACKAGE)) continue;
                Class<Filter> filter = ServletHolder.class.getClassLoader().loadClass(h.getClassName()).asSubclass(Filter.class);
                h.setFilter(filter.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }

        FilterHolder[] getHolders() {
            return this.holders.values().toArray(new FilterHolder[0]);
        }

        FilterMapping[] getMappings() {
            ArrayList<FilterMapping> trimmed = new ArrayList<FilterMapping>(this.mappings.size());
            for (FilterMapping m : this.mappings) {
                if (!this.holders.containsKey(m.getFilterName())) continue;
                trimmed.add(m);
            }
            return trimmed.toArray(new FilterMapping[0]);
        }
    }

    private static class TrimmedServlets {
        private final Map<String, ServletHolder> holders = new HashMap<String, ServletHolder>();
        private final List<ServletMapping> mappings = new ArrayList<ServletMapping>();

        TrimmedServlets(ServletHolder[] holders, ServletMapping[] mappings, Set<HolderMatcher> deprecations) {
            for (ServletHolder servletHolder : holders) {
                boolean deprecated = false;
                servletHolder.setAsyncSupported(APP_IS_ASYNC);
                for (HolderMatcher holderMatcher : deprecations) {
                    deprecated |= holderMatcher.appliesTo(servletHolder);
                }
                if (deprecated) continue;
                this.holders.put(servletHolder.getName(), servletHolder);
            }
            for (ServletMapping m : mappings) {
                this.mappings.add(m);
            }
        }

        void ensure(String name, Class<? extends Servlet> servlet) throws ReflectiveOperationException {
            for (ServletHolder h : this.holders.values()) {
                if (!servlet.getName().equals(h.getClassName())) continue;
                h.setServlet(servlet.getConstructor(new Class[0]).newInstance(new Object[0]));
                h.setAsyncSupported(APP_IS_ASYNC);
            }
            ServletHolder holder = this.holders.get(name);
            if (holder == null) {
                holder = new ServletHolder(servlet.getConstructor(new Class[0]).newInstance(new Object[0]));
                holder.setInitOrder(1);
                holder.setName(name);
                holder.setAsyncSupported(APP_IS_ASYNC);
                this.holders.put(name, holder);
            }
        }

        void ensure(String name, Class<? extends Servlet> servlet, String pathSpec) throws ReflectiveOperationException {
            this.ensure(name, servlet);
            if (pathSpec != null) {
                boolean mapped = false;
                for (ServletMapping mapping : this.mappings) {
                    if (!mapping.containsPathSpec(pathSpec)) continue;
                    mapped = true;
                    break;
                }
                if (!mapped) {
                    ServletMapping mapping = new ServletMapping();
                    mapping.setServletName(name);
                    mapping.setPathSpec(pathSpec);
                    if (pathSpec.equals("/")) {
                        mapping.setDefault(true);
                    }
                    this.mappings.add(mapping);
                }
            }
        }

        void instantiateJettyServlets() throws ReflectiveOperationException {
            for (ServletHolder h : this.holders.values()) {
                if (h.getClassName() == null || !h.getClassName().startsWith(AppEngineWebAppContext.JETTY_PACKAGE)) continue;
                Class<Servlet> servlet = ServletHolder.class.getClassLoader().loadClass(h.getClassName()).asSubclass(Servlet.class);
                h.setServlet(servlet.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }

        ServletHolder[] getHolders() {
            return this.holders.values().toArray(new ServletHolder[0]);
        }

        ServletMapping[] getMappings() {
            ArrayList<ServletMapping> trimmed = new ArrayList<ServletMapping>(this.mappings.size());
            for (ServletMapping m : this.mappings) {
                if (!this.holders.containsKey(m.getServletName())) continue;
                trimmed.add(m);
            }
            return trimmed.toArray(new ServletMapping[0]);
        }
    }

    private static class HolderMatcher {
        final String name;
        final String className;

        HolderMatcher(String name, String className) {
            this.name = name;
            this.className = className;
        }

        boolean appliesTo(Holder<?> holder) {
            if (this.name != null && !this.name.equals(holder.getName())) {
                return false;
            }
            return this.className == null || this.className.equals(holder.getClassName());
        }
    }

    public class AppEngineServletContext
    extends WebAppContext.Context {
        public AppEngineServletContext() {
            super(AppEngineWebAppContext.this);
        }

        @Override
        public ClassLoader getClassLoader() {
            return AppEngineWebAppContext.this.getClassLoader();
        }

        @Override
        public String getServerInfo() {
            return AppEngineWebAppContext.this.serverInfo;
        }

        @Override
        public void log(String message) {
            this.log(message, null);
        }

        @Override
        public void log(String message, Throwable throwable) {
            StringWriter writer = new StringWriter();
            writer.append("javax.servlet.ServletContext log: ");
            writer.append(message);
            if (throwable != null) {
                writer.append("\n");
                throwable.printStackTrace(new PrintWriter(writer));
            }
            ApiProxy.LogRecord.Level logLevel = throwable == null ? ApiProxy.LogRecord.Level.info : ApiProxy.LogRecord.Level.error;
            ApiProxy.log((ApiProxy.LogRecord)new ApiProxy.LogRecord(logLevel, System.currentTimeMillis() * 1000L, writer.toString()));
        }

        @Override
        public void log(Exception exception, String msg) {
            this.log(msg, exception);
        }
    }
}

