/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import javax.annotation.Nullable;

public class AppInfoFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String DEFAULT_CLOUD_PROJECT = "testapp";
    private static final String DEFAULT_GAE_APPLICATION = "s~testapp";
    private static final String DEFAULT_GAE_SERVICE = "default";
    private static final String DEFAULT_GAE_VERSION = "1.0";
    private static final String APP_YAML_PATH = "WEB-INF/appengine-generated/app.yaml";
    private final String gaeVersion;
    private final String googleCloudProject;
    private final String gaeApplication;
    private final String gaeService;
    private final String gaeServiceVersion;

    public AppInfoFactory(Map<String, String> env) {
        String version = env.getOrDefault("GAE_VERSION", DEFAULT_GAE_VERSION);
        String deploymentId = env.getOrDefault("GAE_DEPLOYMENT_ID", null);
        this.gaeServiceVersion = deploymentId != null ? version + "." + deploymentId : version;
        this.gaeService = env.getOrDefault("GAE_SERVICE", DEFAULT_GAE_SERVICE);
        this.gaeVersion = DEFAULT_GAE_SERVICE.equals(this.gaeService) ? this.gaeServiceVersion : this.gaeService + ":" + this.gaeServiceVersion;
        this.googleCloudProject = env.getOrDefault("GOOGLE_CLOUD_PROJECT", DEFAULT_CLOUD_PROJECT);
        this.gaeApplication = env.getOrDefault("GAE_APPLICATION", DEFAULT_GAE_APPLICATION);
    }

    public String getGaeService() {
        return this.gaeService;
    }

    public String getGaeVersion() {
        return this.gaeVersion;
    }

    public String getGaeServiceVersion() {
        return this.gaeServiceVersion;
    }

    public String getGaeApplication() {
        return this.gaeApplication;
    }

    public AppinfoPb.AppInfo getAppInfoFromFile(String applicationRoot, String fixedApplicationPath) throws IOException {
        String applicationPath;
        String string = applicationPath = fixedApplicationPath == null ? applicationRoot + "/" + this.googleCloudProject + "/" + this.gaeServiceVersion : fixedApplicationPath;
        if (!new File(applicationPath).exists()) {
            throw new NoSuchFileException("Application does not exist under: " + applicationPath);
        }
        String apiVersion = null;
        File appYamlFile = new File(applicationPath, APP_YAML_PATH);
        try {
            YamlReader reader = new YamlReader(Files.newBufferedReader(appYamlFile.toPath(), StandardCharsets.UTF_8));
            Object apiVersionObj = ((Map)reader.read()).get("api_version");
            if (apiVersionObj != null) {
                apiVersion = (String)apiVersionObj;
            }
        }
        catch (NoSuchFileException ex) {
            ((GoogleLogger.Api)logger.atInfo()).log("Cannot configure App Engine APIs, because the generated app.yaml file does not exist: %s", appYamlFile.getAbsolutePath());
        }
        return this.getAppInfoWithApiVersion(apiVersion);
    }

    public AppinfoPb.AppInfo getAppInfoFromAppYaml(AppYaml appYaml) throws IOException {
        return this.getAppInfoWithApiVersion(appYaml.getApi_version());
    }

    public AppinfoPb.AppInfo getAppInfoWithApiVersion(@Nullable String apiVersion) {
        AppinfoPb.AppInfo.Builder appInfoBuilder = AppinfoPb.AppInfo.newBuilder().setAppId(this.gaeApplication).setVersionId(this.gaeVersion).setRuntimeId("java8");
        if (apiVersion != null) {
            appInfoBuilder.setApiVersion(apiVersion);
        }
        return appInfoBuilder.build();
    }
}

