/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.regex.Pattern;

final class CacheControlHeader {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String DEFAULT_BASE_VALUE = "public, max-age=";
    private static final String DEFAULT_MAX_AGE = "600";
    private static final ImmutableMap<String, TemporalUnit> EXPIRATION_TIME_UNITS = ImmutableMap.of("s", ChronoUnit.SECONDS, "m", ChronoUnit.MINUTES, "h", ChronoUnit.HOURS, "d", ChronoUnit.DAYS);
    private final String value;

    private CacheControlHeader(String value) {
        this.value = value;
    }

    static CacheControlHeader getDefaultInstance() {
        return new CacheControlHeader("public, max-age=600");
    }

    static CacheControlHeader fromExpirationTime(String expirationTime) {
        String maxAge = DEFAULT_MAX_AGE;
        if (expirationTime != null) {
            if (CacheControlHeader.expirationTimeIsValid(expirationTime)) {
                Duration totalTime = Duration.ZERO;
                for (String timeString : Splitter.on(" ").split(expirationTime)) {
                    String timeUnitShort = Ascii.toLowerCase(timeString.substring(timeString.length() - 1));
                    TemporalUnit timeUnit = EXPIRATION_TIME_UNITS.get(timeUnitShort);
                    String timeValue = timeString.substring(0, timeString.length() - 1);
                    totalTime = totalTime.plus(Long.parseLong(timeValue), timeUnit);
                }
                maxAge = String.valueOf(totalTime.getSeconds());
            } else {
                ((GoogleLogger.Api)logger.atWarning()).log("Failed to parse expiration time: \"%s\". Using default value instead.", expirationTime);
            }
        }
        String output = DEFAULT_BASE_VALUE + maxAge;
        return new CacheControlHeader(output);
    }

    String getValue() {
        return this.value;
    }

    private static boolean expirationTimeIsValid(String expirationTime) {
        String expirationTokenPattern = "\\d+[smhd]";
        Pattern pattern = Pattern.compile("^" + expirationTokenPattern + "(\\s" + expirationTokenPattern + ")*$");
        return pattern.matcher(expirationTime).matches();
    }
}

