/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.apphosting.runtime.jetty94.AppInfoFactory;
import com.google.apphosting.runtime.jetty94.JettyServerConnectorWithReusePort;
import com.google.apphosting.runtime.jetty94.RpcConnector;
import com.google.apphosting.runtime.jetty94.UPRequestTranslator;
import com.google.common.base.Ascii;
import com.google.common.base.Throwables;
import com.google.common.flogger.GoogleLogger;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

public class JettyHttpProxy {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String JETTY_LOG_CLASS = "org.eclipse.jetty.util.log.class";
    private static final String JETTY_STDERRLOG = "org.eclipse.jetty.util.log.StdErrLog";

    public static void startServer(ServletEngineAdapter.Config runtimeOptions) {
        try {
            System.setProperty(JETTY_LOG_CLASS, JETTY_STDERRLOG);
            ForwardingHandler handler = new ForwardingHandler(runtimeOptions, System.getenv());
            handler.init();
            Server server = JettyHttpProxy.newServer(runtimeOptions, handler);
            server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Server newServer(ServletEngineAdapter.Config runtimeOptions, ForwardingHandler handler) {
        Server server = new Server();
        JettyServerConnectorWithReusePort c = new JettyServerConnectorWithReusePort(server, runtimeOptions.jettyReusePort());
        c.setHost(runtimeOptions.jettyHttpAddress().getHost());
        c.setPort(runtimeOptions.jettyHttpAddress().getPort());
        server.setConnectors(new Connector[]{c});
        HttpConnectionFactory factory = c.getConnectionFactory(HttpConnectionFactory.class);
        factory.setHttpCompliance(RpcConnector.LEGACY_MODE ? HttpCompliance.RFC7230_LEGACY : HttpCompliance.RFC7230);
        HttpConfiguration config = factory.getHttpConfiguration();
        config.setRequestHeaderSize(runtimeOptions.jettyRequestHeaderSize());
        config.setResponseHeaderSize(runtimeOptions.jettyResponseHeaderSize());
        config.setSendDateHeader(false);
        config.setSendServerVersion(false);
        config.setSendXPoweredBy(false);
        GzipHandler gzip = new GzipHandler();
        gzip.setIncludedMethods("GET", "POST");
        gzip.setInflateBufferSize(8192);
        server.setHandler(gzip);
        gzip.setHandler(handler);
        ((GoogleLogger.Api)logger.atInfo()).log("Starting Jetty http server for Java runtime proxy.");
        return server;
    }

    private static Level toJavaLevel(long level) {
        switch (Ints.saturatedCast(level)) {
            case 0: {
                return Level.FINE;
            }
            case 1: {
                return Level.INFO;
            }
            case 3: 
            case 4: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }

    private JettyHttpProxy() {
    }

    public static class ForwardingHandler
    extends AbstractHandler {
        private static final String X_APPENGINE_TIMEOUT_MS = "x-appengine-timeout-ms";
        private final String applicationRoot;
        private final String fixedApplicationPath;
        private final AppInfoFactory appInfoFactory;
        private final EvaluationRuntimeServerInterface evaluationRuntimeServerInterface;
        private final UPRequestTranslator upRequestTranslator;

        public ForwardingHandler(ServletEngineAdapter.Config runtimeOptions, Map<String, String> env) throws ExecutionException, InterruptedException, IOException {
            this.applicationRoot = runtimeOptions.applicationRoot();
            this.fixedApplicationPath = runtimeOptions.fixedApplicationPath();
            this.appInfoFactory = new AppInfoFactory(env);
            this.evaluationRuntimeServerInterface = runtimeOptions.evaluationRuntimeServerInterface();
            this.upRequestTranslator = new UPRequestTranslator(this.appInfoFactory, runtimeOptions.passThroughPrivateHeaders(), false);
        }

        private void init() {
            try {
                AppinfoPb.AppInfo appinfo = this.appInfoFactory.getAppInfoFromFile(this.applicationRoot, this.fixedApplicationPath);
                LocalRpcContext context = new LocalRpcContext(EmptyMessage.class);
                this.evaluationRuntimeServerInterface.addAppVersion(context, appinfo);
                context.getResponse();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            baseRequest.setHandled(true);
            RuntimePb.UPRequest upRequest = this.upRequestTranslator.translateRequest(baseRequest);
            try {
                RuntimePb.UPResponse upResponse = this.getUpResponse(upRequest);
                this.upRequestTranslator.translateResponse(baseRequest.getResponse(), upResponse);
            }
            catch (Exception ex) {
                UPRequestTranslator.populateErrorResponse(response, "Can't make request of app: " + Throwables.getStackTraceAsString(ex));
            }
        }

        RuntimePb.UPResponse getUpResponse(RuntimePb.UPRequest upRequest) throws ExecutionException, InterruptedException {
            Duration timeRemaining = upRequest.getRuntimeHeadersList().stream().filter(p -> Ascii.equalsIgnoreCase(p.getKey(), X_APPENGINE_TIMEOUT_MS)).map(p -> Duration.ofMillis(Long.parseLong(p.getValue()))).findFirst().orElse(Duration.ofNanos(Long.MAX_VALUE));
            LocalRpcContext context = new LocalRpcContext(RuntimePb.UPResponse.class, timeRemaining);
            this.evaluationRuntimeServerInterface.handleRequest(context, upRequest);
            RuntimePb.UPResponse upResponse = (RuntimePb.UPResponse)context.getResponse();
            for (AppLogsPb.AppLogLine line : upResponse.getAppLogList()) {
                logger.at(JettyHttpProxy.toJavaLevel(line.getLevel())).log("%s", line.getMessage());
            }
            return upResponse;
        }
    }

    private static class LocalRpcContext<M extends MessageLite>
    implements AnyRpcServerContext {
        private static final AtomicLong globalIds = new AtomicLong();
        private final Class<M> responseMessageClass;
        private final long startTimeMillis;
        private final Duration timeRemaining;
        private final SettableFuture<M> futureResponse = SettableFuture.create();
        private final long globalId = globalIds.getAndIncrement();

        private LocalRpcContext(Class<M> responseMessageClass) {
            this(responseMessageClass, Duration.ofNanos(Long.MAX_VALUE));
        }

        private LocalRpcContext(Class<M> responseMessageClass, Duration timeRemaining) {
            this.responseMessageClass = responseMessageClass;
            this.startTimeMillis = System.currentTimeMillis();
            this.timeRemaining = timeRemaining;
        }

        @Override
        public void finishWithResponse(MessageLite response) {
            this.futureResponse.set(this.responseMessageClass.cast(response));
        }

        M getResponse() throws ExecutionException, InterruptedException {
            return (M)((MessageLite)this.futureResponse.get());
        }

        @Override
        public void finishWithAppError(int appErrorCode, String errorDetail) {
            String message = "AppError: code " + appErrorCode + "; errorDetail " + errorDetail;
            this.futureResponse.setException(new RuntimeException(message));
        }

        @Override
        public Duration getTimeRemaining() {
            return this.timeRemaining;
        }

        @Override
        public long getGlobalId() {
            return this.globalId;
        }

        @Override
        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }
    }
}

