/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.util.Objects;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.IO;

public class JettyServerConnectorWithReusePort
extends ServerConnector {
    private final boolean reusePort;

    public JettyServerConnectorWithReusePort(Server server, boolean reusePort) {
        super(server);
        this.reusePort = reusePort;
    }

    static void setReusePort(ServerSocketChannel serverChannel) throws IOException {
        Object o;
        if (Objects.equals(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value(), "1.8")) {
            throw new IOException("Cannot use SO_REUSEPORT with Java <9.");
        }
        try {
            Field f = StandardSocketOptions.class.getField("SO_REUSEPORT");
            o = f.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Could not set SO_REUSEPORT as requested", e);
        }
        SocketOption so = (SocketOption)o;
        serverChannel.setOption(so, (Object)true);
    }

    @Override
    protected ServerSocketChannel openAcceptChannel() throws IOException {
        InetSocketAddress bindAddress = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        if (this.reusePort) {
            JettyServerConnectorWithReusePort.setReusePort(serverChannel);
        }
        serverChannel.socket().setReuseAddress(this.getReuseAddress());
        try {
            serverChannel.socket().bind(bindAddress, this.getAcceptQueueSize());
        }
        catch (Throwable e) {
            IO.close(serverChannel);
            throw new IOException("Failed to bind to " + bindAddress, e);
        }
        return serverChannel;
    }
}

