/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.apphosting.runtime.SessionStoreFactory;
import com.google.apphosting.runtime.jetty9.JettyLogger;
import com.google.apphosting.runtime.jetty94.AppEngineWebAppContextFactory;
import com.google.apphosting.runtime.jetty94.AppVersionHandlerFactory;
import com.google.apphosting.runtime.jetty94.AppVersionHandlerMap;
import com.google.apphosting.runtime.jetty94.JettyHttpProxy;
import com.google.apphosting.runtime.jetty94.RpcConnector;
import com.google.apphosting.runtime.jetty94.WebAppContextFactory;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyServletEngineAdapter
implements ServletEngineAdapter {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String DEFAULT_APP_YAML_PATH = "/WEB-INF/appengine-generated/app.yaml";
    private static final int MIN_THREAD_POOL_THREADS = 0;
    private static final int MAX_THREAD_POOL_THREADS = 100;
    private AppVersionKey lastAppVersionKey;
    private Server server;
    private RpcConnector rpcConnector;
    private AppVersionHandlerMap appVersionHandlerMap;
    private final WebAppContextFactory contextFactory;
    private final Optional<AppYaml> appYaml;

    public JettyServletEngineAdapter() {
        this(Optional.empty(), Optional.empty());
    }

    public JettyServletEngineAdapter(Optional<WebAppContextFactory> contextFactory, Optional<AppYaml> appYaml) {
        this.contextFactory = contextFactory.orElseGet(AppEngineWebAppContextFactory::new);
        this.appYaml = appYaml;
    }

    private static AppYaml getAppYaml(ServletEngineAdapter.Config runtimeOptions) {
        String applicationPath = runtimeOptions.fixedApplicationPath();
        File appYamlFile = new File(applicationPath + DEFAULT_APP_YAML_PATH);
        AppYaml appYaml = null;
        try {
            appYaml = AppYaml.parse(new InputStreamReader((InputStream)new FileInputStream(appYamlFile), StandardCharsets.UTF_8));
        }
        catch (AppEngineConfigException | FileNotFoundException e) {
            ((GoogleLogger.Api)logger.atWarning()).log("Failed to load app.yaml file at location %s - %s", (Object)appYamlFile.getPath(), (Object)e.getMessage());
        }
        return appYaml;
    }

    @Override
    public void start(String serverInfo, ServletEngineAdapter.Config runtimeOptions) {
        this.server = new Server(new QueuedThreadPool(100, 0));
        this.rpcConnector = new RpcConnector(this.server);
        this.server.setConnectors(new Connector[]{this.rpcConnector});
        AppVersionHandlerFactory appVersionHandlerFactory = new AppVersionHandlerFactory(this.server, serverInfo, this.contextFactory, false);
        this.appVersionHandlerMap = new AppVersionHandlerMap(appVersionHandlerFactory);
        this.server.setHandler(this.appVersionHandlerMap);
        if (runtimeOptions.useJettyHttpProxy()) {
            this.server.setAttribute("com.google.apphosting.runtime.jetty94.appYaml", this.appYaml.orElseGet(() -> JettyServletEngineAdapter.getAppYaml(runtimeOptions)));
            JettyHttpProxy.startServer(runtimeOptions);
        }
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addAppVersion(AppVersion appVersion) throws FileNotFoundException {
        this.appVersionHandlerMap.addAppVersion(appVersion);
    }

    @Override
    public void deleteAppVersion(AppVersion appVersion) {
        this.appVersionHandlerMap.removeAppVersion(appVersion.getKey());
    }

    @Override
    public void setSessionStoreFactory(SessionStoreFactory factory) {
        this.appVersionHandlerMap.setSessionStoreFactory(factory);
    }

    @Override
    public void serviceRequest(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) throws ServletException, IOException {
        if (upRequest.getHandler().getType() != 1) {
            upResponse.setError(3);
            upResponse.setErrorMessage("Unsupported handler type: " + upRequest.getHandler().getType());
            return;
        }
        AppVersionKey appVersionKey = this.lastAppVersionKey;
        if (appVersionKey == null || !appVersionKey.getAppId().equals(upRequest.getAppId()) || !appVersionKey.getVersionId().equals(upRequest.getVersionId())) {
            appVersionKey = AppVersionKey.fromUpRequest(upRequest);
            if (this.appVersionHandlerMap.getHandler(appVersionKey) == null) {
                upResponse.setError(4);
                upResponse.setErrorMessage("Unknown app: " + appVersionKey);
                return;
            }
            this.lastAppVersionKey = appVersionKey;
        }
        this.rpcConnector.serviceRequest(appVersionKey, upRequest, upResponse);
    }

    static {
        System.setProperty("org.eclipse.jetty.util.log.class", JettyLogger.class.getName());
        System.setProperty("java.vendor.url", "");
        System.setProperty("java.vendor.url.bug", "");
    }
}

