/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.jetty9.RpcEndPoint;
import com.google.apphosting.runtime.jetty94.RpcConnector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class RpcConnection
implements Connection,
HttpTransport {
    private static final String X_GOOGLE_INTERNAL_SKIPADMINCHECK = "X-Google-Internal-SkipAdminCheck";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    static final String ASYNC_ENABLE_PPROPERTY = "com.google.appengine.enable_async";
    static final boolean NORMALIZE_INET_ADDR = Boolean.parseBoolean(System.getProperty("com.google.appengine.nomalize_inet_addr", Boolean.toString(!"java8".equals(System.getenv("GAE_RUNTIME")))));
    private final List<Connection.Listener> listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final RpcConnector connector;
    private final RpcEndPoint endPoint;
    private final MutableUpResponse upResponse;
    private ByteString aggregate = ByteString.EMPTY;

    public RpcConnection(RpcConnector connector, RpcEndPoint endPoint) {
        this.connector = connector;
        this.endPoint = endPoint;
        this.upResponse = endPoint.getUpResponse();
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onOpen() {
        for (Connection.Listener listener : this.listeners) {
            listener.onOpened(this);
        }
    }

    @Override
    public void onClose() {
        for (Connection.Listener listener : this.listeners) {
            listener.onClosed(this);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public void close() {
        this.endPoint.close();
    }

    @Override
    public long getMessagesIn() {
        return 1L;
    }

    @Override
    public long getMessagesOut() {
        return 1L;
    }

    @Override
    public long getBytesIn() {
        return 0L;
    }

    @Override
    public long getBytesOut() {
        return 0L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this.endPoint.getCreatedTimeStamp();
    }

    public void handle(AppVersionKey appVersionKey) throws ServletException, IOException {
        HttpPb.HttpRequest rpc = this.endPoint.getUpRequest().getRequest();
        byte[] postdata = rpc.getPostdata().toByteArray();
        final CountDownLatch blockEndRequest = new CountDownLatch(1);
        HttpChannel channel = new HttpChannel(this.connector, this.connector.getHttpConfiguration(), this.endPoint, this){

            @Override
            protected void handleException(Throwable th) {
                boolean requestWasCommitted = this.isCommitted();
                super.handleException(th);
                if (requestWasCommitted) {
                    this.getRequest().removeAttribute("javax.servlet.error.exception");
                }
                blockEndRequest.countDown();
            }

            @Override
            protected String formatAddrOrHost(String addr) {
                return NORMALIZE_INET_ADDR ? super.formatAddrOrHost(addr) : addr;
            }

            @Override
            public void onCompleted() {
                super.onCompleted();
                blockEndRequest.countDown();
            }
        };
        Request request = channel.getRequest();
        request.setAsyncSupported(Boolean.getBoolean(ASYNC_ENABLE_PPROPERTY), null);
        HttpMethod method = RpcConnector.LEGACY_MODE ? HttpMethod.INSENSITIVE_CACHE.get(rpc.getProtocol()) : HttpMethod.CACHE.get(rpc.getProtocol());
        String methodS = method != null ? method.asString() : rpc.getProtocol();
        try {
            String url = rpc.getUrl();
            HttpURI uri = new HttpURI(url);
            HttpVersion version = HttpVersion.CACHE.getBest(rpc.getHttpVersion());
            MetaData.Request requestData = new MetaData.Request(methodS, uri, version, new HttpFields(), postdata == null ? -1L : (long)postdata.length);
            boolean contentLength = false;
            block8: for (HttpPb.ParsedHttpHeader header : rpc.getHeadersList()) {
                HttpField field = RpcConnection.getField(header);
                if (RpcConnector.LEGACY_MODE && field.getHeader() != null) {
                    switch (field.getHeader()) {
                        case CONTENT_ENCODING: {
                            continue block8;
                        }
                        case CONTENT_LENGTH: {
                            if (contentLength) {
                                throw new BadMessageException("Duplicate Content-Length");
                            }
                            contentLength = true;
                            break;
                        }
                    }
                }
                requestData.getFields().add(field);
            }
            channel.onRequest(requestData);
            if (rpc.getIsHttps()) {
                request.setScheme(HttpScheme.HTTPS.asString());
                request.setSecure(true);
            }
            channel.onRequestComplete();
            if (postdata != null) {
                channel.getRequest().getHttpInput().addContent(new HttpInput.Content(BufferUtil.toBuffer(postdata)));
            }
        }
        catch (Exception t) {
            this.upResponse.setHttpResponseCodeAndResponse(400, "");
            channel.getResponse().setStatus(400);
            return;
        }
        request.setAttribute("com.google.apphosting.runtime.jetty9.APP_VERSION_REQUEST_ATTR", appVersionKey);
        boolean skipAdmin = RpcConnection.hasSkipAdminCheck(this.endPoint.getUpRequest());
        if (skipAdmin) {
            request.setAttribute(SKIP_ADMIN_CHECK_ATTR, true);
            request.setSecure(true);
        }
        Throwable exception = null;
        try {
            channel.handle();
            RpcConnection.waitforAsyncDone(blockEndRequest);
            exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (exception != null) {
            Throwable cause = RpcConnection.unwrap(exception);
            if (cause instanceof BadMessageException) {
                BadMessageException bme = (BadMessageException)cause;
                this.upResponse.clearHttpResponse();
                this.upResponse.setError(0);
                this.upResponse.setHttpResponseCode(bme.getCode());
                this.upResponse.setErrorMessage(bme.getReason());
            } else if (!RpcConnection.hasExceptionHandledByErrorPage(request)) {
                this.upResponse.clearHttpResponse();
                if (exception instanceof ServletException) {
                    throw (ServletException)exception;
                }
                throw new ServletException(exception);
            }
        }
    }

    private static Throwable unwrap(Throwable th) {
        while (th instanceof ServletException && th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    private static void waitforAsyncDone(CountDownLatch blockEndRequest) {
        if (Boolean.getBoolean(ASYNC_ENABLE_PPROPERTY)) {
            try {
                blockEndRequest.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean hasSkipAdminCheck(RuntimePb.UPRequest upRequest) {
        for (HttpPb.ParsedHttpHeader header : upRequest.getRuntimeHeadersList()) {
            if (!Ascii.equalsIgnoreCase(X_GOOGLE_INTERNAL_SKIPADMINCHECK, header.getKey())) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static HttpField getField(HttpPb.ParsedHttpHeader header) {
        return new HttpField(header.getKey(), header.getValue());
    }

    private static boolean hasExceptionHandledByErrorPage(Request servletRequest) {
        Object errorPage = servletRequest.getAttribute("org.eclipse.jetty.server.error_page");
        Object errorPageHandled = servletRequest.getAttribute("org.eclipse.jetty.server.error_page.handled");
        return errorPage != null && errorPage.equals(errorPageHandled);
    }

    @Override
    public void send(MetaData.Response info, boolean head, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info != null) {
            this.upResponse.setHttpResponseCode(info.getStatus());
            for (HttpField field : info.getFields()) {
                this.upResponse.addHttpOutputHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey(field.getName()).setValue(field.getValue()));
            }
        }
        if (BufferUtil.hasContent(content)) {
            this.aggregate = this.aggregate.concat(ByteString.copyFrom(content));
        }
        callback.succeeded();
    }

    @Override
    public void onCompleted() {
        this.upResponse.setHttpResponseResponse(this.aggregate);
        this.aggregate = ByteString.EMPTY;
    }

    @Override
    public void abort(Throwable thrwbl) {
        this.endPoint.close();
    }

    @Override
    public boolean isPushSupported() {
        return false;
    }

    @Override
    public void push(MetaData.Request rqst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    @Override
    public boolean onIdleExpired() {
        return false;
    }

    @Override
    public void removeListener(Connection.Listener ll) {
    }
}

