/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.jetty9.RpcEndPoint;
import com.google.apphosting.runtime.jetty94.RpcConnection;
import com.google.apphosting.runtime.jetty94.RpcConnectionFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.Server;

public class RpcConnector
extends AbstractConnector {
    private final HttpConfiguration httpConfiguration = new HttpConfiguration();
    static final boolean LEGACY_MODE = Boolean.getBoolean("com.google.apphosting.runtime.jetty94.LEGACY_MODE");

    public RpcConnector(Server server) {
        super(server, null, null, null, 0, new RpcConnectionFactory());
        this.addBean((Object)HttpCompliance.RFC7230);
        if (LEGACY_MODE) {
            this.httpConfiguration.setRequestCookieCompliance(CookieCompliance.RFC2965);
            this.httpConfiguration.setResponseCookieCompliance(CookieCompliance.RFC2965);
            this.httpConfiguration.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.LEGACY);
        }
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    @Override
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public void serviceRequest(AppVersionKey appVersionKey, RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) throws ServletException, IOException {
        RpcEndPoint endPoint = new RpcEndPoint(upRequest, upResponse);
        RpcConnection connection = (RpcConnection)this.getDefaultConnectionFactory().newConnection(this, endPoint);
        endPoint.setConnection(connection);
        connection.handle(appVersionKey);
    }
}

