/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.runtime.jetty94.AppEngineNullSessionDataStore;
import com.google.apphosting.runtime.jetty94.AppEngineSession;
import com.google.apphosting.runtime.jetty94.AutoValue_SessionManagerHandler_Config;
import com.google.apphosting.runtime.jetty94.DatastoreSessionStore;
import com.google.apphosting.runtime.jetty94.MemcacheSessionDataMap;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.CachingSessionDataStore;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.HouseKeeper;
import org.eclipse.jetty.server.session.NullSessionCache;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class SessionManagerHandler {
    private final AppEngineSessionIdManager idManager;
    private final NullSessionCache cache;
    private final MemcacheSessionDataMap memcacheMap;

    private SessionManagerHandler(AppEngineSessionIdManager idManager, NullSessionCache cache, MemcacheSessionDataMap memcacheMap) {
        this.idManager = idManager;
        this.cache = cache;
        this.memcacheMap = memcacheMap;
    }

    public static SessionManagerHandler create(Config config) {
        ServletContextHandler context = config.servletContextHandler();
        Server server = context.getServer();
        AppEngineSessionIdManager idManager = new AppEngineSessionIdManager(server);
        server.setSessionIdManager(idManager);
        HouseKeeper houseKeeper = new HouseKeeper();
        try {
            houseKeeper.setIntervalSec(0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        idManager.setSessionHouseKeeper(houseKeeper);
        if (config.enableSession()) {
            AppEngineSessionCache cache = new AppEngineSessionCache(context.getSessionHandler());
            DatastoreSessionStore dataStore = new DatastoreSessionStore(config.asyncPersistence(), config.asyncPersistenceQueueName());
            MemcacheSessionDataMap memcacheMap = new MemcacheSessionDataMap();
            CachingSessionDataStore cachingDataStore = new CachingSessionDataStore(memcacheMap, dataStore.getSessionDataStoreImpl());
            cache.setSessionDataStore(cachingDataStore);
            context.getSessionHandler().setSessionCache(cache);
            return new SessionManagerHandler(idManager, cache, memcacheMap);
        }
        AppEngineNullSessionCache cache = new AppEngineNullSessionCache(context.getSessionHandler());
        AppEngineNullSessionDataStore nullStore = new AppEngineNullSessionDataStore();
        cache.setSessionDataStore(nullStore);
        context.getSessionHandler().setSessionCache(cache);
        return new SessionManagerHandler(null, cache, null);
    }

    @VisibleForTesting
    AppEngineSessionIdManager getIdManager() {
        return this.idManager;
    }

    @VisibleForTesting
    NullSessionCache getCache() {
        return this.cache;
    }

    @VisibleForTesting
    MemcacheSessionDataMap getMemcacheMap() {
        return this.memcacheMap;
    }

    static class AppEngineSessionIdManager
    extends DefaultSessionIdManager {
        private static final AtomicReference<String> lastId = new AtomicReference<Object>(null);

        @VisibleForTesting
        static String lastId() {
            return lastId.get();
        }

        AppEngineSessionIdManager(Server server) {
            super(server, new SecureRandom());
        }

        @Override
        public synchronized String newSessionId(long seedTerm) {
            byte[] randomBytes = new byte[16];
            this._random.nextBytes(randomBytes);
            String id = BaseEncoding.base64Url().omitPadding().encode(randomBytes);
            lastId.set(id);
            return id;
        }
    }

    private static class AppEngineSessionCache
    extends NullSessionCache {
        AppEngineSessionCache(SessionHandler handler) {
            super(handler);
            this.setSaveOnCreate(true);
        }

        @Override
        public Session newSession(SessionData data) {
            return new AppEngineSession(this.getSessionHandler(), data);
        }

        @Override
        public Session newSession(HttpServletRequest request, SessionData data) {
            return new AppEngineSession(this.getSessionHandler(), request, data);
        }
    }

    @VisibleForTesting
    static class NullSession
    extends Session {
        private NullSession(SessionHandler handler, SessionData data) {
            super(handler, data);
        }

        private NullSession(SessionHandler handler, HttpServletRequest request, SessionData data) {
            super(handler, request, data);
        }

        @Override
        public long getCreationTime() {
            return 0L;
        }

        @Override
        public boolean isNew() {
            return false;
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public void setAttribute(String name, Object value) {
            if ("org.eclipse.jetty.security.sessionCreatedSecure".equals(name)) {
                return;
            }
            NullSession.throwException(name, value);
        }

        private static void throwException(String name, Object value) {
            throw new RuntimeException("Session support is not enabled in appengine-web.xml.  To enable sessions, put <sessions-enabled>true</sessions-enabled> in that file.  Without it, getSession() is allowed, but manipulation of session attributes is not. Could not set \"" + name + "\" to " + value);
        }

        @Override
        public long getLastAccessedTime() {
            return 0L;
        }

        @Override
        public int getMaxInactiveInterval() {
            return 0;
        }
    }

    private static class AppEngineNullSessionCache
    extends NullSessionCache {
        AppEngineNullSessionCache(SessionHandler handler) {
            super(handler);
            this.setSaveOnCreate(false);
            this.setRemoveUnloadableSessions(false);
        }

        @Override
        public Session newSession(SessionData data) {
            return new NullSession(this.getSessionHandler(), data);
        }

        @Override
        public Session newSession(HttpServletRequest request, SessionData data) {
            return new NullSession(this.getSessionHandler(), request, data);
        }
    }

    @AutoValue
    public static abstract class Config {
        public abstract boolean enableSession();

        public abstract boolean asyncPersistence();

        public abstract Optional<String> asyncPersistenceQueueName();

        public abstract ServletContextHandler servletContextHandler();

        public static Builder builder() {
            return new AutoValue_SessionManagerHandler_Config.Builder().setEnableSession(false).setAsyncPersistence(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setServletContextHandler(ServletContextHandler var1);

            public abstract Builder setEnableSession(boolean var1);

            public abstract Builder setAsyncPersistence(boolean var1);

            public abstract Builder setAsyncPersistenceQueueName(String var1);

            public abstract Config build();
        }
    }
}

