/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.AbstractIntervalTimer;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.runtime.timer.TimerSet;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSharedTimerSet
implements TimerSet {
    private final Set<SharedTimer> startedTimers = new HashSet<SharedTimer>();

    @Override
    public Timer createTimer() {
        return new SharedTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Set<SharedTimer> set = this.startedTimers;
        synchronized (set) {
            return this.startedTimers.size();
        }
    }

    protected abstract long getCurrentShared();

    protected abstract String getTitle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStartedTimers(long current) {
        Set<SharedTimer> set = this.startedTimers;
        synchronized (set) {
            for (SharedTimer timer : this.startedTimers) {
                timer.update(current);
            }
        }
    }

    private class SharedTimer
    extends AbstractIntervalTimer {
        private SharedTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Set set = AbstractSharedTimerSet.this.startedTimers;
            synchronized (set) {
                SharedTimer sharedTimer = this;
                synchronized (sharedTimer) {
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    long current = this.getCurrent();
                    AbstractSharedTimerSet.this.updateStartedTimers(current);
                    AbstractSharedTimerSet.this.startedTimers.add(this);
                    this.startTime = current;
                    this.running = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Set set = AbstractSharedTimerSet.this.startedTimers;
            synchronized (set) {
                SharedTimer sharedTimer = this;
                synchronized (sharedTimer) {
                    if (!this.running) {
                        throw new IllegalStateException("not running");
                    }
                    AbstractSharedTimerSet.this.updateStartedTimers(this.getCurrent());
                    AbstractSharedTimerSet.this.startedTimers.remove(this);
                    this.running = false;
                }
            }
        }

        @Override
        protected long getCurrent() {
            return AbstractSharedTimerSet.this.getCurrentShared();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected double getRatio() {
            Set set = AbstractSharedTimerSet.this.startedTimers;
            synchronized (set) {
                return 1.0 / (double)AbstractSharedTimerSet.this.startedTimers.size();
            }
        }

        public String toString() {
            return String.format("%.3f %s", (double)this.getNanoseconds() / 1.0E9, AbstractSharedTimerSet.this.getTitle());
        }
    }
}

