/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.CpuSpeedExtractor;
import com.google.common.flogger.GoogleLogger;

public class CpuSpeedExtractorFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final long DEFAULT_CPU_SPEED = 2000000000L;
    private final CpuSpeedExtractor extractor;

    public CpuSpeedExtractorFactory(long cyclesPerSecond) {
        if (cyclesPerSecond > 0L) {
            this.extractor = new StaticCpuSpeedExtractor(cyclesPerSecond);
        } else {
            ((GoogleLogger.Api)logger.atWarning()).log("Flag --cycles_per_second not set, assuming a default CPU speed of %d", 2000000000L);
            this.extractor = new StaticCpuSpeedExtractor(2000000000L);
        }
    }

    public CpuSpeedExtractor getExtractor() {
        return this.extractor;
    }

    private static class StaticCpuSpeedExtractor
    implements CpuSpeedExtractor {
        private final long cpuSpeed;

        public StaticCpuSpeedExtractor(long cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
        }

        @Override
        public long getCyclesPerSecond() {
            return this.cpuSpeed;
        }
    }
}

