/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class QueueXmlReader
extends AbstractConfigXmlReader<QueueXml> {
    private static final String FILENAME = "WEB-INF/queue.xml";
    private static final String TOTAL_STORAGE_LIMIT_TAG = "total-storage-limit";
    private static final String QUEUEENTRIES_TAG = "queue-entries";
    private static final String QUEUE_TAG = "queue";
    private static final String NAME_TAG = "name";
    private static final String RATE_TAG = "rate";
    private static final String BUCKET_SIZE = "bucket-size";
    private static final String MAX_CONCURRENT_REQUESTS = "max-concurrent-requests";
    private static final String MODE_TAG = "mode";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String TASK_RETRY_LIMIT_TAG = "task-retry-limit";
    private static final String TASK_AGE_LIMIT_TAG = "task-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";
    private static final String TARGET_TAG = "target";
    private static final String ACL_TAG = "acl";
    private static final String USER_EMAIL_TAG = "user-email";
    private static final String WRITER_EMAIL_TAG = "writer-email";

    public QueueXmlReader(String appDir) {
        super(appDir, false);
    }

    public QueueXml readQueueXml() {
        return (QueueXml)this.readConfigXml();
    }

    @Override
    protected QueueXml processXml(InputStream is) {
        QueueXml queueXml = new QueueXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        if (!root.getTagName().equals(QUEUEENTRIES_TAG)) {
            throw new AppEngineConfigException(this.getFilename() + " does not contain <" + QUEUEENTRIES_TAG + ">");
        }
        boolean sawTotalStorageLimit = false;
        block8: for (Element child : XmlUtils.getChildren(root)) {
            switch (child.getTagName()) {
                case "queue": {
                    this.parseQueue(child, queueXml.addNewEntry());
                    continue block8;
                }
                case "total-storage-limit": {
                    if (sawTotalStorageLimit) {
                        throw new AppEngineConfigException(this.getFilename() + " contains multiple <" + TOTAL_STORAGE_LIMIT_TAG + ">");
                    }
                    sawTotalStorageLimit = true;
                    queueXml.setTotalStorageLimit(this.stringContents(child));
                    continue block8;
                }
            }
            throw new AppEngineConfigException(this.getFilename() + " contains <" + child.getTagName() + "> instead of <" + QUEUE_TAG + "/> or <" + TOTAL_STORAGE_LIMIT_TAG + "/>");
        }
        return queueXml;
    }

    private void parseQueue(Element queueElement, QueueXml.Entry entry) {
        block20: for (Element child : XmlUtils.getChildren(queueElement)) {
            switch (child.getTagName()) {
                case "name": {
                    entry.setName(this.stringContents(child));
                    continue block20;
                }
                case "bucket-size": {
                    entry.setBucketSize(this.stringContents(child));
                    continue block20;
                }
                case "rate": {
                    entry.setRate(this.stringContents(child));
                    continue block20;
                }
                case "max-concurrent-requests": {
                    entry.setMaxConcurrentRequests(this.stringContents(child));
                    continue block20;
                }
                case "mode": {
                    entry.setMode(this.stringContents(child));
                    continue block20;
                }
                case "target": {
                    entry.setTarget(this.stringContents(child));
                    continue block20;
                }
                case "retry-parameters": {
                    entry.setRetryParameters(this.parseRetryParameters(child));
                    continue block20;
                }
                case "acl": {
                    entry.setAcl(this.parseAcl(child));
                    continue block20;
                }
            }
            throw new AppEngineConfigException(this.getFilename() + " contains unknown <" + child.getTagName() + "> inside <" + QUEUE_TAG + "/>");
        }
    }

    private QueueXml.RetryParameters parseRetryParameters(Element retryElement) {
        QueueXml.RetryParameters retryParameters = new QueueXml.RetryParameters();
        block14: for (Element child : XmlUtils.getChildren(retryElement)) {
            switch (child.getTagName()) {
                case "task-retry-limit": {
                    retryParameters.setRetryLimit(this.stringContents(child));
                    continue block14;
                }
                case "task-age-limit": {
                    retryParameters.setAgeLimitSec(this.stringContents(child));
                    continue block14;
                }
                case "min-backoff-seconds": {
                    retryParameters.setMinBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-backoff-seconds": {
                    retryParameters.setMaxBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-doublings": {
                    retryParameters.setMaxDoublings(this.stringContents(child));
                    continue block14;
                }
            }
            throw new AppEngineConfigException(this.getFilename() + " contains unknown <" + child.getTagName() + "> inside <" + RETRY_PARAMETERS_TAG + "/>");
        }
        return retryParameters;
    }

    private List<QueueXml.AclEntry> parseAcl(Element aclElement) {
        ArrayList<QueueXml.AclEntry> acls = new ArrayList<QueueXml.AclEntry>();
        for (Element child : XmlUtils.getChildren(aclElement)) {
            QueueXml.AclEntry acl = new QueueXml.AclEntry();
            switch (child.getTagName()) {
                case "user-email": {
                    acl.setUserEmail(this.stringContents(child));
                    break;
                }
                case "writer-email": {
                    acl.setWriterEmail(this.stringContents(child));
                    break;
                }
                default: {
                    throw new AppEngineConfigException(this.getFilename() + " contains unknown <" + child.getTagName() + "> inside <" + ACL_TAG + "/>");
                }
            }
            acls.add(acl);
        }
        return acls;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

