/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.remoteapi;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteApiServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(RemoteApiServlet.class.getName());
    private static final String[] OAUTH_SCOPES = new String[]{"https://www.googleapis.com/auth/appengine.apis", "https://www.googleapis.com/auth/cloud-platform"};
    private static final String INBOUND_APP_SYSTEM_PROPERTY = "HTTP_X_APPENGINE_INBOUND_APPID";
    private static final String INBOUND_APP_HEADER_NAME = "X-AppEngine-Inbound-AppId";
    private HashSet<String> allowedApps = null;
    private final OAuthService oauthService;

    public RemoteApiServlet() {
        this(OAuthServiceFactory.getOAuthService());
    }

    RemoteApiServlet(OAuthService oauthService) {
        this.oauthService = oauthService;
    }

    boolean checkIsValidRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsKnownInbound(req) && !this.checkIsAdmin(req, res)) {
            return false;
        }
        return this.checkIsValidHeader(req, res);
    }

    private synchronized boolean checkIsKnownInbound(HttpServletRequest req) throws IOException {
        String inboundAppId;
        if (this.allowedApps == null) {
            this.allowedApps = new HashSet();
            String allowedAppsStr = System.getProperty(INBOUND_APP_SYSTEM_PROPERTY);
            if (allowedAppsStr != null) {
                String[] apps;
                for (String app : apps = allowedAppsStr.split(",")) {
                    this.allowedApps.add(app);
                }
            }
        }
        return (inboundAppId = req.getHeader(INBOUND_APP_HEADER_NAME)) != null && this.allowedApps.contains(inboundAppId);
    }

    private boolean checkIsValidHeader(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("X-appcfg-api-version") == null) {
            res.setStatus(403);
            res.setContentType("text/plain");
            res.getWriter().println("This request did not contain a necessary header");
            return false;
        }
        return true;
    }

    private boolean checkIsAdmin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserService userService = UserServiceFactory.getUserService();
        if (userService.getCurrentUser() != null) {
            if (userService.isUserAdmin()) {
                return true;
            }
            this.respondNotAdmin(res);
            return false;
        }
        try {
            if (this.oauthService.isUserAdmin(OAUTH_SCOPES)) {
                return true;
            }
            this.respondNotAdmin(res);
            return false;
        }
        catch (OAuthRequestException oAuthRequestException) {
            res.sendRedirect(userService.createLoginURL(req.getRequestURI()));
            return false;
        }
    }

    private void respondNotAdmin(HttpServletResponse res) throws IOException {
        res.setStatus(401);
        res.setContentType("text/plain");
        res.getWriter().println("You must be logged in as an administrator, or access from an approved application.");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsValidRequest(req, res)) {
            return;
        }
        res.setContentType("text/plain");
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        StringBuilder outYaml = new StringBuilder().append("{rtok: ").append(req.getParameter("rtok")).append(", app_id: ").append(appId).append("}");
        res.getWriter().println(outYaml);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RemoteApiPb.Response response;
        block3: {
            if (!this.checkIsValidRequest(req, res)) {
                return;
            }
            res.setContentType("application/octet-stream");
            response = new RemoteApiPb.Response();
            try {
                byte[] responseData = this.executeRequest(req);
                response.setResponseAsBytes(responseData);
                res.setStatus(200);
            }
            catch (Exception e) {
                log.warning("Caught exception while executing remote_api command:\n" + e);
                res.setStatus(200);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(e);
                out.close();
                byte[] serializedException = byteStream.toByteArray();
                response.setJavaExceptionAsBytes(serializedException);
                if (!(e instanceof ApiProxy.ApplicationException)) break block3;
                ApiProxy.ApplicationException ae = (ApiProxy.ApplicationException)((Object)e);
                RemoteApiPb.ApplicationError appError = response.getMutableApplicationError();
                appError.setCode(ae.getApplicationError());
                appError.setDetail(ae.getErrorDetail());
            }
        }
        res.getOutputStream().write(response.toByteArray());
    }

    private byte[] executeRunQuery(RemoteApiPb.Request request) {
        DatastoreV3Pb.Query queryRequest = new DatastoreV3Pb.Query();
        RemoteApiServlet.parseFromBytes(queryRequest, request.getRequestAsBytes());
        int batchSize = Math.max(1000, queryRequest.getLimit());
        queryRequest.setCount(batchSize);
        DatastoreV3Pb.QueryResult runQueryResponse = new DatastoreV3Pb.QueryResult();
        byte[] res = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"RunQuery", (byte[])request.getRequestAsBytes());
        RemoteApiServlet.parseFromBytes(runQueryResponse, res);
        if (queryRequest.hasLimit()) {
            while (runQueryResponse.isMoreResults()) {
                DatastoreV3Pb.NextRequest nextRequest = new DatastoreV3Pb.NextRequest();
                nextRequest.getMutableCursor().mergeFrom(runQueryResponse.getCursor());
                nextRequest.setCount(batchSize);
                byte[] nextRes = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Next", (byte[])nextRequest.toByteArray());
                RemoteApiServlet.parseFromBytes(runQueryResponse, nextRes);
            }
        }
        return runQueryResponse.toByteArray();
    }

    private byte[] executeTxQuery(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionQueryResult result = new RemoteApiPb.TransactionQueryResult();
        DatastoreV3Pb.Query query = new DatastoreV3Pb.Query();
        RemoteApiServlet.parseFromBytes(query, request.getRequestAsBytes());
        if (!query.hasAncestor()) {
            throw new ApiProxy.ApplicationException(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST.getValue(), "No ancestor in transactional query.");
        }
        OnestoreEntity.Reference egKey = result.getMutableEntityGroupKey().mergeFrom(query.getAncestor());
        OnestoreEntity.Path.Element root = egKey.getPath().getElement(0);
        egKey.getMutablePath().clearElement().addElement(root);
        OnestoreEntity.Path.Element egElement = new OnestoreEntity.Path.Element();
        egElement.setType("__entity_group__").setId(1L);
        egKey.getMutablePath().addElement(egElement);
        byte[] tx = RemoteApiServlet.beginTransaction(false);
        RemoteApiServlet.parseFromBytes(query.getMutableTransaction(), tx);
        byte[] queryBytes = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"RunQuery", (byte[])query.toByteArray());
        RemoteApiServlet.parseFromBytes(result.getMutableResult(), queryBytes);
        DatastoreV3Pb.GetRequest egRequest = new DatastoreV3Pb.GetRequest();
        egRequest.addKey(egKey);
        DatastoreV3Pb.GetResponse egResponse = RemoteApiServlet.txGet(tx, egRequest);
        if (egResponse.getEntity(0).hasEntity()) {
            result.setEntityGroup(egResponse.getEntity(0).getEntity());
        }
        RemoteApiServlet.rollback(tx);
        return result.toByteArray();
    }

    private void assertEntityResultMatchesPrecondition(DatastoreV3Pb.GetResponse.Entity entityResult, RemoteApiPb.TransactionRequest.Precondition precondition) {
        if (precondition.hasHash() != entityResult.hasEntity()) {
            throw new ApiProxy.ApplicationException(DatastoreV3Pb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
        }
        if (entityResult.hasEntity()) {
            OnestoreEntity.EntityProto entity = entityResult.getEntity();
            if (Arrays.equals(precondition.getHashAsBytes(), RemoteApiServlet.computeSha1(entity))) {
                return;
            }
            byte[] backwardsCompatibleHash = RemoteApiServlet.computeSha1OmittingLastByteForBackwardsCompatibility(entity);
            if (!Arrays.equals(precondition.getHashAsBytes(), backwardsCompatibleHash)) {
                throw new ApiProxy.ApplicationException(DatastoreV3Pb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
            }
        }
    }

    private byte[] executeTx(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionRequest txRequest = new RemoteApiPb.TransactionRequest();
        RemoteApiServlet.parseFromBytes(txRequest, request.getRequestAsBytes());
        byte[] tx = RemoteApiServlet.beginTransaction(txRequest.isAllowMultipleEg());
        List<RemoteApiPb.TransactionRequest.Precondition> preconditions = txRequest.preconditions();
        if (!preconditions.isEmpty()) {
            DatastoreV3Pb.GetRequest getRequest = new DatastoreV3Pb.GetRequest();
            for (RemoteApiPb.TransactionRequest.Precondition precondition : preconditions) {
                OnestoreEntity.Reference key = precondition.getKey();
                OnestoreEntity.Reference requestKey = getRequest.addKey();
                requestKey.mergeFrom(key);
            }
            DatastoreV3Pb.GetResponse getResponse = RemoteApiServlet.txGet(tx, getRequest);
            List<DatastoreV3Pb.GetResponse.Entity> entities = getResponse.entitys();
            assert (entities.size() == preconditions.size());
            for (int i = 0; i < entities.size(); ++i) {
                this.assertEntityResultMatchesPrecondition(entities.get(i), preconditions.get(i));
            }
        }
        byte[] res = new byte[]{};
        if (txRequest.hasPuts()) {
            DatastoreV3Pb.PutRequest putRequest = txRequest.getPuts();
            RemoteApiServlet.parseFromBytes(putRequest.getMutableTransaction(), tx);
            res = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Put", (byte[])putRequest.toByteArray());
        }
        if (txRequest.hasDeletes()) {
            DatastoreV3Pb.DeleteRequest deleteRequest = txRequest.getDeletes();
            RemoteApiServlet.parseFromBytes(deleteRequest.getMutableTransaction(), tx);
            ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Delete", (byte[])deleteRequest.toByteArray());
        }
        ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Commit", (byte[])tx);
        return res;
    }

    private byte[] executeGetIDs(RemoteApiPb.Request request, boolean isXG) {
        DatastoreV3Pb.PutRequest putRequest = new DatastoreV3Pb.PutRequest();
        RemoteApiServlet.parseFromBytes(putRequest, request.getRequestAsBytes());
        for (OnestoreEntity.EntityProto entity : putRequest.entitys()) {
            assert (entity.propertySize() == 0);
            assert (entity.rawPropertySize() == 0);
            assert (entity.getEntityGroup().elementSize() == 0);
            List<OnestoreEntity.Path.Element> elementList = entity.getKey().getPath().elements();
            OnestoreEntity.Path.Element lastPart = elementList.get(elementList.size() - 1);
            assert (lastPart.getId() == 0L);
            assert (!lastPart.hasName());
        }
        byte[] tx = RemoteApiServlet.beginTransaction(isXG);
        RemoteApiServlet.parseFromBytes(putRequest.getMutableTransaction(), tx);
        byte[] res = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Put", (byte[])putRequest.toByteArray());
        RemoteApiServlet.rollback(tx);
        return res;
    }

    private byte[] executeRequest(HttpServletRequest req) throws IOException {
        RemoteApiPb.Request request = new RemoteApiPb.Request();
        RemoteApiServlet.parseFromInputStream(request, (InputStream)req.getInputStream());
        String service = request.getServiceName();
        String method = request.getMethod();
        log.fine("remote API call: " + service + ", " + method);
        if (service.equals("remote_datastore")) {
            if (method.equals("RunQuery")) {
                return this.executeRunQuery(request);
            }
            if (method.equals("Transaction")) {
                return this.executeTx(request);
            }
            if (method.equals("TransactionQuery")) {
                return this.executeTxQuery(request);
            }
            if (method.equals("GetIDs")) {
                return this.executeGetIDs(request, false);
            }
            if (method.equals("GetIDsXG")) {
                return this.executeGetIDs(request, true);
            }
            throw new ApiProxy.CallNotFoundException(service, method);
        }
        return ApiProxy.makeSyncCall((String)service, (String)method, (byte[])request.getRequestAsBytes());
    }

    private static byte[] beginTransaction(boolean allowMultipleEg) {
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        byte[] req = new DatastoreV3Pb.BeginTransactionRequest().setApp(appId).setAllowMultipleEg(allowMultipleEg).toByteArray();
        return ApiProxy.makeSyncCall((String)"datastore_v3", (String)"BeginTransaction", (byte[])req);
    }

    private static void rollback(byte[] tx) {
        ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Rollback", (byte[])tx);
    }

    private static DatastoreV3Pb.GetResponse txGet(byte[] tx, DatastoreV3Pb.GetRequest request) {
        RemoteApiServlet.parseFromBytes(request.getMutableTransaction(), tx);
        DatastoreV3Pb.GetResponse response = new DatastoreV3Pb.GetResponse();
        byte[] resultBytes = ApiProxy.makeSyncCall((String)"datastore_v3", (String)"Get", (byte[])request.toByteArray());
        RemoteApiServlet.parseFromBytes(response, resultBytes);
        return response;
    }

    static byte[] computeSha1(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length);
    }

    static byte[] computeSha1OmittingLastByteForBackwardsCompatibility(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length - 1);
    }

    private static byte[] computeSha1(byte[] bytes, int length) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApiProxy.ApplicationException(DatastoreV3Pb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition could not be computed");
        }
        md.update(bytes, 0, length);
        return md.digest();
    }

    private static void parseFromBytes(ProtocolMessage<?> message, byte[] bytes) {
        boolean parsed = message.parseFrom(bytes);
        RemoteApiServlet.checkParse(message, parsed);
    }

    private static void parseFromInputStream(ProtocolMessage<?> message, InputStream inputStream) {
        boolean parsed = message.parseFrom(inputStream);
        RemoteApiServlet.checkParse(message, parsed);
    }

    private static void checkParse(ProtocolMessage<?> message, boolean parsed) {
        if (!parsed) {
            throw new ApiProxy.ApiProxyException("Could not parse protobuf");
        }
        String error = message.findInitializationError();
        if (error != null) {
            throw new ApiProxy.ApiProxyException("Could not parse protobuf: " + error);
        }
    }

    public static class UnknownPythonServerException
    extends RuntimeException {
        public UnknownPythonServerException(String message) {
            super(message);
        }
    }
}

