/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flags.ext;

import com.google.common.base.Preconditions;
import com.google.common.flags.Flag;
import com.google.common.flags.InvalidFlagValueException;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import javax.annotation.Nullable;

public final class Re2PatternFlag
extends Flag<Pattern> {
    private final int compileFlag;

    private Re2PatternFlag(@Nullable Pattern defaultValue) {
        super(defaultValue);
        this.compileFlag = defaultValue != null ? defaultValue.flags() : 0;
    }

    public static Re2PatternFlag of(String regex) {
        return Re2PatternFlag.of(Pattern.compile((String)regex));
    }

    public static Re2PatternFlag of(Pattern pattern) {
        return new Re2PatternFlag(Preconditions.checkNotNull(pattern));
    }

    public static Re2PatternFlag of(String regex, int compileFlag) {
        Preconditions.checkNotNull(regex);
        Preconditions.checkArgument(compileFlag >= 0);
        return new Re2PatternFlag(Pattern.compile((String)regex, (int)compileFlag));
    }

    public static Re2PatternFlag nullValue() {
        return new Re2PatternFlag(null);
    }

    @Override
    protected Pattern parse(String regex) throws InvalidFlagValueException {
        try {
            return Pattern.compile((String)Preconditions.checkNotNull(regex), (int)this.compileFlag);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidFlagValueException("Invalid pattern", e);
        }
    }

    @Override
    protected String parsableStringValue(Pattern value) {
        return value.pattern();
    }
}

