/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;

public class DatastoreOptions {
    private final String projectId;
    private final String projectEndpoint;
    private final String host;
    private final String localHost;
    private final HttpRequestInitializer initializer;
    private final Credential credential;
    private final HttpTransport transport;
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/datastore");

    DatastoreOptions(Builder b) {
        Preconditions.checkArgument(b.projectId != null || b.projectEndpoint != null, "Either project ID or project endpoint must be provided.");
        this.projectId = b.projectId;
        this.projectEndpoint = b.projectEndpoint;
        this.host = b.host;
        this.localHost = b.localHost;
        this.initializer = b.initializer;
        this.credential = b.credential;
        this.transport = b.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectEndpoint() {
        return this.projectEndpoint;
    }

    public String getHost() {
        return this.host;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public HttpRequestInitializer getInitializer() {
        return this.initializer;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public static class Builder {
        private static final String PROJECT_ENDPOINT_AND_PROJECT_ID_ERROR = "Cannot set both project endpoint and project ID.";
        private static final String PROJECT_ENDPOINT_AND_HOST_ERROR = "Can set at most one of project endpoint, host, and local host.";
        private String projectId;
        private String projectEndpoint;
        private String host;
        private String localHost;
        private HttpRequestInitializer initializer;
        private Credential credential;
        private HttpTransport transport;

        public Builder() {
        }

        public Builder(DatastoreOptions options) {
            this.projectId = options.projectId;
            this.projectEndpoint = options.projectEndpoint;
            this.host = options.host;
            this.localHost = options.localHost;
            this.initializer = options.initializer;
            this.credential = options.credential;
            this.transport = options.transport;
        }

        public DatastoreOptions build() {
            return new DatastoreOptions(this);
        }

        public Builder projectId(String projectId) {
            Preconditions.checkArgument(this.projectEndpoint == null, PROJECT_ENDPOINT_AND_PROJECT_ID_ERROR);
            this.projectId = projectId;
            return this;
        }

        public Builder host(String host) {
            Preconditions.checkArgument(this.projectEndpoint == null && this.localHost == null, PROJECT_ENDPOINT_AND_HOST_ERROR);
            if (Builder.includesScheme(host)) {
                throw new IllegalArgumentException(String.format("Host \"%s\" must not include scheme.", host));
            }
            this.host = host;
            return this;
        }

        public Builder localHost(String localHost) {
            Preconditions.checkArgument(this.projectEndpoint == null && this.host == null, PROJECT_ENDPOINT_AND_HOST_ERROR);
            if (Builder.includesScheme(localHost)) {
                throw new IllegalArgumentException(String.format("Local host \"%s\" must not include scheme.", localHost));
            }
            this.localHost = localHost;
            return this;
        }

        @Deprecated
        public Builder projectEndpoint(String projectEndpoint) {
            Preconditions.checkArgument(this.projectId == null, PROJECT_ENDPOINT_AND_PROJECT_ID_ERROR);
            Preconditions.checkArgument(this.localHost == null && this.host == null, PROJECT_ENDPOINT_AND_HOST_ERROR);
            if (!Builder.includesScheme(projectEndpoint)) {
                throw new IllegalArgumentException(String.format("Project endpoint \"%s\" must include scheme.", projectEndpoint));
            }
            this.projectEndpoint = projectEndpoint;
            return this;
        }

        public Builder initializer(HttpRequestInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public Builder transport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }

        private static boolean includesScheme(String url) {
            return url.startsWith("http://") || url.startsWith("https://");
        }
    }
}

