/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiDeadlineOracleTest {
    private ApiDeadlineOracle oracle;

    @Before
    public void setUp() throws Exception {
        this.oracle = new ApiDeadlineOracle.Builder().initDeadlineMap(5.0, "high:60", 10.0, "high:120").initOfflineDeadlineMap(15.0, "high:600", 20.0, "high:1200").build();
    }

    @Test
    public void testDeadline_Default() {
        Truth.assertThat((Double)this.oracle.getDeadline("foo", false, null)).isEqualTo((Object)5.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", true, null)).isEqualTo((Object)15.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", false, (Number)50)).isEqualTo((Object)10.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", true, (Number)50)).isEqualTo((Object)20.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", false, (Number)1)).isEqualTo((Object)1.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", true, (Number)1)).isEqualTo((Object)1.0);
    }

    @Test
    public void testDeadline_InitialPackageOverride() {
        Truth.assertThat((Double)this.oracle.getDeadline("high", false, null)).isEqualTo((Object)60.0);
        Truth.assertThat((Double)this.oracle.getDeadline("high", true, null)).isEqualTo((Object)600.0);
        Truth.assertThat((Double)this.oracle.getDeadline("high", false, (Number)3600)).isEqualTo((Object)120.0);
        Truth.assertThat((Double)this.oracle.getDeadline("high", true, (Number)3600)).isEqualTo((Object)1200.0);
    }

    @Test
    public void testDeadline_LaterPackageOverride() {
        this.oracle.addPackageDefaultDeadline("foo", 30.0);
        this.oracle.addPackageMaxDeadline("foo", 300.0);
        this.oracle.addOfflinePackageDefaultDeadline("foo", 60.0);
        this.oracle.addOfflinePackageMaxDeadline("foo", 600.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", false, null)).isEqualTo((Object)30.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", true, null)).isEqualTo((Object)60.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", false, (Number)3600)).isEqualTo((Object)300.0);
        Truth.assertThat((Double)this.oracle.getDeadline("foo", true, (Number)3600)).isEqualTo((Object)600.0);
    }
}

