/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.ThreadManager;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.ApiStats;
import com.google.apphosting.api.CloudTrace;
import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SpanKindOuterClass;
import com.google.apphosting.base.protos.Status;
import com.google.apphosting.base.protos.TraceEvents;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.base.protos.api.ApiBasePb;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestState;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.timer.CpuRatioTimer;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.utils.runtime.ApiProxyUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ApiProxyImplTest {
    private static final double DEFAULT_API_DEADLINE = 5.0;
    private static final double DEFAULT_OFFLINE_API_DEADLINE = 7.0;
    private static final double MAX_API_DEADLINE = 10.0;
    private static final String APP_ID = "app123";
    private static final String ENGINE_ID = "non-default";
    private static final String ENGINE_VERSION_ID = "v456";
    private static final String VERSION_ID = "non-default:v456.123";
    private static final String REQUEST_ID = "test-request-id";
    private static final long DEFAULT_API_MCYCLES_PER_REQUEST = 1L;
    private static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    private static final long BYTE_COUNT_BEFORE_FLUSHING = 102400L;
    private static final int MAX_LOG_LINE_SIZE = 16384;
    private Semaphore sleepSemaphore;
    private AppVersion appVersion;
    private ApiProxyImpl delegate;
    private ApiProxyImpl.EnvironmentImpl environment;
    private RuntimePb.UPRequest upRequest;
    private MutableUpResponse upResponse;
    private long cpuCycles;
    private CpuRatioTimer mockTimer;
    private long elapsedWallclockNanoseconds;
    private ApiDeadlineOracle oracle;
    private final SessionsConfig sessionsConfig = new SessionsConfig(false, false, null);
    private final List<Future<?>> futures = Collections.synchronizedList(new ArrayList());
    private int maxConcurrentApiCalls;
    private File rootDirectory;
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        this.rootDirectory = temporaryFolder.newFolder("appengine" + System.nanoTime());
        this.maxConcurrentApiCalls = 10;
        this.oracle = new ApiDeadlineOracle.Builder().initDeadlineMap(5.0, "", 10.0, "").initOfflineDeadlineMap(7.0, "", 10.0, "").build();
        this.sleepSemaphore = new Semaphore(0);
        APIHostClientInterface apiHost = this.createAPIHost();
        this.delegate = ApiProxyImpl.builder().setApiHost(apiHost).setDeadlineOracle(this.oracle).setByteCountBeforeFlushing(102400L).setMaxLogLineSize(16384).build();
        this.upRequest = RuntimePb.UPRequest.newBuilder().setAppId(APP_ID).setModuleId(ENGINE_ID).setModuleVersionId(ENGINE_VERSION_ID).setVersionId(VERSION_ID).setNickname("foo").setEmail("foo@foo.com").setAuthDomain("foo.com").setObfuscatedGaiaId("xxx").setPeerUsername("foo_peer").setSecurityLevel("foo_level").setEventIdHash("0000002A").setRequestLogId("0000003B").setGaiaId(12345L).setAuthuser("1").setGaiaSession("SESSION").setAppserverDatacenter("yq").setAppserverTaskBns("/bns/yq/appserver/321").buildPartial();
        this.upResponse = new MutableUpResponse();
        this.elapsedWallclockNanoseconds = 0L;
        this.mockTimer = new CpuRatioTimer(null, null, null, null){

            public long getCycleCount() {
                return ApiProxyImplTest.this.cpuCycles;
            }

            public Timer getWallclockTimer() {
                return new Timer(){

                    public void start() {
                    }

                    public void stop() {
                    }

                    public long getNanoseconds() {
                        return ApiProxyImplTest.this.elapsedWallclockNanoseconds;
                    }

                    public void update() {
                    }
                };
            }
        };
        AppinfoPb.AppInfo appInfo = AppinfoPb.AppInfo.newBuilder().setAppId(APP_ID).setVersionId(VERSION_ID).build();
        ApplicationEnvironment appEnv = new ApplicationEnvironment(APP_ID, VERSION_ID, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), this.rootDirectory, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        this.appVersion = AppVersion.builder().setAppVersionKey(AppVersionKey.of((String)APP_ID, (String)VERSION_ID)).setAppInfo(appInfo).setRootDirectory(this.rootDirectory).setEnvironment(appEnv).setSessionsConfig(this.sessionsConfig).setPublicRoot("").build();
        this.environment = this.createEnvironment();
    }

    @After
    public void tearDown() {
        this.delegate = null;
        this.upRequest = null;
        this.environment = null;
    }

    String getGoogleAppsNamespace() {
        return ApiProxyImplTest.getGoogleAppsNamespace((ApiProxy.Environment)this.environment);
    }

    static String getGoogleAppsNamespace(ApiProxy.Environment env) {
        Map attributes = env.getAttributes();
        String appsNamespace = (String)attributes.get(APPS_NAMESPACE_KEY);
        if (appsNamespace == null) {
            return "";
        }
        return appsNamespace;
    }

    @Test
    public void testStatusException_Cancelled() {
        Status.StatusProto proto = Status.StatusProto.newBuilder().setCode(1).setSpace("generic").build();
        Optional optionalException = ApiProxyUtils.statusException((Status.StatusProto)proto, (String)"packageName", (String)"methodName", null);
        Truth8.assertThat((Optional)optionalException).isPresent();
        Exception exception = (Exception)optionalException.get();
        Truth.assertThat((Throwable)exception).isInstanceOf(ApiProxy.CancelledException.class);
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"The API call packageName.methodName() was explicitly cancelled.");
    }

    @Test
    public void testStatusException_DeadlineExceeded() {
        Status.StatusProto proto = Status.StatusProto.newBuilder().setCode(4).setSpace("RPC").setMessage("Deadline exceeded").build();
        Optional optionalException = ApiProxyUtils.statusException((Status.StatusProto)proto, (String)"packageName", (String)"methodName", null);
        Truth8.assertThat((Optional)optionalException).isPresent();
        Exception exception = (Exception)optionalException.get();
        Truth.assertThat((Throwable)exception).isInstanceOf(ApiProxy.ApiDeadlineExceededException.class);
        Truth.assertThat((Throwable)exception).hasMessageThat().containsMatch("packageName.*methodName");
    }

    @Test
    public void testStatusException_OtherRpc() {
        Error cause = new Error("Something broke");
        Status.StatusProto proto = Status.StatusProto.newBuilder().setCode(13).setSpace("RPC").setMessage("Something broke").build();
        Optional optionalException = ApiProxyUtils.statusException((Status.StatusProto)proto, (String)"packageName", (String)"methodName", (Throwable)cause);
        Truth8.assertThat((Optional)optionalException).isPresent();
        Exception exception = (Exception)optionalException.get();
        Truth.assertThat((Throwable)exception).isInstanceOf(ApiProxy.UnknownException.class);
        Truth.assertThat((Throwable)exception).hasMessageThat().containsMatch("packageName.*methodName");
        Truth.assertThat((Throwable)exception).hasCauseThat().isSameInstanceAs((Object)cause);
    }

    @Test
    public void testUnknownException_CauseNotSerialized() throws Exception {
        ApiProxy.UnknownException deserializedException;
        byte[] serializedException;
        Error cause = new Error("Something broke");
        ApiProxy.UnknownException exception = new ApiProxy.UnknownException("packageName", "methodName", (Throwable)cause);
        Truth.assertThat((Throwable)exception).hasCauseThat().isSameInstanceAs((Object)cause);
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();
             ObjectOutputStream oout = new ObjectOutputStream(bout);){
            oout.writeObject(exception);
            oout.flush();
            serializedException = bout.toByteArray();
        }
        try (ByteArrayInputStream bin = new ByteArrayInputStream(serializedException);
             ObjectInputStream oin = new ObjectInputStream(bin);){
            deserializedException = (ApiProxy.UnknownException)oin.readObject();
        }
        Truth.assertThat((Throwable)deserializedException).hasCauseThat().isNull();
        Truth.assertThat((Throwable)deserializedException).hasMessageThat().isEqualTo((Object)exception.getMessage());
        Truth.assertThat((Object[])deserializedException.getStackTrace()).isEqualTo((Object)exception.getStackTrace());
    }

    @Test
    public void testStatusException_NotRpc() {
        Status.StatusProto proto = Status.StatusProto.newBuilder().setCode(2).setSpace("generic").build();
        Optional optionalException = ApiProxyUtils.statusException((Status.StatusProto)proto, (String)"packageName", (String)"methodName", null);
        Truth8.assertThat((Optional)optionalException).isEmpty();
    }

    @Test
    public void testCurrentEnvironment() {
        Truth.assertThat((String)this.environment.getAppId()).isEqualTo((Object)APP_ID);
        Truth.assertThat((String)this.environment.getModuleId()).isEqualTo((Object)ENGINE_ID);
        Truth.assertThat((String)this.environment.getVersionId()).isEqualTo((Object)ENGINE_VERSION_ID);
        Truth.assertThat((String)this.environment.getAuthDomain()).isEqualTo((Object)"foo.com");
        String namespace = this.environment.getRequestNamespace();
        Truth.assertThat((String)namespace).isEmpty();
        Truth.assertThat((String)this.getGoogleAppsNamespace()).isEmpty();
        Truth.assertThat((String)this.environment.getEmail()).isEqualTo((Object)"foo@foo.com");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_id_key")).isEqualTo((Object)"xxx");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_organization")).isEqualTo((Object)"");
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_peer_username")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_security_level")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.apphosting.api.ApiProxy.datacenter")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.apphosting.api.ApiProxy.request_id_hash")).isEqualTo((Object)"0000002A");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.request_log_id")).isEqualTo((Object)"0000003B");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.default_version_hostname")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_id")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_authuser")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_session")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.appserver_datacenter")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.appserver_task_bns")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.new_database_connectivity")).isEqualTo((Object)false);
        Truth8.assertThat((Optional)this.environment.getTraceId()).isEmpty();
    }

    @Test
    public void testCloudSqlJdbcConnectivityEnabled() {
        APIHostClientInterface apiHost = this.createAPIHost();
        this.delegate = ApiProxyImpl.builder().setApiHost(apiHost).setDeadlineOracle(this.oracle).setByteCountBeforeFlushing(102400L).setMaxLogLineSize(16384).setCloudSqlJdbcConnectivityEnabled(true).build();
        Truth.assertThat(this.createEnvironment().getAttributes().get("com.google.appengine.runtime.new_database_connectivity")).isEqualTo((Object)true);
        this.delegate = ApiProxyImpl.builder().setApiHost(apiHost).setDeadlineOracle(this.oracle).setByteCountBeforeFlushing(102400L).setMaxLogLineSize(16384).build();
        Truth.assertThat(this.createEnvironment().getAttributes().get("com.google.appengine.runtime.new_database_connectivity")).isEqualTo((Object)false);
    }

    @Test
    public void testMultiDomainApp() {
        this.upRequest = this.upRequest.toBuilder().setAuthDomain("example.com").setEmail("foo@example.com").buildPartial();
        this.environment = this.createEnvironment();
        Truth.assertThat((String)this.environment.getAppId()).isEqualTo((Object)APP_ID);
        Truth.assertThat((String)this.environment.getVersionId()).isEqualTo((Object)ENGINE_VERSION_ID);
        Truth.assertThat((String)this.environment.getAuthDomain()).isEqualTo((Object)"example.com");
        String namespace = this.environment.getRequestNamespace();
        Truth.assertThat((String)namespace).isEmpty();
        Truth.assertThat((String)this.getGoogleAppsNamespace()).isEmpty();
        Truth.assertThat((String)this.environment.getEmail()).isEqualTo((Object)"foo@example.com");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_id_key")).isEqualTo((Object)"xxx");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_organization")).isEqualTo((Object)"");
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_peer_username")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_security_level")).isEqualTo(null);
    }

    @Test
    public void testDatacenterAttribute() {
        APIHostClientInterface apiHost = this.createAPIHost();
        this.delegate = ApiProxyImpl.builder().setApiHost(apiHost).setDeadlineOracle(this.oracle).setExternalDatacenterName("na1").build();
        this.environment = this.createEnvironment();
        Truth.assertThat(this.environment.getAttributes().get("com.google.apphosting.api.ApiProxy.datacenter")).isEqualTo((Object)"na1");
    }

    @Test
    public void testDefaultVersionHostname() {
        this.upRequest = this.upRequest.toBuilder().setDefaultVersionHostname("foo.bar.com").buildPartial();
        this.environment = this.createEnvironment();
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.default_version_hostname")).isEqualTo((Object)"foo.bar.com");
    }

    @Test
    public void testGaPlusManagedUser() {
        this.upRequest = this.upRequest.toBuilder().setUserOrganization("foo.com").buildPartial();
        this.environment = this.createEnvironment();
        Truth.assertThat((String)this.environment.getAppId()).isEqualTo((Object)APP_ID);
        Truth.assertThat((String)this.environment.getVersionId()).isEqualTo((Object)ENGINE_VERSION_ID);
        Truth.assertThat((String)this.environment.getAuthDomain()).isEqualTo((Object)"foo.com");
        String namespace = this.environment.getRequestNamespace();
        Truth.assertThat((String)namespace).isEmpty();
        Truth.assertThat((String)this.getGoogleAppsNamespace()).isEmpty();
        Truth.assertThat((String)this.environment.getEmail()).isEqualTo((Object)"foo@foo.com");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_id_key")).isEqualTo((Object)"xxx");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.api.users.UserService.user_organization")).isEqualTo((Object)"foo.com");
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_peer_username")).isEqualTo(null);
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_security_level")).isEqualTo(null);
    }

    @Test
    public void testTrustedApp() {
        this.upRequest = this.upRequest.toBuilder().setIsTrustedApp(true).buildPartial();
        this.environment = this.createEnvironment();
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_peer_username")).isEqualTo((Object)"foo_peer");
        Truth.assertThat(this.environment.getAttributes().get("com.google.net.base.peer.loas_security_level")).isEqualTo((Object)"foo_level");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_id")).isEqualTo((Object)"12345");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_authuser")).isEqualTo((Object)"1");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_session")).isEqualTo((Object)"SESSION");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.appserver_datacenter")).isEqualTo((Object)"yq");
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.appserver_task_bns")).isEqualTo((Object)"/bns/yq/appserver/321");
    }

    @Test
    public void testGaiaIdIsZero() {
        this.upRequest = this.upRequest.toBuilder().setIsTrustedApp(true).setGaiaId(0L).buildPartial();
        this.environment = this.createEnvironment();
        Truth.assertThat(this.environment.getAttributes().get("com.google.appengine.runtime.gaia_id")).isEqualTo((Object)"");
    }

    @Test
    public void testTraceDisabled() {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray());
        Truth.assertThat((Boolean)this.upResponse.hasSerializedTrace()).isFalse();
    }

    @Test
    public void testTraceEnabled() throws Exception {
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(1).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(context).buildPartial();
        this.environment = this.createEnvironment();
        this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", ApiBasePb.StringProto.getDefaultInstance().toByteArray());
        ApiBasePb.StringProto request = ApiBasePb.StringProto.newBuilder().setValue("pi").build();
        this.delegate.makeSyncCall(this.environment, "google.math", "LookupSymbol", request.toByteArray());
        ApiBasePb.StringProto request3 = ApiBasePb.StringProto.newBuilder().setValue("not-pi").build();
        Assert.assertThrows(ApiProxy.ApplicationException.class, () -> this.delegate.makeSyncCall(this.environment, "google.math", "LookupSymbol", request3.toByteArray()));
        this.environment.getTraceWriter().flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)3);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/get.deadline.Get");
        long requestSpanId = startSpan.getParentSpanId().getId();
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/google.math.LookupSymbol");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/google.math.LookupSymbol");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
    }

    @Test
    public void testTraceContextResetsBetweenRequests() {
        TracePb.TraceContextProto requestContext1 = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace_id1")).setSpanId(1L).setTraceMask(1).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(requestContext1).buildPartial();
        CloudTraceContext traceContext1 = CloudTrace.getCurrentContext((ApiProxy.Environment)this.createEnvironment());
        TracePb.TraceContextProto requestContext2 = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace_id2")).setSpanId(2L).setTraceMask(3).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(requestContext2).buildPartial();
        CloudTraceContext traceContext2 = CloudTrace.getCurrentContext((ApiProxy.Environment)this.createEnvironment());
        Truth.assertThat((byte[])traceContext1.getTraceId()).isNotEqualTo((Object)traceContext2.getTraceId());
        Truth.assertThat((Long)traceContext1.getSpanId()).isNotEqualTo((Object)traceContext2.getSpanId());
        Truth.assertThat((Long)traceContext1.getTraceMask()).isNotEqualTo((Object)traceContext2.getTraceMask());
    }

    @Test
    public void testStackTraceEnabled() throws Exception {
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(3).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(context).buildPartial();
        this.environment = this.createEnvironment();
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray());
        this.environment.getTraceWriter().flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)1);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
        Truth.assertThat((Boolean)spanEvents.getEvent(0).hasStartSpan()).isTrue();
        Truth.assertThat((Boolean)spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().hasStackTraceHashId()).isTrue();
        Truth.assertThat((Boolean)spanEvents.getEvent(2).hasEndSpan()).isTrue();
    }

    @Test
    public void testTraceId() {
        TraceId.TraceIdProto traceId = TraceId.TraceIdProto.newBuilder().setHi(72623859790382856L).setLo(653040715295888662L).build();
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(traceId.toByteString()).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(context).buildPartial();
        this.environment = this.createEnvironment();
        Truth8.assertThat((Optional)this.environment.getTraceId()).hasValue((Object)"01020304050607080910111213141516");
    }

    @Test
    public void testSuccess() throws InvalidProtocolBufferException {
        this.cpuCycles = 1000000L;
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getCpuTimeInMegaCycles()).isEqualTo((Object)1L);
        ApiBasePb.StringProto.Builder request = ApiBasePb.StringProto.newBuilder();
        ApiBasePb.DoubleProto.Builder response = ApiBasePb.DoubleProto.newBuilder();
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getApiTimeInMegaCycles()).isEqualTo((Object)0L);
        request.setValue("pi");
        response.mergeFrom(this.delegate.makeSyncCall(this.environment, "google.math", "LookupSymbol", request.build().toByteArray()), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getApiTimeInMegaCycles()).isEqualTo((Object)1L);
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(Math.PI);
        this.cpuCycles = 23000000L;
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getCpuTimeInMegaCycles()).isEqualTo((Object)23L);
    }

    @Test
    public void testCancellation() throws InterruptedException {
        String expectedDeadlineMessage = "The API call hang.forever.() was cancelled because the overall HTTP request deadline was reached.";
        String expectedCancellationMessage = "The API call hang.forever.() was explicitly cancelled.";
        String expectedInterruptionMessage = "The API call hang.forever.() was cancelled because the thread was interrupted.";
        this.doCancellationTest(600L, expectedDeadlineMessage, Signal.CANCEL);
        this.doCancellationTest(800L, expectedDeadlineMessage, Signal.CANCEL);
        this.doCancellationTest(560L, expectedDeadlineMessage, Signal.CANCEL);
        this.doCancellationTest(300L, expectedCancellationMessage, Signal.CANCEL);
        this.doCancellationTest(600L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(800L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(560L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(300L, expectedInterruptionMessage, Signal.INTERRUPT);
    }

    private void doCancellationTest(long millisBeforeCancellation, String expectedMessage, Signal signal) throws InterruptedException {
        this.elapsedWallclockNanoseconds = millisBeforeCancellation * 1000000L;
        Thread testThread = Thread.currentThread();
        Thread otherThread = new Thread(() -> {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException e) {
                System.err.println("Other thread unexpectedly interrupted: " + e);
            }
            switch (signal) {
                case CANCEL: {
                    List<Future<?>> list = this.futures;
                    synchronized (list) {
                        for (Future<?> future : this.futures) {
                            future.cancel(true);
                        }
                        break;
                    }
                }
                case INTERRUPT: {
                    testThread.interrupt();
                }
            }
        });
        otherThread.start();
        ApiProxy.CancelledException ex = (ApiProxy.CancelledException)Assert.assertThrows(ApiProxy.CancelledException.class, () -> this.delegate.makeSyncCall(this.environment, "hang.forever", "", new byte[0]));
        Truth.assertWithMessage((String)String.format("millisBeforeCancellation: %d; signal: %s", new Object[]{millisBeforeCancellation, signal})).that((Throwable)ex).hasMessageThat().isEqualTo((Object)expectedMessage);
        otherThread.join();
    }

    @Test
    public void testApiSlotCancellationTest() throws InterruptedException {
        String expectedDeadlineMessage = "The API call hang.forever.() was cancelled because the overall HTTP request deadline was reached while waiting for concurrent API calls.";
        String expectedInterruptionMessage = "The API call hang.forever.() was cancelled because the thread was interrupted while waiting for concurrent API calls.";
        this.maxConcurrentApiCalls = 0;
        this.environment = this.createEnvironment();
        this.doCancellationTest(800L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(600L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(560L, expectedDeadlineMessage, Signal.INTERRUPT);
        this.doCancellationTest(300L, expectedInterruptionMessage, Signal.INTERRUPT);
    }

    @Test
    public void testDefaultDeadline() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto response = ApiBasePb.DoubleProto.parseFrom((byte[])this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray()), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(5.0);
    }

    @Test
    public void testDeadlineOverride() throws InvalidProtocolBufferException {
        double userDeadline = 7.0;
        this.environment.getAttributes().put("com.google.apphosting.api.ApiProxy.api_deadline_key", userDeadline);
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto response = ApiBasePb.DoubleProto.parseFrom((byte[])this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray()), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(userDeadline);
    }

    @Test
    public void testMaxDeadline() throws InvalidProtocolBufferException {
        double userDeadline = 20.0;
        this.environment.getAttributes().put("com.google.apphosting.api.ApiProxy.api_deadline_key", userDeadline);
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto response = ApiBasePb.DoubleProto.parseFrom((byte[])this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray()), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(10.0);
    }

    @Test
    public void testDefaultOfflineDeadline() throws InvalidProtocolBufferException {
        RuntimePb.UPRequest.Builder builder = this.upRequest.toBuilder();
        builder.getRequestBuilder().setIsOffline(true);
        this.upRequest = builder.buildPartial();
        this.environment = this.createEnvironment();
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto response = ApiBasePb.DoubleProto.parseFrom((byte[])this.delegate.makeSyncCall(this.environment, "get.deadline", "Get", request.toByteArray()), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(7.0);
    }

    @Test
    public void testRemainingMillisNoTimeElapsed() {
        Truth.assertThat((Long)this.environment.getRemainingMillis()).isEqualTo((Object)600);
    }

    @Test
    public void testRemainingMillisSomeTimeElapsed() {
        this.elapsedWallclockNanoseconds = 3500000L;
        Truth.assertThat((Long)this.environment.getRemainingMillis()).isEqualTo((Object)597);
    }

    private static void assertStackTraceIsCorrect(ApiProxy.ApiProxyException e) {
        String methodName = e.getStackTrace()[1].getMethodName();
        Truth.assertThat((String)methodName).isEqualTo((Object)"doSyncCall");
    }

    @Test
    public void testApplicationError() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.newBuilder().setValue("not_pi").build();
        ApiProxy.ApplicationException ex = (ApiProxy.ApplicationException)Assert.assertThrows(ApiProxy.ApplicationException.class, () -> this.delegate.makeSyncCall(this.environment, "google.math", "LookupSymbol", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testMethodWithMemcacheUnavailable() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.CapabilityDisabledException ex = (ApiProxy.CapabilityDisabledException)Assert.assertThrows(ApiProxy.CapabilityDisabledException.class, () -> this.delegate.makeSyncCall(this.environment, "memcache", "DontCare", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testMethodWithMemcacheUnavailable_nonMemcache() throws InvalidProtocolBufferException {
        ApiBasePb.VoidProto request = ApiBasePb.VoidProto.getDefaultInstance();
        ApiProxy.ApplicationException ex = (ApiProxy.ApplicationException)Assert.assertThrows(ApiProxy.ApplicationException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.same.val.as.memcache.unavailable", "DontCare", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testRpcError() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.newBuilder().setValue("not_pi").build();
        ApiProxy.ApplicationException ex = (ApiProxy.ApplicationException)Assert.assertThrows(ApiProxy.ApplicationException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.rpc.error", "LookupSymbol", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testWrongPackage() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.CallNotFoundException ex = (ApiProxy.CallNotFoundException)Assert.assertThrows(ApiProxy.CallNotFoundException.class, () -> this.delegate.makeSyncCall(this.environment, "non.existent", "LookupSymbol", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testWrongMethod() throws InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.CallNotFoundException ex = (ApiProxy.CallNotFoundException)Assert.assertThrows(ApiProxy.CallNotFoundException.class, () -> this.delegate.makeSyncCall(this.environment, "google.math", "NonExistentCall", request.toByteArray()));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)ex);
    }

    @Test
    public void testParseError() {
        ApiProxy.ArgumentException e = (ApiProxy.ArgumentException)Assert.assertThrows(ApiProxy.ArgumentException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.parse.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testCapabilityDisabledError() {
        ApiProxy.CapabilityDisabledException e = (ApiProxy.CapabilityDisabledException)Assert.assertThrows(ApiProxy.CapabilityDisabledException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.capability.disabled.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testFeatureNotEnabledError() {
        ApiProxy.FeatureNotEnabledException e = (ApiProxy.FeatureNotEnabledException)Assert.assertThrows(ApiProxy.FeatureNotEnabledException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.feature.disabled.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"generate.feature.disabled.error. You need to turn on billing!");
    }

    @Test
    public void testOverQuotaError() {
        ApiProxy.OverQuotaException e = (ApiProxy.OverQuotaException)Assert.assertThrows(ApiProxy.OverQuotaException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.over.quota.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testRequestTooLargeError() {
        ApiProxy.RequestTooLargeException e = (ApiProxy.RequestTooLargeException)Assert.assertThrows(ApiProxy.RequestTooLargeException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.too.large.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testResponseTooLargeError() {
        ApiProxy.ResponseTooLargeException e = (ApiProxy.ResponseTooLargeException)Assert.assertThrows(ApiProxy.ResponseTooLargeException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.too.large.response.error", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testSecurityViolationError() {
        ApiProxy.UnknownException e = (ApiProxy.UnknownException)Assert.assertThrows(ApiProxy.UnknownException.class, () -> this.delegate.makeSyncCall(this.environment, "generate.security.violation", "", "garbage".getBytes(StandardCharsets.UTF_8)));
        ApiProxyImplTest.assertStackTraceIsCorrect((ApiProxy.ApiProxyException)e);
    }

    @Test
    public void testAllAPIResponseErrorsHandled() {
        final RuntimePb.APIResponse.ERROR[] currentError = new RuntimePb.APIResponse.ERROR[1];
        APIHostClientInterface host = new APIHostClientInterface(){

            public void call(AnyRpcClientContext ctx, RuntimePb.APIRequest req, AnyRpcCallback<RuntimePb.APIResponse> cb) {
                RuntimePb.APIResponse reply = RuntimePb.APIResponse.newBuilder().setError(currentError[0].getNumber()).build();
                cb.success((MessageLite)reply);
            }

            public void disable() {
                throw new UnsupportedOperationException();
            }

            public void enable() {
                throw new UnsupportedOperationException();
            }

            public AnyRpcClientContext newClientContext() {
                return (AnyRpcClientContext)Mockito.mock(AnyRpcClientContext.class);
            }
        };
        this.delegate = ApiProxyImpl.builder().setApiHost(host).setDeadlineOracle(this.oracle).build();
        for (RuntimePb.APIResponse.ERROR error : RuntimePb.APIResponse.ERROR.values()) {
            if (error.equals((Object)RuntimePb.APIResponse.ERROR.OK)) continue;
            currentError[0] = error;
            Throwable e = Assert.assertThrows(Throwable.class, () -> this.delegate.makeSyncCall(this.environment, "whatever", "", "garbage".getBytes(StandardCharsets.UTF_8)));
            Truth.assertWithMessage((String)"Wrong type exception: %s", (Object[])new Object[]{e}).that(e).isInstanceOf(ApiProxy.ApiProxyException.class);
        }
    }

    @Test
    public void testRequestNamespace() {
        RuntimePb.UPRequest.Builder builder = this.upRequest.toBuilder();
        HttpPb.HttpRequest.Builder httpRequest = builder.getRequestBuilder();
        httpRequest.addHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey("X-AppEngine-Default-Namespace").setValue("ns"));
        this.upRequest = builder.buildPartial();
        ApiProxyImpl.EnvironmentImpl localEnvironment = this.createEnvironment();
        String namespace = localEnvironment.getRequestNamespace();
        Truth.assertThat((String)namespace).isEqualTo((Object)"ns");
        Truth.assertThat((String)ApiProxyImplTest.getGoogleAppsNamespace((ApiProxy.Environment)localEnvironment)).isEqualTo((Object)"ns");
        Map attributes = localEnvironment.getAttributes();
        Truth.assertThat((Map)attributes).doesNotContainKey((Object)CURRENT_NAMESPACE_KEY);
    }

    @Test
    public void testCurrentNamespace() {
        HttpPb.HttpRequest httpRequest = this.upRequest.getRequest().toBuilder().addHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey("X-AppEngine-Default-Namespace").setValue("request-ns")).addHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey("X-AppEngine-Current-Namespace").setValue("current-ns")).buildPartial();
        this.upRequest = this.upRequest.toBuilder().setRequest(httpRequest).buildPartial();
        ApiProxyImpl.EnvironmentImpl localEnvironment = this.createEnvironment();
        Map attributes = localEnvironment.getAttributes();
        String namespace = (String)attributes.get(CURRENT_NAMESPACE_KEY);
        Truth.assertThat((String)namespace).isEqualTo((Object)"current-ns");
        namespace = (String)attributes.get(APPS_NAMESPACE_KEY);
        Truth.assertThat((String)namespace).isEqualTo((Object)"request-ns");
    }

    @Test
    public void testAsync_traceDisabled() throws ExecutionException, InterruptedException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig).get();
        Truth.assertThat((Boolean)this.upResponse.hasSerializedTrace()).isFalse();
    }

    @Test
    public void testAsync_traceEnabled() throws InvalidProtocolBufferException {
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(1).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(context).buildPartial();
        this.environment = this.createEnvironment();
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future response1 = this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig);
        ApiBasePb.StringProto request2 = ApiBasePb.StringProto.newBuilder().setValue("pi").build();
        Future response2 = this.delegate.makeAsyncCall(this.environment, "google.math", "LookupSymbol", request2.toByteArray(), apiConfig);
        ApiBasePb.StringProto request3 = ApiBasePb.StringProto.newBuilder().setValue("not_pi").build();
        Future response3 = this.delegate.makeAsyncCall(this.environment, "google.math", "LookupSymbol", request3.toByteArray(), apiConfig);
        try {
            response1.get();
            response2.get();
            response3.get();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.environment.getTraceWriter().flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)3);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/get.deadline.Get");
        long requestSpanId = startSpan.getParentSpanId().getId();
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/google.math.LookupSymbol");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/google.math.LookupSymbol");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
    }

    @Test
    public void testAsync_StackTraceEnabled() throws Exception {
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(3).build();
        this.upRequest = this.upRequest.toBuilder().setTraceContext(context).buildPartial();
        this.environment = this.createEnvironment();
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future response1 = this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig);
        response1.get();
        this.environment.getTraceWriter().flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)1);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
        Truth.assertThat((Boolean)spanEvents.getEvent(0).hasStartSpan()).isTrue();
        Truth.assertThat((Boolean)spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().hasStackTraceHashId()).isTrue();
        Truth.assertThat((Boolean)spanEvents.getEvent(2).hasEndSpan()).isTrue();
    }

    @Test
    public void testAsync_success() throws ExecutionException, InterruptedException, InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.newBuilder().setValue("pi").build();
        ApiBasePb.DoubleProto.Builder response = ApiBasePb.DoubleProto.newBuilder();
        this.delegate.makeSyncCall(this.environment, "google.math", "LookupSymbol", request.toByteArray());
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getApiTimeInMegaCycles()).isEqualTo((Object)1L);
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future bytes = this.delegate.makeAsyncCall(this.environment, "google.math", "LookupSymbol", request.toByteArray(), apiConfig);
        response.mergeFrom((byte[])bytes.get());
        Truth.assertThat((Object)bytes).isInstanceOf(ApiProxy.ApiResultFuture.class);
        Truth.assertThat((Long)((ApiProxy.ApiResultFuture)bytes).getCpuTimeInMegaCycles()).isEqualTo((Object)1L);
        Truth.assertThat((Long)ApiStats.get((ApiProxy.Environment)this.environment).getApiTimeInMegaCycles()).isEqualTo((Object)2L);
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(Math.PI);
    }

    @Test
    public void testAsync_notFinished() {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future future = this.delegate.makeAsyncCall(this.environment, "hang.forever", "", new byte[0], apiConfig);
        ApiProxy.ApiResultFuture resultFuture = (ApiProxy.ApiResultFuture)future;
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        Assert.assertThrows(IllegalStateException.class, () -> ((ApiProxy.ApiResultFuture)resultFuture).getWallclockTimeInMillis());
        Assert.assertThrows(IllegalStateException.class, () -> ((ApiProxy.ApiResultFuture)resultFuture).getCpuTimeInMegaCycles());
    }

    @Test
    public void testAsync_sleep() throws ExecutionException, InterruptedException {
        ApiBasePb.Integer32Proto request = ApiBasePb.Integer32Proto.newBuilder().setValue(100).build();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future future = this.delegate.makeAsyncCall(this.environment, "sleep", "Sleep", request.toByteArray(), apiConfig);
        ApiProxy.ApiResultFuture resultFuture = (ApiProxy.ApiResultFuture)future;
        future.get();
        long time = resultFuture.getWallclockTimeInMillis();
        Truth.assertWithMessage((String)"API call time in milliseconds").that(Long.valueOf(time)).isAtLeast((Comparable)Long.valueOf(50L));
        Truth.assertWithMessage((String)"API call time in milliseconds").that(Long.valueOf(time)).isLessThan((Comparable)Long.valueOf(500L));
    }

    @Test
    public void testAsync_defaultDeadline() throws ExecutionException, InterruptedException, InvalidProtocolBufferException {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto.Builder response = ApiBasePb.DoubleProto.newBuilder();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future bytes = this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig);
        response.mergeFrom((byte[])bytes.get());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(5.0);
    }

    @Test
    public void testAsync_deadlineExceeded() {
        double userDeadline = 0.25;
        int sleepTime = 10000;
        ApiBasePb.Integer32Proto request = ApiBasePb.Integer32Proto.newBuilder().setValue(sleepTime).build();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(userDeadline));
        Future future = this.delegate.makeAsyncCall(this.environment, "sleep", "Sleep", request.toByteArray(), apiConfig);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
        this.sleepSemaphore.release();
        Throwable cause = e.getCause();
        Truth.assertThat((Throwable)cause).isInstanceOf(ApiProxy.ApiDeadlineExceededException.class);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        ApiProxy.ApiResultFuture result = (ApiProxy.ApiResultFuture)future;
        Truth.assertThat((Long)result.getWallclockTimeInMillis()).isAtLeast(250);
        Truth.assertThat((Long)result.getWallclockTimeInMillis()).isAtMost(5000);
        Truth.assertThat((Long)result.getCpuTimeInMegaCycles()).isNotEqualTo((Object)-1L);
    }

    @Test
    public void testAsync_deadlineExceededWhileWaitingForApiSlot() throws Exception {
        this.maxConcurrentApiCalls = 1;
        ApiProxyImpl.EnvironmentImpl nonConcurrentEnvironment = this.createEnvironment();
        int sleepTime = 10000;
        ApiBasePb.Integer32Proto request = ApiBasePb.Integer32Proto.newBuilder().setValue(sleepTime).build();
        double firstDeadline = 20.0;
        ApiProxy.ApiConfig firstApiConfig = new ApiProxy.ApiConfig();
        firstApiConfig.setDeadlineInSeconds(Double.valueOf(firstDeadline));
        Future firstFuture = this.delegate.makeAsyncCall(nonConcurrentEnvironment, "sleep", "Sleep", request.toByteArray(), firstApiConfig);
        Instant stopTime = Instant.now().plusSeconds(5L);
        while (Instant.now().isBefore(stopTime) && this.sleepSemaphore.getQueueLength() == 0) {
            Thread.sleep(10L);
        }
        double secondDeadline = 0.25;
        ApiProxy.ApiConfig secondApiConfig = new ApiProxy.ApiConfig();
        secondApiConfig.setDeadlineInSeconds(Double.valueOf(secondDeadline));
        Instant asyncCallStart = Instant.now();
        Future secondFuture = this.delegate.makeAsyncCall(nonConcurrentEnvironment, "sleep", "Sleep", request.toByteArray(), secondApiConfig);
        Instant asyncCallEnd = Instant.now();
        Truth.assertThat((Long)Duration.between(asyncCallStart, asyncCallEnd).getSeconds()).isLessThan(2);
        ApiProxy.CancelledException ex = (ApiProxy.CancelledException)Assert.assertThrows(ApiProxy.CancelledException.class, () -> secondFuture.get(2L, TimeUnit.SECONDS));
        Truth.assertThat((Throwable)ex).hasMessageThat().isEqualTo((Object)"The API call sleep.Sleep() was cancelled because the thread was interrupted while waiting for concurrent API calls.");
        firstFuture.cancel(true);
    }

    @Test
    public void testAsync_deadlineOverride() throws ExecutionException, InterruptedException, InvalidProtocolBufferException {
        double userDeadline = 7.0;
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto.Builder response = ApiBasePb.DoubleProto.newBuilder();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(userDeadline));
        Future bytes = this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig);
        response.mergeFrom((byte[])bytes.get());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(userDeadline);
    }

    @Test
    public void testAsync_rpcDeadlineExceeded() {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(10.0));
        Future task = this.delegate.makeAsyncCall(this.environment, "generate.deadline.exceeded.error", "", "garbage".getBytes(StandardCharsets.UTF_8), apiConfig);
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, task::get);
        Truth.assertThat((Throwable)ex).hasCauseThat().isInstanceOf(ApiProxy.ApiDeadlineExceededException.class);
        Truth.assertThat((Boolean)task.isDone()).isTrue();
        ApiProxy.ApiResultFuture result = (ApiProxy.ApiResultFuture)task;
        Truth.assertThat((Long)result.getWallclockTimeInMillis()).isLessThan(5000);
        Truth.assertThat((Long)result.getCpuTimeInMegaCycles()).isNotEqualTo((Object)-1L);
    }

    @Test
    public void testAsync_rpcCancelled() {
        Future task = this.delegate.makeAsyncCall(this.environment, "generate.cancelled.rpc", "", "garbage".getBytes(StandardCharsets.UTF_8), new ApiProxy.ApiConfig());
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, task::get);
        Truth.assertThat((Throwable)ex).hasCauseThat().isInstanceOf(ApiProxy.CancelledException.class);
        Truth.assertThat((Throwable)ex).hasCauseThat().hasMessageThat().isEqualTo((Object)"The API call generate.cancelled.rpc.() was explicitly cancelled.");
    }

    @Test
    public void testAsync_rpcServerError() {
        Future task = this.delegate.makeAsyncCall(this.environment, "generate.rpc.server.error", "", "garbage".getBytes(StandardCharsets.UTF_8), new ApiProxy.ApiConfig());
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, task::get);
        Truth.assertThat((Throwable)ex).hasCauseThat().isInstanceOf(ApiProxy.UnknownException.class);
    }

    @Test
    public void testAsync_maxDeadline() throws ExecutionException, InterruptedException, InvalidProtocolBufferException {
        double userDeadline = 20.0;
        ApiBasePb.StringProto request = ApiBasePb.StringProto.getDefaultInstance();
        ApiBasePb.DoubleProto.Builder response = ApiBasePb.DoubleProto.newBuilder();
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(userDeadline));
        Future bytes = this.delegate.makeAsyncCall(this.environment, "get.deadline", "Get", request.toByteArray(), apiConfig);
        response.mergeFrom((byte[])bytes.get());
        Truth.assertThat((Boolean)response.hasValue()).isTrue();
        Truth.assertThat((Double)response.getValue()).isWithin(1.0E-5).of(10.0);
    }

    @Test
    public void testAsync_applicationError() {
        ApiBasePb.StringProto request = ApiBasePb.StringProto.newBuilder().setValue("not_pi").build();
        Future task = this.delegate.makeAsyncCall(this.environment, "google.math", "LookupSymbol", request.toByteArray(), new ApiProxy.ApiConfig());
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, task::get);
        Truth.assertThat((Throwable)ex).hasCauseThat().isInstanceOf(ApiProxy.ApplicationException.class);
    }

    @Test
    public void testAsync_capabilityDisabledError() {
        Future task = this.delegate.makeAsyncCall(this.environment, "generate.capability.disabled.error", "", "garbage".getBytes(StandardCharsets.UTF_8), new ApiProxy.ApiConfig());
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, task::get);
        Truth.assertThat((Throwable)ex).hasCauseThat().isInstanceOf(ApiProxy.CapabilityDisabledException.class);
    }

    @Test
    public void testDefaultLogsSetting() throws IOException {
        AppinfoPb.AppInfo appInfo = AppinfoPb.AppInfo.newBuilder().setAppId(APP_ID).setVersionId(VERSION_ID).build();
        this.appVersion = this.createAppVersion(appInfo, this.rootDirectory);
        this.environment = this.createEnvironment();
        Truth.assertThat((Long)this.environment.getAppLogsWriter().getByteCountBeforeFlushing()).isEqualTo((Object)102400L);
        Truth.assertThat((Integer)this.environment.getAppLogsWriter().getMaxLogMessageLength()).isEqualTo((Object)16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentRequestThreadFactory() throws InterruptedException, IOException {
        ApplicationEnvironment appEnv = new ApplicationEnvironment(APP_ID, VERSION_ID, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), this.rootDirectory, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        AppinfoPb.AppInfo appInfo = AppinfoPb.AppInfo.newBuilder().setAppId(APP_ID).setVersionId(VERSION_ID).build();
        this.appVersion = AppVersion.builder().setAppVersionKey(AppVersionKey.of((String)APP_ID, (String)VERSION_ID)).setAppInfo(appInfo).setRootDirectory(this.rootDirectory).setEnvironment(appEnv).setSessionsConfig(this.sessionsConfig).setPublicRoot("").build();
        this.environment = this.createEnvironment();
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.environment);
        try {
            ThreadFactory factory = ThreadManager.currentRequestThreadFactory();
            Runnable r = () -> {};
            Truth.assertThat((Object)factory.newThread(r)).isNotNull();
            AtomicBoolean caughtExpectedException = new AtomicBoolean();
            Thread t = new Thread(() -> {
                block2: {
                    try {
                        factory.newThread(r);
                    }
                    catch (NullPointerException e) {
                        if (!e.getMessage().equals("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager")) break block2;
                        caughtExpectedException.set(true);
                    }
                }
            });
            t.start();
            t.join();
            Truth.assertWithMessage((String)"Was expecting a NPE with a specific message to be thrown").that(Boolean.valueOf(caughtExpectedException.get())).isTrue();
        }
        finally {
            ApiProxy.clearEnvironmentForCurrentThread();
        }
    }

    @Test
    public void testExceptionInRpcCallDoesNotCountAsOngoingApiCall() {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        MockAPIHost apiHost = new MockAPIHost(null){

            @Override
            public void call(AnyRpcClientContext anyCtx, RuntimePb.APIRequest req, AnyRpcCallback<RuntimePb.APIResponse> callback) {
                throw new UnsupportedOperationException();
            }
        };
        this.maxConcurrentApiCalls = 1;
        this.delegate = ApiProxyImpl.builder().setApiHost((APIHostClientInterface)apiHost).setDeadlineOracle(this.oracle).setExternalDatacenterName("na1").build();
        this.environment = this.createEnvironment();
        Future result1 = this.delegate.makeAsyncCall(this.environment, "ignored.package", "IgnoredMethod", new byte[0], apiConfig);
        ExecutionException exception1 = (ExecutionException)Assert.assertThrows(ExecutionException.class, result1::get);
        Truth.assertThat((Throwable)exception1).hasCauseThat().isInstanceOf(UnsupportedOperationException.class);
        Future result2 = this.delegate.makeAsyncCall(this.environment, "ignored.package", "IgnoredMethod", new byte[0], apiConfig);
        ExecutionException exception2 = (ExecutionException)Assert.assertThrows(ExecutionException.class, result2::get);
        Truth.assertThat((Throwable)exception2).hasCauseThat().isInstanceOf(UnsupportedOperationException.class);
    }

    private AppVersion createAppVersion(String versionId, AppinfoPb.AppInfo appInfo, File rootDirectory) {
        ApplicationEnvironment appEnv = new ApplicationEnvironment(APP_ID, versionId, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), rootDirectory, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        return AppVersion.builder().setAppVersionKey(AppVersionKey.of((String)APP_ID, (String)versionId)).setAppInfo(appInfo).setRootDirectory(rootDirectory).setEnvironment(appEnv).setSessionsConfig(this.sessionsConfig).setPublicRoot("").build();
    }

    private AppVersion createAppVersion(AppinfoPb.AppInfo appInfo, File rootDirectory) {
        return this.createAppVersion(VERSION_ID, appInfo, rootDirectory);
    }

    private ApiProxyImpl.EnvironmentImpl createEnvironment() {
        return this.createEnvironment(this.upRequest, this.upResponse);
    }

    private ApiProxyImpl.EnvironmentImpl createEnvironment(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) {
        return this.delegate.createEnvironment(this.appVersion, upRequest, upResponse, TraceWriter.getTraceWriterForRequest((RuntimePb.UPRequest)upRequest, (MutableUpResponse)upResponse), this.mockTimer, REQUEST_ID, this.futures, new Semaphore(this.maxConcurrentApiCalls), new ThreadGroup("test"), new RequestState(), Long.valueOf(600L));
    }

    private APIHostClientInterface createAPIHost() {
        return new MockAPIHost(this.sleepSemaphore);
    }

    private static class MockRpcClientContext
    implements AnyRpcClientContext {
        private long startTimeMillis;
        private AnyRpcCallback<RuntimePb.APIResponse> callback;
        private double deadlineSeconds;
        private int applicationError;
        private String errorDetail;
        private Status.StatusProto status;

        private MockRpcClientContext() {
        }

        void setStartTimeMillis(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }

        void setCallback(AnyRpcCallback<RuntimePb.APIResponse> callback) {
            this.callback = callback;
        }

        void finishWithResponse(RuntimePb.APIResponse response) {
            this.callback.success((MessageLite)response);
        }

        void finishWithAppError(int applicationError, String errorDetail) {
            this.applicationError = applicationError;
            this.errorDetail = errorDetail;
            this.status = Status.StatusProto.newBuilder().setSpace("AppError").setCode(applicationError).setCanonicalCode(applicationError).setMessage(errorDetail).build();
            this.callback.failure();
        }

        void finishWithError(String space, int code, int canonicalCode, String errorDetail) {
            this.applicationError = 0;
            this.errorDetail = errorDetail;
            this.status = Status.StatusProto.newBuilder().setSpace(space).setCode(code).setCanonicalCode(canonicalCode).setMessage(errorDetail).build();
            this.callback.failure();
        }

        public int getApplicationError() {
            return this.applicationError;
        }

        public String getErrorDetail() {
            return this.errorDetail;
        }

        public Status.StatusProto getStatus() {
            return this.status;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public Throwable getException() {
            return null;
        }

        public void setDeadline(double seconds) {
            this.deadlineSeconds = seconds;
        }

        double getDeadlineInSeconds() {
            return this.deadlineSeconds;
        }

        public void startCancel() {
            this.finishWithError("generic", 1, 1, "Cancelled");
        }
    }

    private static class MockAPIHost
    implements APIHostClientInterface {
        private final Semaphore latch;

        MockAPIHost(Semaphore latch) {
            this.latch = latch;
        }

        public void call(AnyRpcClientContext anyCtx, RuntimePb.APIRequest req, AnyRpcCallback<RuntimePb.APIResponse> callback) {
            MockRpcClientContext ctx = (MockRpcClientContext)anyCtx;
            ctx.setStartTimeMillis(System.currentTimeMillis());
            ctx.setCallback(callback);
            new Thread(() -> this.call(ctx, req)).start();
        }

        private void call(MockRpcClientContext ctx, RuntimePb.APIRequest req) {
            RuntimePb.APIResponse.Builder reply = RuntimePb.APIResponse.newBuilder();
            if (req.getApiPackage().equals("google.math")) {
                if (req.getCall().equals("LookupSymbol")) {
                    ApiBasePb.StringProto.Builder reqProto = ApiBasePb.StringProto.newBuilder();
                    try {
                        reqProto.mergeFrom(req.getPb(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new AssertionError("InvalidProtocolBufferException", e);
                    }
                    String symbol = reqProto.getValue();
                    ApiBasePb.DoubleProto.Builder replyProto = ApiBasePb.DoubleProto.newBuilder();
                    if (!symbol.equals("pi")) {
                        ctx.finishWithAppError(42, "SymbolNotFound: " + symbol);
                        return;
                    }
                    replyProto.setValue(Math.PI);
                    reply.setError(0).setPb(replyProto.build().toByteString()).setCpuUsage(1L);
                } else {
                    reply.setError(1).setCpuUsage(1L);
                }
            } else if (req.getApiPackage().equals("sleep")) {
                ApiBasePb.Integer32Proto.Builder reqProto = ApiBasePb.Integer32Proto.newBuilder();
                try {
                    reqProto.mergeFrom(req.getPb(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new AssertionError("InvalidProtocolBufferException", e);
                }
                try {
                    this.latch.tryAcquire(reqProto.getValue(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                reply.setError(0).setPb(ByteString.EMPTY);
            } else if (req.getApiPackage().equals("get.deadline")) {
                ApiBasePb.DoubleProto replyProto = ApiBasePb.DoubleProto.newBuilder().setValue(ctx.getDeadlineInSeconds()).build();
                reply.setError(0).setPb(replyProto.toByteString());
            } else if (req.getApiPackage().equals("generate.parse.error")) {
                reply.setError(2);
            } else if (req.getApiPackage().equals("generate.capability.disabled.error")) {
                reply.setError(6);
            } else if (req.getApiPackage().equals("generate.feature.disabled.error")) {
                reply.setError(7).setErrorMessage("You need to turn on billing!");
            } else if (req.getApiPackage().equals("generate.over.quota.error")) {
                reply.setError(4);
            } else if (req.getApiPackage().equals("generate.too.large.error")) {
                reply.setError(5);
            } else if (req.getApiPackage().equals("generate.too.large.response.error")) {
                reply.setError(10);
            } else if (req.getApiPackage().equals("generate.security.violation")) {
                reply.setError(3);
            } else if (req.getApiPackage().equals("generate.rpc.error")) {
                reply.setError(13).setErrorMessage("Error detail").setRpcError(RuntimePb.APIResponse.RpcError.APPLICATION_ERROR).setRpcApplicationError(6);
            } else {
                if (req.getApiPackage().equals("memcache") || req.getApiPackage().equals("generate.same.val.as.memcache.unavailable")) {
                    ctx.finishWithAppError(9, "Pretend unavailable");
                    return;
                }
                if (req.getApiPackage().equals("generate.deadline.exceeded.error")) {
                    ctx.finishWithError("RPC", 4, 4, "Deadline exceeded");
                    return;
                }
                if (req.getApiPackage().equals("generate.cancelled.rpc")) {
                    ctx.finishWithError("generic", 1, 1, "Cancelled");
                    return;
                }
                if (req.getApiPackage().equals("generate.rpc.server.error")) {
                    ctx.finishWithError("RPC", 0, 0, "Server error");
                    return;
                }
                if (req.getApiPackage().equals("hang.forever")) {
                    return;
                }
                reply.setError(1);
            }
            ctx.finishWithResponse(reply.build());
        }

        public void disable() {
            throw new UnsupportedOperationException();
        }

        public void enable() {
            throw new UnsupportedOperationException();
        }

        public AnyRpcClientContext newClientContext() {
            return new MockRpcClientContext();
        }
    }

    private static enum Signal {
        CANCEL,
        INTERRUPT;

    }
}

