/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.SourcePb;
import com.google.apphosting.runtime.AppLogsWriter;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class AppLogsWriterTest {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private static final long SMALL_FLUSH = 8192L;
    private static final long STANDARD_FLUSH = 524288L;
    private static final int DEFAULT_MAX_LOG_LINE = 8192;
    private static final String LOG_BLOCK = Strings.repeat((String)"x", (int)8000);
    private static final long INVERSE_NANO = 1000000000L;
    @Mock
    private ApiProxy.Delegate<ApiProxy.Environment> delegate;
    @Mock
    private ApiProxy.Environment environment;
    private MutableUpResponse response;
    private static final boolean DEBUG_LOG_STRINGS = false;

    @Before
    public void setUp() throws Exception {
        ApiProxy.setDelegate(this.delegate);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.environment);
        this.response = new MutableUpResponse();
    }

    @After
    public void tearDown() throws Exception {
        this.delegate = null;
        this.environment = null;
        ApiProxy.setDelegate(null);
        ApiProxy.clearEnvironmentForCurrentThread();
        this.response = null;
    }

    @Test
    public void testAddRecord() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 8192, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate, this.environment});
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)this.response.getAppLog(0)).isEqualTo((Object)this.createLogLine("1"));
    }

    @Test
    public void testLongAddRecord() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 8192, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, AppLogsWriterTest.buildLongLogMessage(2000).trim()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate, this.environment});
        String prefix = "<continued from previous message>\n";
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)2);
        Truth.assertThat((String)this.response.getAppLog(0).getMessage().substring(0, 2)).isEqualTo((Object)"a0");
        Truth.assertThat((String)this.response.getAppLog(1).getMessage().substring(0, prefix.length() + 2)).isEqualTo((Object)(prefix + "a1"));
    }

    @Test
    public void testLongAddRecordLongMaxLogLine() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 16384, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, AppLogsWriterTest.buildLongLogMessage(2000).trim()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate, this.environment});
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
    }

    @Test
    public void testFlushDueToSize() throws Exception {
        ListenableFuture flushResponse = Futures.immediateFuture((Object)new byte[0]);
        ArgumentCaptor flushRequestBytes = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.delegate.makeAsyncCall((ApiProxy.Environment)ArgumentMatchers.eq((Object)this.environment), (String)ArgumentMatchers.eq((Object)"logservice"), (String)ArgumentMatchers.eq((Object)"Flush"), (byte[])flushRequestBytes.capture(), (ApiProxy.ApiConfig)ArgumentMatchers.notNull())).thenReturn((Object)flushResponse);
        AppLogsWriter writer = new AppLogsWriter(this.response, 8192L, 8192, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "1"));
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "2"));
        AppLogsPb.AppLogGroup.Builder group = AppLogsPb.AppLogGroup.newBuilder();
        LogServicePb.FlushRequest.Builder flushRequest = (LogServicePb.FlushRequest.Builder)LogServicePb.FlushRequest.newBuilder().mergeFrom((byte[])flushRequestBytes.getValue(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        group.mergeFrom(flushRequest.getLogs(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Integer)group.getLogLineCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)group.getLogLine(0)).isEqualTo((Object)this.createLogLine("1"));
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)this.response.getAppLog(0)).isEqualTo((Object)this.createLogLine("2"));
    }

    @Test
    public void testSecondFlushBlocksOnFirst() throws Exception {
        ListenableFuture flushResponse = Futures.immediateFuture((Object)new byte[0]);
        ArgumentCaptor flushRequestBytes = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.delegate.makeAsyncCall((ApiProxy.Environment)ArgumentMatchers.eq((Object)this.environment), (String)ArgumentMatchers.eq((Object)"logservice"), (String)ArgumentMatchers.eq((Object)"Flush"), (byte[])flushRequestBytes.capture(), (ApiProxy.ApiConfig)ArgumentMatchers.notNull())).thenReturn((Object)flushResponse);
        AppLogsWriter writer = new AppLogsWriter(this.response, 8192L, 8192, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "1"));
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "2"));
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "3"));
        Truth.assertThat((Iterable)flushRequestBytes.getAllValues()).hasSize(2);
        AppLogsPb.AppLogGroup.Builder group = AppLogsPb.AppLogGroup.newBuilder();
        LogServicePb.FlushRequest.Builder flushRequest = (LogServicePb.FlushRequest.Builder)LogServicePb.FlushRequest.newBuilder().mergeFrom((byte[])flushRequestBytes.getAllValues().get(0), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        group.mergeFrom(flushRequest.getLogs(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Integer)group.getLogLineCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)group.getLogLine(0)).isEqualTo((Object)this.createLogLine("1"));
        group = AppLogsPb.AppLogGroup.newBuilder();
        flushRequest = (LogServicePb.FlushRequest.Builder)LogServicePb.FlushRequest.newBuilder().mergeFrom((byte[])flushRequestBytes.getAllValues().get(1), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        group.mergeFrom(flushRequest.getLogs(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Integer)group.getLogLineCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)group.getLogLine(0)).isEqualTo((Object)this.createLogLine("2"));
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
        Truth.assertThat((Object)this.response.getAppLog(0)).isEqualTo((Object)this.createLogLine("3"));
    }

    @Test
    public void testFlushAndWaitDoesNotBlockAsyncCall() throws Exception {
        final SettableFuture settableFuture = SettableFuture.create();
        final CountDownLatch inGet = new CountDownLatch(1);
        AbstractFuture<byte[]> flushResponse = new AbstractFuture<byte[]>(){

            public final byte[] get() throws InterruptedException, ExecutionException {
                inGet.countDown();
                return (byte[])settableFuture.get();
            }
        };
        ArgumentCaptor flushRequestBytes = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.delegate.makeAsyncCall((ApiProxy.Environment)ArgumentMatchers.eq((Object)this.environment), (String)ArgumentMatchers.eq((Object)"logservice"), (String)ArgumentMatchers.eq((Object)"Flush"), (byte[])flushRequestBytes.capture(), (ApiProxy.ApiConfig)ArgumentMatchers.notNull())).thenReturn((Object)flushResponse);
        AppLogsWriter writer = new AppLogsWriter(this.response, 8192L, 8192, 0);
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, "1"));
        Future<?> flushAndWaitFuture = Executors.newSingleThreadExecutor().submit(() -> {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.environment);
            writer.flushAndWait();
        });
        inGet.await();
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, "2"));
        Truth.assertThat((Iterable)flushRequestBytes.getAllValues()).hasSize(1);
        AppLogsPb.AppLogGroup.Builder group = AppLogsPb.AppLogGroup.newBuilder();
        LogServicePb.FlushRequest.Builder flushRequest = (LogServicePb.FlushRequest.Builder)LogServicePb.FlushRequest.newBuilder().mergeFrom((byte[])flushRequestBytes.getValue(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        group.mergeFrom(flushRequest.getLogs(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Integer)group.getLogLineCount()).isEqualTo((Object)1);
        Truth.assertThat((String)group.getLogLine(0).getMessage()).isEqualTo((Object)"1");
        Truth.assertThat((Boolean)flushAndWaitFuture.isDone()).isFalse();
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
        Truth.assertThat((String)this.response.getAppLog(0).getMessage()).isEqualTo((Object)"2");
        settableFuture.set((Object)new byte[0]);
        flushAndWaitFuture.get();
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)1);
        Truth.assertThat((String)this.response.getAppLog(0).getMessage()).isEqualTo((Object)"2");
    }

    @Test
    public void testFlushDueToTime() throws Exception {
        ListenableFuture flushResponse = Futures.immediateFuture((Object)new byte[0]);
        ArgumentCaptor flushRequestBytes = ArgumentCaptor.forClass(byte[].class);
        Ticker ticker = (Ticker)Mockito.mock(Ticker.class);
        Mockito.when((Object)this.delegate.makeAsyncCall((ApiProxy.Environment)ArgumentMatchers.eq((Object)this.environment), (String)ArgumentMatchers.eq((Object)"logservice"), (String)ArgumentMatchers.eq((Object)"Flush"), (byte[])flushRequestBytes.capture(), (ApiProxy.ApiConfig)ArgumentMatchers.notNull())).thenReturn((Object)flushResponse);
        Mockito.when((Object)ticker.read()).thenReturn((Object)0L).thenReturn((Object)1000000000L).thenReturn((Object)60000000000L);
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 8192, 60);
        writer.setStopwatch(Stopwatch.createUnstarted((Ticker)ticker));
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "1"));
        writer.addLogRecordAndMaybeFlush(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.info, 0L, LOG_BLOCK + "2"));
        AppLogsPb.AppLogGroup.Builder group = AppLogsPb.AppLogGroup.newBuilder();
        LogServicePb.FlushRequest.Builder flushRequest = (LogServicePb.FlushRequest.Builder)LogServicePb.FlushRequest.newBuilder().mergeFrom((byte[])flushRequestBytes.getValue(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        group.mergeFrom(flushRequest.getLogs(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        Truth.assertThat((Integer)group.getLogLineCount()).isEqualTo((Object)2);
        Truth.assertThat((Object)group.getLogLine(0)).isEqualTo((Object)this.createLogLine("1"));
        Truth.assertThat((Object)group.getLogLine(1)).isEqualTo((Object)this.createLogLine("2"));
        Truth.assertThat((Integer)this.response.getAppLogCount()).isEqualTo((Object)0);
    }

    private AppLogsPb.AppLogLine createLogLine(String suffix) {
        return AppLogsPb.AppLogLine.newBuilder().setLevel(1L).setTimestampUsec(0L).setMessage(LOG_BLOCK + suffix).build();
    }

    void runTestLogMessageSplit(int maxLogLine) throws Exception {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, maxLogLine, 0);
        for (int i = 1; i <= 5; ++i) {
            String message = AppLogsWriterTest.buildLongLogMessage(i * 1000).trim();
            ApiProxy.LogRecord record = new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.debug, 0L, message);
            List list = writer.split(record);
            AppLogsWriterTest.debugPrintln("message length = " + message.length());
            int listLength = list.size();
            if (message.length() <= maxLogLine) {
                Truth.assertThat((Integer)listLength).isEqualTo((Object)1);
            }
            int cumulativeLength = 0;
            int recordIndex = -1;
            for (ApiProxy.LogRecord rec : list) {
                ++recordIndex;
                String s = rec.getMessage();
                int length = s.length();
                AppLogsWriterTest.debugPrintln(s);
                AppLogsWriterTest.debugPrintln("-------------------------------------------");
                AppLogsWriterTest.debugPrintln("Above part's length: " + length);
                AppLogsWriterTest.debugPrintln("-------------------------------------------");
                Truth.assertThat((Integer)s.length()).isAtMost((Comparable)Integer.valueOf(maxLogLine));
                if (recordIndex == listLength - 1) {
                    Truth.assertThat((String)s).endsWith("x");
                } else {
                    Truth.assertThat((String)s).endsWith("\n<continued in next message>");
                    s = s.substring(0, length - AppLogsWriter.LOG_CONTINUATION_SUFFIX_LENGTH);
                    Truth.assertThat((String)s).endsWith("x");
                }
                boolean removedSuffix = false;
                if (s.startsWith("<continued from previous message>\n")) {
                    s = s.substring(AppLogsWriter.LOG_CONTINUATION_PREFIX_LENGTH);
                    removedSuffix = true;
                }
                cumulativeLength += s.length();
                if (!removedSuffix) continue;
                ++cumulativeLength;
            }
            Truth.assertThat((Integer)cumulativeLength).isEqualTo((Object)message.length());
            AppLogsWriterTest.debugPrintln("=============================================================");
        }
    }

    @Test
    public void testLogMessageSplitStandardSize() throws Exception {
        this.runTestLogMessageSplit(8192);
    }

    @Test
    public void testLogMessageSplitStandardLong() throws Exception {
        this.runTestLogMessageSplit(16384);
    }

    @Test
    public void testLogMessageSplitStandardShort() throws Exception {
        this.runTestLogMessageSplit(4096);
    }

    @Test
    public void testLogMessageSplitWithSurrogates() throws Exception {
        int maxLogLine = 1024;
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, maxLogLine, 0);
        Truth.assertThat((Integer)writer.getMaxLogMessageLength()).isEqualTo((Object)maxLogLine);
        StringBuilder sb = new StringBuilder();
        sb.append('x');
        while (sb.length() < maxLogLine) {
            sb.appendCodePoint(119070);
        }
        Truth.assertThat((Integer)sb.length()).isGreaterThan((Comparable)Integer.valueOf(maxLogLine));
        int logCutLength = maxLogLine - AppLogsWriter.LOG_CONTINUATION_SUFFIX_LENGTH;
        Truth.assertThat((Integer)(logCutLength % 2)).isEqualTo((Object)0);
        ApiProxy.LogRecord record = new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.debug, 0L, sb.toString());
        List list = writer.split(record);
        String expectFirst = sb.substring(0, logCutLength - 1) + "\n<continued in next message>";
        String expectSecond = "<continued from previous message>\n" + sb.substring(logCutLength - 1);
        String actualFirst = ((ApiProxy.LogRecord)list.get(0)).getMessage();
        String actualSecond = ((ApiProxy.LogRecord)list.get(1)).getMessage();
        Truth.assertThat((Iterable)ImmutableList.of((Object)actualFirst, (Object)actualSecond)).containsExactly(new Object[]{expectFirst, expectSecond});
    }

    @Test
    public void testMinLength() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 512, 0);
        Truth.assertThat((Integer)writer.getMaxLogMessageLength()).isEqualTo((Object)1024);
        writer = new AppLogsWriter(this.response, 524288L, 2048, 0);
        Truth.assertThat((Integer)writer.getMaxLogMessageLength()).isEqualTo((Object)2048);
    }

    private static String buildLongLogMessage(int numBlocks) {
        Random random = new Random();
        StringBuilder builder = new StringBuilder(numBlocks * 8);
        for (int i = 0; i < numBlocks; ++i) {
            builder.append("a").append(String.format("%04d", i)).append("b");
            if (!((double)random.nextFloat() < 0.15)) continue;
            builder.append("x\n");
        }
        builder.append("a").append(String.format("%04d", numBlocks)).append("bx");
        return builder.toString();
    }

    @Test
    public void testPreserveLeadingSpaceAtSplit() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        StringBuilder messageBuilder = new StringBuilder();
        String context = "\tat package.class (filename:line#)";
        messageBuilder.append("Caused by: java.lang.RuntimeException: message\n");
        for (int i = 0; i < 100; ++i) {
            messageBuilder.append("\tat package.class (filename:line#)");
            messageBuilder.append('\n');
        }
        List list = writer.split(new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.debug, 0L, messageBuilder.toString()));
        Truth.assertWithMessage((String)"Splitting did not occur: message too short / max log message length too big").that(Integer.valueOf(list.size())).isGreaterThan((Comparable)Integer.valueOf(1));
        String[] lines = ((ApiProxy.LogRecord)list.get(1)).getMessage().split("\n");
        Truth.assertWithMessage((String)"Internal error: continuation prefix/suffix missing").that(Integer.valueOf(lines.length)).isGreaterThan((Comparable)Integer.valueOf(2));
        Truth.assertThat((String)(lines[0] + '\n')).isEqualTo((Object)"<continued from previous message>\n");
        Truth.assertThat((String)lines[1]).isEqualTo((Object)"\tat package.class (filename:line#)");
    }

    @Test
    public void testFastStackTrace() {
        TruthJUnit.assume().that(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()).isEqualTo((Object)"1.8");
        Truth.assertThat((Boolean)Throwables.lazyStackTraceIsLazy()).isTrue();
    }

    private static StackTraceElement makeFrame(String frameInfo) {
        List parts = Splitter.on((char)':').splitToList((CharSequence)frameInfo);
        if (parts.size() != 4) {
            throw new IllegalArgumentException();
        }
        return new StackTraceElement((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), Integer.parseInt((String)parts.get(3)));
    }

    @Test
    public void testSourceLocation1() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        ImmutableList stack = ImmutableList.of((Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.shared.intercept.java.util.logging.DefaultHandler:convertLogRecord:Yadayada.java:59"), (Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.shared.intercept.java.util.logging.DefaultHandler:publish:Yadayada.java:48"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:Yadayada.java:619"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:doLog:Yadayada.java:640"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:Yadayada.java:663"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:info:Yadayada.java:1181"), (Object)AppLogsWriterTest.makeFrame("com.google.shigeru.HelloAppEngineServlet:runLoggingTest:Yadayada.java:22"), (Object)AppLogsWriterTest.makeFrame("com.google.shigeru.HelloAppEngineServlet:doGet:Yadayada.java:17"), (Object)AppLogsWriterTest.makeFrame("javax.servlet.http.HttpServlet:service:Yadayada.java:617"), (Object)AppLogsWriterTest.makeFrame("javax.servlet.http.HttpServlet:service:Yadayada.java:717"), (Object)AppLogsWriterTest.makeFrame("org.mortbay.jetty.servlet.ServletHolder:handle:Yadayada.java:511"), (Object)AppLogsWriterTest.makeFrame("org.mortbay.jetty.servlet.ServletHandler$CachedChain:doFilter:Yadayada.java:1166"), (Object[])new StackTraceElement[]{AppLogsWriterTest.makeFrame("java.lang.Thread:run:Yadayada.java:724")});
        SourcePb.SourceLocation source = writer.getSourceLocationProto(AppLogsWriter.getTopUserStackFrame((List)stack));
        Truth.assertThat((String)source.getFunctionName()).isEqualTo((Object)"com.google.shigeru.HelloAppEngineServlet.runLoggingTest");
        Truth.assertThat((String)source.getFile()).isEqualTo((Object)"Yadayada.java");
        Truth.assertThat((Long)source.getLine()).isEqualTo((Object)22);
    }

    @Test
    public void testSourceLocation2() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        ImmutableList stack = ImmutableList.of((Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.shared.intercept.java.util.logging.DefaultHandler:convertLogRecord:Yadayada.java:59"), (Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.shared.intercept.java.util.logging.DefaultHandler:publish:Yadayada.java:48"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:Yadayada.java:619"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:doLog:Yadayada.java:640"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:Yadayada.java:663"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:info:Yadayada.java:1181"), (Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.shared.intercept.java.lang.reflect.C:run:Generated.java:1"), (Object)AppLogsWriterTest.makeFrame("com.google.shigeru.HelloAppEngineServlet:runLoggingTest:Yadayada.java:22"), (Object)AppLogsWriterTest.makeFrame("com.google.shigeru.HelloAppEngineServlet:doGet:Yadayada.java:17"), (Object)AppLogsWriterTest.makeFrame("javax.servlet.http.HttpServlet:service:Yadayada.java:617"), (Object)AppLogsWriterTest.makeFrame("javax.servlet.http.HttpServlet:service:Yadayada.java:717"), (Object)AppLogsWriterTest.makeFrame("org.mortbay.jetty.servlet.ServletHolder:handle:Yadayada.java:511"), (Object[])new StackTraceElement[]{AppLogsWriterTest.makeFrame("org.mortbay.jetty.servlet.ServletHandler$CachedChain:doFilter:Yadayada.java:1166"), AppLogsWriterTest.makeFrame("java.lang.Thread:run:Yadayada.java:724")});
        SourcePb.SourceLocation source = writer.getSourceLocationProto(AppLogsWriter.getTopUserStackFrame((List)stack));
        Truth.assertThat((String)source.getFunctionName()).isEqualTo((Object)"com.google.shigeru.HelloAppEngineServlet.runLoggingTest");
        Truth.assertThat((String)source.getFile()).isEqualTo((Object)"Yadayada.java");
        Truth.assertThat((Long)source.getLine()).isEqualTo((Object)22);
    }

    @Test
    public void testSourceLocation3() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        ImmutableList stack = ImmutableList.of((Object)AppLogsWriterTest.makeFrame("doesn.t.matter.because.haven.t.seen.log.yet.Class:method:file1.java:1"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:file2.java:2"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:info:file3.java:3"), (Object)AppLogsWriterTest.makeFrame("com.google.apphosting.runtime.security.anything.Class:method:file4.java:4"), (Object)AppLogsWriterTest.makeFrame("java.lang.invoke.Cl1:M1:F1.java:1"), (Object)AppLogsWriterTest.makeFrame("java.lang.reflect.Api:M1:F1.java:1"), (Object)AppLogsWriterTest.makeFrame("sun.reflect.C2:M1:F2.java:2"), (Object)AppLogsWriterTest.makeFrame("java.security.Checker:m:f.java:1"), (Object)AppLogsWriterTest.makeFrame("i.am.the.caller.Servlet:test:yada.java:2"));
        SourcePb.SourceLocation source = writer.getSourceLocationProto(AppLogsWriter.getTopUserStackFrame((List)stack));
        Truth.assertThat((String)source.getFunctionName()).isEqualTo((Object)"i.am.the.caller.Servlet.test");
        Truth.assertThat((String)source.getFile()).isEqualTo((Object)"yada.java");
        Truth.assertThat((Long)source.getLine()).isEqualTo((Object)2);
    }

    @Test
    public void testSourceLocation4() {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        ImmutableList stack = ImmutableList.of((Object)AppLogsWriterTest.makeFrame("doesn.t.matter.because.haven.t.seen.log.yet.Class:method:file1.java:1"), (Object)AppLogsWriterTest.makeFrame("java.util.logging.Logger:log:file2.java:2"), (Object)AppLogsWriterTest.makeFrame("java.security.Checker:m:f.java:1"));
        SourcePb.SourceLocation source = writer.getSourceLocationProto(AppLogsWriter.getTopUserStackFrame((List)stack));
        Truth.assertThat((Object)source).isNull();
    }

    @Test
    public void testSourceLocation_NoFileName() throws Exception {
        AppLogsWriter writer = new AppLogsWriter(this.response, 524288L, 1024, 0);
        StackTraceElement ste = new StackTraceElement("com.google.foo.ClassWithoutSource", "method", null, 23);
        SourcePb.SourceLocation source = writer.getSourceLocationProto(ste);
        Truth.assertThat((Object)source).isNull();
    }

    private static void debugPrintln(String s) {
    }
}

