/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.common.truth.Truth;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BackgroundRequestCoordinatorTest {
    private BackgroundRequestCoordinator coordinator;
    private String requestId;

    @Before
    public void setUp() throws Exception {
        this.coordinator = new BackgroundRequestCoordinator();
        this.requestId = UUID.randomUUID().toString();
    }

    private void waitAndAssert(Runnable runnable) {
        try {
            Truth.assertThat((Object)this.coordinator.waitForThreadStart(this.requestId, runnable, 5000L)).isSameInstanceAs((Object)Thread.currentThread());
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Test
    public void testExchangeSuccessful() throws TimeoutException, InterruptedException {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Thread thread = new Thread(() -> this.waitAndAssert(runnable));
        thread.start();
        Truth.assertThat((Object)this.coordinator.waitForUserRunnable(this.requestId, thread, 5000L)).isSameInstanceAs((Object)runnable);
        thread.join();
    }

    @Test
    public void testExchangeTimeout_waitForUserRunnable() throws InterruptedException {
        Assert.assertThrows(TimeoutException.class, () -> this.coordinator.waitForUserRunnable(this.requestId, new Thread(), 1000L));
    }

    @Test
    public void testExchangeTimeout_waitForThreadStart() throws InterruptedException {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Assert.assertThrows(TimeoutException.class, () -> this.coordinator.waitForThreadStart(this.requestId, runnable, 1000L));
    }
}

