/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ClassPathUtils;
import com.google.common.truth.Truth;
import java.io.File;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ClassPathUtilsTest {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private String runtimeLocation = null;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        System.clearProperty("classpath.runtime-impl");
        System.clearProperty("classpath.appengine-api-legacy");
        System.clearProperty("classpath.connector-j");
        this.runtimeLocation = this.temporaryFolder.getRoot().getAbsolutePath();
        System.setProperty("classpath.runtimebase", this.runtimeLocation);
    }

    private void createJava8Environment() throws Exception {
        this.temporaryFolder.newFile("java_runtime_launcher");
    }

    @Test
    public void verifyJava11PropertiesAreConfigured() throws Exception {
        ClassPathUtils cpu = new ClassPathUtils();
        Truth.assertThat((Object[])cpu.getConnectorJUrls()).hasLength(0);
        Truth.assertThat((String)System.getProperty("classpath.runtime-impl")).isEqualTo((Object)(this.runtimeLocation + "/runtime-impl.jar"));
        Truth.assertThat((String)System.getProperty("classpath.runtime-shared")).isEqualTo((Object)(this.runtimeLocation + "/runtime-shared.jar"));
        Truth.assertThat((String)System.getProperty("classpath.connector-j")).isNull();
        Truth.assertThat((String)cpu.getFrozenApiJar().getAbsolutePath()).isEqualTo((Object)(this.runtimeLocation + "/appengine-api-1.0-sdk.jar"));
    }

    @Test
    public void verifyMavenJarsPropertiesAreConfigured() throws Exception {
        this.createJava8Environment();
        ClassPathUtils cpu = new ClassPathUtils(new File("/my_app_root"));
        Truth.assertThat((Object[])cpu.getConnectorJUrls()).hasLength(1);
        Truth.assertThat((String)System.getProperty("classpath.runtime-impl")).isEqualTo((Object)(this.runtimeLocation + "/jars/runtime-impl.jar" + PATH_SEPARATOR + this.runtimeLocation + "/frozen_debugger.jar"));
        Truth.assertThat((String)System.getProperty("classpath.runtime-shared")).isEqualTo((Object)(this.runtimeLocation + "/jars/runtime-shared.jar"));
        Truth.assertThat((String)System.getProperty("classpath.connector-j")).isEqualTo((Object)(this.runtimeLocation + "/jdbc-mysql-connector.jar"));
        Truth.assertThat((String)cpu.getFrozenApiJar().getAbsolutePath()).isEqualTo((Object)("/my_app_root" + this.runtimeLocation + "/appengine-api.jar"));
        Truth.assertThat((String)System.getProperty("classpath.appengine-api-legacy")).isEqualTo((Object)(this.runtimeLocation + "/jars/appengine-api-legacy.jar"));
        Truth.assertThat((String)cpu.getAppengineApiLegacyJar().getAbsolutePath()).isEqualTo((Object)("/my_app_root" + this.runtimeLocation + "/jars/appengine-api-legacy.jar"));
    }
}

