/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.ClonePb;
import com.google.apphosting.base.protos.GitSourceContext;
import com.google.apphosting.base.protos.ModelClonePb;
import com.google.apphosting.base.protos.SourceContext;
import com.google.apphosting.runtime.ApiDeadlineOracle;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.CloneControllerImpl;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.JavaRuntime;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RuntimeLogSink;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.test.MockAnyRpcServerContext;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class CloneControllerImplTest {
    private static final double API_DEADLINE = 10.0;
    private static final Duration RPC_DEADLINE = Duration.ofSeconds(3L);
    private static final long MAX_RUNTIME_LOG_PER_REQUEST = 0x2EE000L;
    private static final long HARD_DEADLINE_DELAY = 250L;
    private static final long SOFT_DEADLINE_DELAY = 750L;
    private static final int HSPERFDATA_SIZE = 32768;
    private static final int FAKE_HSPERFDATA_SIZE = 100;
    private static final long CYCLES_PER_SECOND = 2333414000L;
    private final CloudDebuggerAgentWrapper cloudDebuggerAgent = (CloudDebuggerAgentWrapper)Mockito.mock(CloudDebuggerAgentWrapper.class);
    private final JavaRuntime javaRuntime = (JavaRuntime)Mockito.mock(JavaRuntime.class);
    private final AppVersion appVersion = (AppVersion)Mockito.mock(AppVersion.class);
    private final SourceContext sourceContext = SourceContext.newBuilder().setGit(GitSourceContext.newBuilder().setUrl("http://foo/bar")).build();

    @Before
    public void setUp() {
        Mockito.when((Object)this.javaRuntime.findAppVersion("app1", "1.1")).thenReturn((Object)this.appVersion);
        Mockito.when((Object)this.appVersion.getSourceContext()).thenReturn((Object)this.sourceContext);
    }

    @Test
    public void testPerformanceDataDisabled() {
        CloneControllerImpl cloneController = this.createCloneController(null);
        MockAnyRpcServerContext rpc = this.createRpc();
        cloneController.getPerformanceData((AnyRpcServerContext)rpc, ModelClonePb.PerformanceDataRequest.getDefaultInstance());
        ClonePb.PerformanceData data = (ClonePb.PerformanceData)rpc.assertSuccess();
        Truth.assertThat((Integer)data.getEntriesCount()).isEqualTo((Object)0);
    }

    @Test
    public void testPerformanceDataEnabled() {
        byte[] fakePerformanceData = new byte[100];
        for (int i = 0; i < 100; ++i) {
            fakePerformanceData[i] = (byte)i;
        }
        ByteBuffer perfData = ByteBuffer.wrap(fakePerformanceData).order(ByteOrder.LITTLE_ENDIAN);
        CloneControllerImpl cloneController = this.createCloneController(perfData);
        MockAnyRpcServerContext rpc = this.createRpc();
        cloneController.getPerformanceData((AnyRpcServerContext)rpc, ModelClonePb.PerformanceDataRequest.getDefaultInstance());
        ClonePb.PerformanceData data = (ClonePb.PerformanceData)rpc.assertSuccess();
        Truth.assertThat((Integer)data.getEntriesCount()).isEqualTo((Object)1);
        ClonePb.PerformanceData.Entry entry = data.getEntries(0);
        Truth.assertThat((Comparable)entry.getFormat()).isEqualTo((Object)ClonePb.PerformanceData.Format.JAVA_HOTSPOT_HSPERFDATA);
        byte[] payload = entry.getPayload().toByteArray();
        Truth.assertThat((byte[])payload).isEqualTo((Object)fakePerformanceData);
    }

    @Test
    public void testPerformanceDataEnabledAgainstRealPerfData() throws Exception {
        byte[] perfData;
        try (InputStream in = this.getClass().getResourceAsStream("hsperf.data");){
            perfData = ByteStreams.toByteArray((InputStream)in);
        }
        ByteBuffer realPerformanceData = ByteBuffer.wrap(perfData);
        CloneControllerImpl cloneController = this.createCloneController(realPerformanceData);
        MockAnyRpcServerContext rpc = this.createRpc();
        cloneController.getPerformanceData((AnyRpcServerContext)rpc, ModelClonePb.PerformanceDataRequest.getDefaultInstance());
        ClonePb.PerformanceData data = (ClonePb.PerformanceData)rpc.assertSuccess();
        Truth.assertThat((Integer)data.getEntriesCount()).isEqualTo((Object)1);
        ClonePb.PerformanceData.Entry entry = data.getEntries(0);
        Truth.assertThat((Comparable)entry.getFormat()).isEqualTo((Object)ClonePb.PerformanceData.Format.JAVA_HOTSPOT_HSPERFDATA);
        byte[] payload = entry.getPayload().toByteArray();
        Truth.assertThat((byte[])payload).hasLength(32768);
        Truth.assertThat((byte[])Arrays.copyOf(payload, 4)).isEqualTo((Object)new byte[]{-54, -2, -64, -64});
    }

    @Test
    public void testUpdateActiveBreakpoints() {
        CloneControllerImpl cloneController = this.createCloneController(null);
        MockAnyRpcServerContext rpc = this.createRpc();
        cloneController.updateActiveBreakpoints((AnyRpcServerContext)rpc, ClonePb.CloudDebuggerBreakpoints.getDefaultInstance());
        rpc.assertSuccess();
        ((CloudDebuggerAgentWrapper)Mockito.verify((Object)this.cloudDebuggerAgent)).setActiveBreakpoints((byte[][])ArgumentMatchers.any(byte[][].class));
        ((CloudDebuggerAgentWrapper)Mockito.verify((Object)this.cloudDebuggerAgent)).dequeueBreakpointUpdates();
    }

    @Test
    public void testGetDebuggeeInfoRpc() {
        CloneControllerImpl cloneController = this.createCloneController(null);
        MockAnyRpcServerContext rpc = this.createRpc();
        ClonePb.DebuggeeInfoRequest request1 = ClonePb.DebuggeeInfoRequest.newBuilder().setAppVersionId("app1/1.1").build();
        cloneController.getDebuggeeInfo((AnyRpcServerContext)rpc, request1);
        ClonePb.DebuggeeInfoResponse response = (ClonePb.DebuggeeInfoResponse)rpc.assertSuccess();
        Truth.assertThat((Boolean)response.hasDebuggeeInfo()).isTrue();
        Truth.assertThat((Boolean)response.getDebuggeeInfo().hasSourceContext()).isTrue();
        Truth.assertThat((Comparable)response.getDebuggeeInfo().getSourceContext().getContextCase()).isEqualTo((Object)SourceContext.ContextCase.GIT);
        Truth.assertThat((String)response.getDebuggeeInfo().getSourceContext().getGit().getUrl()).isEqualTo((Object)"http://foo/bar");
        rpc = this.createRpc();
        ClonePb.DebuggeeInfoRequest request2 = ClonePb.DebuggeeInfoRequest.newBuilder().setAppVersionId("someApp/someVersion").build();
        cloneController.getDebuggeeInfo((AnyRpcServerContext)rpc, request2);
        response = (ClonePb.DebuggeeInfoResponse)rpc.assertSuccess();
        Truth.assertThat((Boolean)response.hasDebuggeeInfo()).isFalse();
        rpc = this.createRpc();
        ClonePb.DebuggeeInfoRequest request3 = ClonePb.DebuggeeInfoRequest.newBuilder().setAppVersionId("Invalid+App-Version?!@").build();
        cloneController.getDebuggeeInfo((AnyRpcServerContext)rpc, request3);
        response = (ClonePb.DebuggeeInfoResponse)rpc.assertSuccess();
        Truth.assertThat((Boolean)response.hasDebuggeeInfo()).isFalse();
    }

    @Test
    public void testGetDebuggeeInfo() {
        CloneControllerImpl cloneController = this.createCloneController(null);
        SourceContext sourceContext = cloneController.getSourceContext("app1", "1.1");
        Truth.assertThat((Comparable)sourceContext.getContextCase()).isEqualTo((Object)SourceContext.ContextCase.GIT);
        Truth.assertThat((String)sourceContext.getGit().getUrl()).isEqualTo((Object)"http://foo/bar");
        sourceContext = cloneController.getSourceContext("someApp", "someVersion");
        Truth.assertThat((Object)sourceContext).isNull();
    }

    private CloneControllerImpl createCloneController(ByteBuffer hotspotPerformanceData) {
        return new CloneControllerImpl((CloneControllerImpl.Callback)new JavaRuntime.CloneControllerImplCallback(this.javaRuntime), new ApiDeadlineOracle.Builder().initDeadlineMap(10.0, "", 0.0, "").initOfflineDeadlineMap(10.0, "", 0.0, "").build(), this.createRequestManager(false, true, false), hotspotPerformanceData, this.cloudDebuggerAgent);
    }

    private RequestManager createRequestManager(boolean disableTimers, boolean terminateClones, boolean interruptOnSoftDeadline) {
        return RequestManager.builder().setSoftDeadlineDelay(750L).setHardDeadlineDelay(250L).setDisableDeadlineTimers(disableTimers).setRuntimeLogSink(Optional.of(new RuntimeLogSink(0x2EE000L))).setApiProxyImpl(ApiProxyImpl.builder().build()).setMaxOutstandingApiRpcs(10).setThreadStopTerminatesClone(terminateClones).setInterruptFirstOnSoftDeadline(interruptOnSoftDeadline).setCloudDebuggerAgent(this.cloudDebuggerAgent).setEnableCloudDebugger(true).setCyclesPerSecond(2333414000L).setWaitForDaemonRequestThreads(true).build();
    }

    private MockAnyRpcServerContext createRpc() {
        return new MockAnyRpcServerContext(RPC_DEADLINE);
    }
}

