/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.FileEncodingSetter;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileEncodingSetterTest {
    @Before
    public void setUp() {
        FileEncodingSetter.overwriteDefaultCharset((Charset)StandardCharsets.UTF_16);
    }

    @Test
    public void setUtf8() throws IOException {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("appengine.file.encoding", "UTF-8");
        FileEncodingSetter.set(sysProps);
        Truth.assertThat(sysProps).containsEntry((Object)"file.encoding", (Object)"UTF-8");
        Truth.assertThat((Comparable)Charset.defaultCharset()).isEqualTo((Object)StandardCharsets.UTF_8);
    }

    @Test
    public void setUsAscii() throws IOException {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("appengine.file.encoding", "US-ASCII");
        FileEncodingSetter.set(sysProps);
        Truth.assertThat(sysProps).containsEntry((Object)"file.encoding", (Object)"US-ASCII");
        Truth.assertThat((Comparable)Charset.defaultCharset()).isEqualTo((Object)StandardCharsets.US_ASCII);
    }

    @Test
    public void setAnsi() throws IOException {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("appengine.file.encoding", "ANSI_X3.4-1968");
        FileEncodingSetter.set(sysProps);
        Truth.assertThat(sysProps).containsEntry((Object)"file.encoding", (Object)"ANSI_X3.4-1968");
        Truth.assertThat((Comparable)Charset.defaultCharset()).isEqualTo((Object)StandardCharsets.US_ASCII);
    }

    @Test
    public void setBogus() throws IOException {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("appengine.file.encoding", "bogus-charset");
        FileEncodingSetter.set(sysProps);
        Truth.assertThat(sysProps).doesNotContainKey((Object)"file.encoding");
        Truth.assertThat((Comparable)Charset.defaultCharset()).isEqualTo((Object)StandardCharsets.UTF_16);
    }
}

