/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.HttpCompression;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.common.base.Utf8;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpCompressionTest {
    private RuntimePb.UPRequest upRequest;
    private MutableUpResponse upResponse;
    boolean alreadyCompressed;
    String userAgent;
    String acceptEncoding;
    String contentType;
    String responseBody;
    boolean noResponse;

    @Before
    public void setUp() throws Exception {
        this.upRequest = RuntimePb.UPRequest.getDefaultInstance();
        this.upResponse = new MutableUpResponse();
        this.alreadyCompressed = false;
        this.userAgent = "Mozilla/5.0";
        this.acceptEncoding = "gzip";
        this.contentType = "text/plain";
        this.responseBody = "foo";
        this.noResponse = false;
        this.upResponse.setError(0);
    }

    private byte[] compressAndAssertRoundTrip(String input) throws IOException {
        byte[] compressedBytes = HttpCompression.compress((ByteString)ByteString.copyFromUtf8((String)input));
        byte[] decompressedBytes = HttpCompressionTest.uncompress(compressedBytes);
        Truth.assertThat((byte[])decompressedBytes).hasLength(Utf8.encodedLength((CharSequence)input));
        return compressedBytes;
    }

    private static byte[] uncompress(byte[] content) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(new ByteArrayInputStream(content));
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)zis);
            return byArray;
        }
        finally {
            Closeables.closeQuietly((InputStream)zis);
        }
    }

    private void initResponse() {
        RuntimePb.UPRequest.Builder upRequestBuilder = this.upRequest.toBuilder();
        upRequestBuilder.getRequestBuilder().addHeaders(this.header("user-agent", this.userAgent));
        upRequestBuilder.addRuntimeHeaders(this.header("accept-encoding", this.acceptEncoding));
        this.upRequest = upRequestBuilder.buildPartial();
        this.upResponse.addHttpOutputHeaders(this.header("content-type", this.contentType));
        this.upResponse.setHttpResponseCodeAndResponse(200, this.responseBody);
        if (this.noResponse) {
            this.upResponse.clearHttpResponse();
        }
    }

    private void attemptCompression(boolean expectCompression) throws IOException {
        this.attemptCompression(expectCompression, false);
    }

    private void attemptCompression(boolean expectCompression, boolean uncompressForClient) throws IOException {
        this.initResponse();
        HttpCompression compression = new HttpCompression();
        Truth.assertThat((Boolean)this.upResponse.isInitialized()).isTrue();
        Truth.assertThat((Boolean)compression.attemptCompression(this.upRequest, this.upResponse)).isEqualTo((Object)expectCompression);
        Truth.assertThat((Boolean)this.upResponse.isInitialized()).isTrue();
        if (expectCompression) {
            byte[] compressed = HttpCompression.compress((ByteString)ByteString.copyFromUtf8((String)this.responseBody));
            Truth.assertThat((byte[])this.upResponse.getHttpResponse().getResponse().toByteArray()).isEqualTo((Object)compressed);
            String contentEncoding = compression.getHeader(this.upResponse.getRuntimeHeadersList(), "Content-Encoding");
            Truth.assertThat((Boolean)compression.isContentGzipEncoded(contentEncoding)).isTrue();
            Truth.assertThat((String)contentEncoding).isEqualTo((Object)"gzip");
            String noCompress = compression.getHeader(this.upResponse.getRuntimeHeadersList(), "X-Google-NoCompress");
            Truth.assertThat((String)noCompress).isNull();
            Truth.assertThat((Long)this.upResponse.getHttpResponse().getUncompressedSize()).isEqualTo((Object)this.responseBody.length());
        } else if (!this.alreadyCompressed) {
            Truth.assertThat((String)this.upResponse.getHttpResponse().getResponse().toStringUtf8()).isEqualTo((Object)this.responseBody);
            String contentEncoding = compression.getHeader(this.upResponse.getRuntimeHeadersList(), "Content-Encoding");
            Truth.assertThat((String)contentEncoding).isNotEqualTo((Object)"gzip");
            Truth.assertThat((Boolean)this.upResponse.getHttpResponse().hasUncompressedSize()).isFalse();
        }
        Truth.assertThat((Boolean)this.upResponse.getHttpResponse().getUncompressForClient()).isEqualTo((Object)uncompressForClient);
    }

    private void expectCompression(boolean expectCompression) throws IOException {
        this.shouldCompress(expectCompression);
        this.attemptCompression(expectCompression);
    }

    private void shouldCompress(boolean shouldCompress) {
        this.shouldCompress(shouldCompress, false);
    }

    private void shouldCompress(boolean shouldCompress, boolean compressForGfe) {
        HttpCompression compression = new HttpCompression();
        Truth.assertThat((Boolean)compression.shouldCompress(compressForGfe, this.userAgent, this.acceptEncoding, this.contentType)).isEqualTo((Object)shouldCompress);
    }

    @Test
    public void testShortString() throws IOException {
        this.compressAndAssertRoundTrip("short string");
    }

    @Test
    public void testLongStringCompressesWell() throws IOException {
        String input = "something that should compress reasonably well something that should compress reasonably well something that should compress reasonably well something that should compress reasonably well ";
        byte[] output = this.compressAndAssertRoundTrip(input);
        Truth.assertThat((Integer)output.length).isLessThan((Comparable)Integer.valueOf(input.length()));
    }

    @Test
    public void testTrivial() throws IOException {
        this.expectCompression(true);
    }

    @Test
    public void testEmptyResponse() throws IOException {
        this.responseBody = "";
        this.shouldCompress(true);
        this.attemptCompression(false);
    }

    @Test
    public void testNoResponse() throws IOException {
        this.responseBody = "";
        this.noResponse = true;
        this.shouldCompress(true);
        this.attemptCompression(false);
    }

    @Test
    public void testShortResponse() throws IOException {
        this.expectCompression(true);
        Truth.assertThat((Integer)this.responseBody.length()).isLessThan((Comparable)Integer.valueOf(this.upResponse.getHttpResponse().getResponse().size()));
    }

    @Test
    public void testLongResponse() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5000; ++i) {
            sb.append("a");
        }
        this.responseBody = sb.toString();
        this.expectCompression(true);
        Truth.assertThat((Integer)this.responseBody.length()).isGreaterThan((Comparable)Integer.valueOf(this.upResponse.getHttpResponse().getResponse().size()));
    }

    @Test
    public void testEmptyUserAgent() throws IOException {
        this.userAgent = "";
        this.expectCompression(false);
    }

    @Test
    public void testBadUserAgent() throws IOException {
        this.userAgent = "unrecognized";
        this.expectCompression(false);
    }

    @Test
    public void testBadUserAgent_gzipGfe() throws IOException {
        this.userAgent = "unrecognized,gzip(gfe)";
        this.shouldCompress(false, false);
        this.shouldCompress(true, true);
        this.attemptCompression(true, true);
    }

    @Test
    public void testUserAgent_gzipGfe_attemptCompression() throws IOException {
        this.userAgent = "unrecognized";
        this.attemptCompression(false, false);
        RuntimePb.UPRequest.Builder upRequestBuilder = this.upRequest.toBuilder();
        upRequestBuilder.getRequestBuilder().setGzipGfe(true);
        this.upRequest = upRequestBuilder.buildPartial();
        this.attemptCompression(true, true);
    }

    @Test
    public void testUserAgent_gzip_gzipGfe() throws IOException {
        this.userAgent = "Foobar/1.2.3 (iPhone7,2; iOS 9.3.1; gzip),gzip(gfe)";
        this.shouldCompress(true, true);
        this.attemptCompression(true);
    }

    @Test
    public void testUserAgent_acceptEncoding_gzip_gzipGfe() throws IOException {
        this.acceptEncoding = "gzip,gzip(gfe)";
        this.userAgent = "Foobar/1.2.3 (iPhone7,2; iOS 9.3.1; gzip),gzip(gfe)";
        this.shouldCompress(true, true);
        this.attemptCompression(true);
    }

    @Test
    public void testUserAgent_acceptEncoding_gzip_gzipGfe_json() throws IOException {
        this.contentType = "application/json; charset=UTF-8";
        this.acceptEncoding = "gzip,gzip(gfe)";
        this.userAgent = "Foobar/1.2.3 (iPhone7,2; iOS 9.3.1; gzip),gzip(gfe)";
        this.shouldCompress(true, true);
        this.attemptCompression(true, false);
    }

    @Test
    public void testEmptyAcceptEncoding() throws IOException {
        this.acceptEncoding = "";
        this.expectCompression(false);
    }

    @Test
    public void testBadAcceptEncoding() throws IOException {
        this.acceptEncoding = "unrecognized";
        this.expectCompression(false);
    }

    @Test
    public void testEmptyContentType() throws IOException {
        this.contentType = "";
        this.expectCompression(false);
    }

    @Test
    public void testBadContentType() throws IOException {
        this.contentType = "unrecognized";
        this.expectCompression(false);
    }

    @Test
    public void testBadAcceptEncoding_gzipGfe() throws IOException {
        this.userAgent = "gzip(gfe)";
        this.contentType = "unrecognized";
        this.shouldCompress(false, false);
        this.shouldCompress(false, true);
        this.attemptCompression(false, false);
    }

    @Test
    public void testJPEGNotCompressed() throws IOException {
        this.contentType = "image/jpeg";
        this.expectCompression(false);
    }

    @Test
    public void testGIFNotCompressed() throws IOException {
        this.contentType = "image/gif";
        this.expectCompression(false);
    }

    @Test
    public void testAlreadyCompressed() throws IOException {
        this.upResponse.addRuntimeHeaders(this.header("content-encoding", "gzip"));
        this.shouldCompress(true);
        this.alreadyCompressed = true;
        this.attemptCompression(false);
        Truth.assertThat((String)this.upResponse.getHttpResponse().getResponse().toStringUtf8()).isEqualTo((Object)this.responseBody);
    }

    private HttpPb.ParsedHttpHeader.Builder header(String key, String value) {
        return HttpPb.ParsedHttpHeader.newBuilder().setKey(key).setValue(value);
    }
}

