/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.apphosting.runtime.JavaRuntimeParams;
import com.google.apphosting.runtime.ParameterFactory;
import com.google.apphosting.runtime.ServletEngineAdapter;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ImmutableTypeToInstanceMap;
import com.google.common.reflect.TypeToInstanceMap;
import com.google.common.reflect.TypeToken;
import com.google.common.truth.Expect;
import com.google.common.truth.Truth;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JavaRuntimeParamsTest {
    @Rule
    public Expect expect = Expect.create();
    private static final Converter<String, String> LOWER_UNDERSCORE_TO_LOWER_CAMEL = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
    private static final Converter<String, String> LOWER_UNDERSCORE_TO_UPPER_CAMEL = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL);
    private static final TypeToInstanceMap<Object> ARBITRARY_VALUES = ImmutableTypeToInstanceMap.builder().put((TypeToken)new TypeToken<Class<? extends ServletEngineAdapter>>(){}, FakeServletEngineAdapter.class).put(Integer.TYPE, (Object)23).put(Long.TYPE, (Object)5L).put(Double.TYPE, (Object)17.5).put(String.class, (Object)"flibbertigibbet").build();

    @Test
    public void testSomeDefaults() {
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])new String[0]);
        Truth.assertThat((String)params.getAppengineReleaseName()).isEqualTo((Object)"unknown");
    }

    @Test
    public void testEqualsSeparator() {
        String[] args = new String[]{"--application_root=ROOT"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((String)params.getApplicationRoot()).isEqualTo((Object)"ROOT");
    }

    @Test
    public void testBooleanDefaultTrue() {
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])new String[0]);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedFalse() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=false"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isFalse();
    }

    @Test
    public void testBooleanTrueCaseInsensitive() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=tRuE"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
    }

    @Test
    public void testBooleanFalseCaseInsensitive() {
        String[] args = new String[]{"--thread_stop_terminates_clone=fAlSe"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getThreadStopTerminatesClone()).isFalse();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedOne() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=1"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedZero() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=0"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isFalse();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedYes() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=yes"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedNo() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=no"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isFalse();
    }

    @Test
    public void testBooleanDefaultTrueSpecifiedInvalid() {
        String[] args = new String[]{"--log_jetty_exceptions_to_app_logs=invalid"};
        try {
            JavaRuntimeParams.parseArgs((String[])args);
            Assert.fail((String)"Invalid boolean parameters should be rejected");
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    @Test
    public void testBooleanNoParameter() {
        String[] args = new String[]{"--nolog_jetty_exceptions_to_app_logs"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isFalse();
        String[] args1 = new String[]{"--log_jetty_exceptions_to_app_logs"};
        params = JavaRuntimeParams.parseArgs((String[])args1);
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
    }

    @Test
    public void testNonexistentBooleanParamIgnored() {
        String[] args = new String[]{"--enable_xyz", "--noenable_abc"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Iterable)params.getUnknownParams()).containsExactly(new Object[]{"--enable_xyz", "--noenable_abc"}).inOrder();
    }

    @Test
    public void testBooleanParamsArityIsOne() {
        for (Field field : JavaRuntimeParams.class.getDeclaredFields()) {
            Class<?> fieldType;
            Parameter param = field.getAnnotation(Parameter.class);
            if (param == null || (fieldType = field.getType()) != Boolean.TYPE && fieldType != Boolean.class) continue;
            Truth.assertWithMessage((String)("Boolean param " + param.names()[0] + " must have arity=1")).that(Integer.valueOf(param.arity())).isEqualTo((Object)1);
        }
    }

    @Test
    public void testBooleanParamsDoNotStartWithNo() {
        for (Field field : JavaRuntimeParams.class.getDeclaredFields()) {
            Class<?> fieldType;
            Parameter param = field.getAnnotation(Parameter.class);
            if (param == null || (fieldType = field.getType()) != Boolean.TYPE && fieldType != Boolean.class) continue;
            for (String name : param.names()) {
                Truth.assertWithMessage((String)("Boolean param " + name + " cannot start with '--no'")).that(name).doesNotMatch("--no.*");
            }
        }
    }

    @Test
    public void testBooleanParamNamesShortForm() {
        ArrayList<String> input = new ArrayList<String>();
        ArrayList<String> expectedOutput = new ArrayList<String>();
        for (Field field : JavaRuntimeParams.class.getDeclaredFields()) {
            Parameter param = field.getAnnotation(Parameter.class);
            if (param == null || field.getType() != Boolean.TYPE) continue;
            for (String name : param.names()) {
                Truth.assertThat((String)name).startsWith("--");
                name = name.substring(2);
                input.add("--" + name);
                input.add("--no" + name);
                expectedOutput.add("--" + name + "=true");
                expectedOutput.add("--" + name + "=false");
            }
        }
        Truth.assertThat(input).isNotEmpty();
        ImmutableList expanded = ParameterFactory.expandBooleanParams(input, JavaRuntimeParams.class);
        Truth.assertThat((Iterable)expanded).isEqualTo(expectedOutput);
    }

    @Test
    public void testExpandBooleanParamsTrue() {
        ImmutableList args = ImmutableList.of((Object)"--flag1=a", (Object)"--log_jetty_exceptions_to_app_logs", (Object)"--flag3=b");
        ImmutableList params = ParameterFactory.expandBooleanParams((List)args, JavaRuntimeParams.class);
        Truth.assertThat((Iterable)params).containsExactly(new Object[]{"--flag1=a", "--log_jetty_exceptions_to_app_logs=true", "--flag3=b"}).inOrder();
    }

    @Test
    public void testExpandBooleanParamsFalse() {
        ImmutableList args = ImmutableList.of((Object)"--flag1=a", (Object)"--nolog_jetty_exceptions_to_app_logs", (Object)"--flag3=b");
        ImmutableList params = ParameterFactory.expandBooleanParams((List)args, JavaRuntimeParams.class);
        Truth.assertThat((Iterable)params).containsExactly(new Object[]{"--flag1=a", "--log_jetty_exceptions_to_app_logs=false", "--flag3=b"}).inOrder();
    }

    @Test
    public void testExpandBooleanParamsUnknownParams() {
        ImmutableList args = ImmutableList.of((Object)"--unknown1", (Object)"--nounknown2");
        ImmutableList params = ParameterFactory.expandBooleanParams((List)args, JavaRuntimeParams.class);
        Truth.assertThat((Iterable)params).containsExactly(new Object[]{"--unknown1", "--nounknown2"}).inOrder();
    }

    @Test
    public void testApplicationRootDefault() {
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])new String[0]);
        Truth.assertThat((String)params.getApplicationRoot()).isEqualTo((Object)"appdata");
    }

    @Test
    public void testApplicationRoot() {
        String[] args = new String[]{"--application_root=abc"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((String)params.getApplicationRoot()).isEqualTo((Object)"abc");
    }

    @Test
    public void testFixedApplicationPath() {
        String[] args = new String[]{"--fixed_application_path=abc"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((String)params.getFixedApplicationPath()).isEqualTo((Object)"abc");
    }

    @Test
    public void testUnknownArgumentsAllowed() {
        String[] args = new String[]{"--xyz=abc"};
        JavaRuntimeParams.parseArgs((String[])args);
    }

    @Test
    public void testDefaults() {
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])new String[0]);
        Truth.assertThat((String)params.getApplicationRoot()).isEqualTo((Object)"appdata");
        Truth.assertThat((Integer)params.getPort()).isEqualTo((Object)0);
        Truth.assertThat((String)params.getTrustedHost()).isEmpty();
        Truth.assertThat((Integer)params.getJavaHardDeadlineMs()).isEqualTo((Object)200);
        Truth.assertThat((Integer)params.getJavaSoftDeadlineMs()).isEqualTo((Object)600);
        Truth.assertThat((Double)params.getApiCallDeadline()).isEqualTo((Object)5.0);
        Truth.assertThat((Double)params.getMaxApiCallDeadline()).isEqualTo((Object)10.0);
        Truth.assertThat((String)params.getApiCallDeadlineMap()).isEmpty();
        Truth.assertThat((String)params.getMaxApiCallDeadlineMap()).isEmpty();
        Truth.assertThat((Double)params.getOfflineApiCallDeadline()).isEqualTo((Object)5.0);
        Truth.assertThat((Double)params.getMaxOfflineApiCallDeadline()).isEqualTo((Object)10.0);
        Truth.assertThat((String)params.getAppengineReleaseName()).isEqualTo((Object)"unknown");
        Truth.assertThat((Boolean)params.getLogJettyExceptionsToAppLogs()).isTrue();
        Truth.assertThat((String)params.getExternalDatacenterName()).isNull();
        Truth.assertThat((Integer)params.getCloneMaxOutstandingApiRpcs()).isEqualTo((Object)100);
        Truth.assertThat((Boolean)params.getThreadStopTerminatesClone()).isTrue();
        Truth.assertThat((Long)params.getByteCountBeforeFlushing()).isEqualTo((Object)102400L);
        Truth.assertThat((Integer)params.getMaxLogLineSize()).isEqualTo((Object)16384);
        Truth.assertThat((Integer)params.getMaxLogFlushSeconds()).isEqualTo((Object)60);
        Truth.assertThat((Boolean)params.getUseCloneControllerForDeadlines()).isFalse();
        Truth.assertThat((Boolean)params.getRuntimeHttpCompression()).isFalse();
        Truth.assertThat((Long)params.getMaxRuntimeLogPerRequest()).isEqualTo((Object)0x2EE000L);
        Truth.assertThat((Boolean)params.getEnableGaeCloudSqlJdbcConnectivity()).isFalse();
        Truth.assertThat((Boolean)params.getForceReadaheadOnCloudsqlSocket()).isFalse();
        Truth.assertThat((Boolean)params.getInterruptThreadsFirstOnSoftDeadline()).isFalse();
        Truth.assertThat((Boolean)params.getEnableHotspotPerformanceMetrics()).isFalse();
        Truth.assertThat((Boolean)params.getEnableCloudDebugger()).isFalse();
        Truth.assertThat((Boolean)params.getEnableCloudCpuProfiler()).isFalse();
        Truth.assertThat((Boolean)params.getEnableCloudHeapProfiler()).isFalse();
        Truth.assertThat((Boolean)params.getUrlfetchDeriveResponseMessage()).isTrue();
        Truth.assertThat((Long)params.getCyclesPerSecond()).isEqualTo((Object)0L);
        Truth.assertThat((Boolean)params.getMailFilenamePreventsInlining()).isFalse();
        Truth.assertThat((Boolean)params.getMailSupportExtendedAttachmentEncodings()).isFalse();
        Truth.assertThat((Boolean)params.getWaitForDaemonRequestThreads()).isTrue();
        Truth.assertThat((Boolean)params.getPollForNetwork()).isFalse();
        Truth.assertThat((Boolean)params.getDefaultToNativeUrlStreamHandler()).isFalse();
        Truth.assertThat((Boolean)params.getForceUrlfetchUrlStreamHandler()).isFalse();
        Truth.assertThat((Boolean)params.getEnableSynchronizedAppLogsWriter()).isTrue();
        Truth.assertThat((Boolean)params.getUseEnvVarsFromAppInfo()).isFalse();
        Truth.assertThat((String)params.getFixedApplicationPath()).isNull();
        Truth.assertThat((Boolean)params.getDisableApiCallLogging()).isFalse();
        Truth.assertThat((Boolean)params.getLogJsonToVarLog()).isFalse();
    }

    @Test
    public void testAllowDuplicateParams() {
        String[] args = new String[]{"--application_root=1", "--application_root=2"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((String)params.getApplicationRoot()).isEqualTo((Object)"2");
    }

    @Test
    public void testGetUnknownParams() {
        String[] args = new String[]{"--unknown1=xyz", "--application_root=abc", "--unknown2=xyz"};
        JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
        Truth.assertThat((Iterable)params.getUnknownParams()).containsExactly(new Object[]{"--unknown1=xyz", "--unknown2=xyz"}).inOrder();
    }

    @Test
    public void testExhaustive() {
        for (Field field : JavaRuntimeParams.class.getDeclaredFields()) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null || parameter.description().startsWith("Deprecated")) continue;
            String optionName = parameter.names()[0];
            Truth.assertThat((String)optionName).startsWith("--");
            String fieldName = (String)LOWER_UNDERSCORE_TO_LOWER_CAMEL.convert((Object)optionName.substring(2));
            this.expect.that(field.getName()).isEqualTo((Object)fieldName);
            String methodName = "get" + (String)LOWER_UNDERSCORE_TO_UPPER_CAMEL.convert((Object)optionName.substring(2));
            try {
                Method getter = JavaRuntimeParams.class.getDeclaredMethod(methodName, new Class[0]);
                this.checkOption(optionName, getter);
            }
            catch (ReflectiveOperationException e) {
                this.expect.withMessage("For option %s: %s", new Object[]{optionName, e}).fail();
            }
        }
    }

    private void checkOption(String optionName, Method getter) throws IllegalAccessException, InvocationTargetException {
        Type optionType = getter.getGenericReturnType();
        if (optionType.equals(Boolean.TYPE)) {
            this.checkBooleanOption(optionName, getter);
        } else {
            Object arbitraryValue = ARBITRARY_VALUES.get((Object)TypeToken.of((Type)optionType));
            if (arbitraryValue == null) {
                this.expect.withMessage("No default value for option %s of type %s", new Object[]{optionName, optionType}).fail();
            } else {
                String[] args = new String[]{optionName + "=" + this.string(arbitraryValue)};
                JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
                Object actualValue = getter.invoke((Object)params, new Object[0]);
                this.expect.withMessage(args[0]).that(actualValue).isEqualTo(arbitraryValue);
            }
        }
    }

    private void checkBooleanOption(String optionName, Method getter) throws IllegalAccessException, InvocationTargetException {
        for (boolean value : new boolean[]{false, true}) {
            String[] args = new String[]{optionName + "=" + value};
            JavaRuntimeParams params = JavaRuntimeParams.parseArgs((String[])args);
            Object actualValue = getter.invoke((Object)params, new Object[0]);
            this.expect.withMessage(args[0]).that(actualValue).isEqualTo((Object)value);
        }
    }

    private String string(Object x) {
        if (x instanceof Class) {
            return ((Class)x).getName();
        }
        return String.valueOf(x);
    }

    public static interface FakeServletEngineAdapter
    extends ServletEngineAdapter {
    }
}

