/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SpanId;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.JsonLogHandler;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.common.base.Throwables;
import com.google.common.truth.Truth;
import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class JsonLogHandlerTest {
    private LogRecord logRecord;

    @Test
    public void testPublish() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        JsonLogHandler handler = new JsonLogHandler(out, true, "test-project-id", (Formatter)new SimpleFormatter());
        this.logRecord.setSourceMethodName("testPublish");
        this.logRecord.setThrown(new Throwable("test throwable"));
        Throwable referenceLine = new Throwable();
        handler.publish(this.logRecord);
        handler.publish(this.logRecord);
        int firstPublishLine = referenceLine.getStackTrace()[0].getLineNumber() + 1;
        int secondPublishLine = firstPublishLine + 1;
        String expectedJson = "{\"logging.googleapis.com/trace\": \"projects/test-project-id/traces/01020304050607080910111213141516\", \"logging.googleapis.com/spanId\": \"000000000000004a\", \"severity\": \"INFO\", \"logging.googleapis.com/sourceLocation\": {\"function\": \"com.google.apphosting.runtime.JsonLogHandlerTest.testPublish\", \"file\": \"JsonLogHandlerTest.java\", \"line\": \"" + firstPublishLine + "\"}, \"message\": \"This is a log message that covers \\\"quotes\\\" \\n newlines and \\\\ escaped characters.\\n" + JsonLogHandler.ESCAPER.escape(Throwables.getStackTraceAsString((Throwable)this.logRecord.getThrown())) + "\"}";
        String expectedJson2 = "{\"logging.googleapis.com/trace\": \"projects/test-project-id/traces/01020304050607080910111213141516\", \"logging.googleapis.com/spanId\": \"000000000000004a\", \"severity\": \"INFO\", \"logging.googleapis.com/sourceLocation\": {\"function\": \"com.google.apphosting.runtime.JsonLogHandlerTest.testPublish\", \"file\": \"JsonLogHandlerTest.java\", \"line\": \"" + secondPublishLine + "\"}, \"message\": \"This is a log message that covers \\\"quotes\\\" \\n newlines and \\\\ escaped characters.\\n" + JsonLogHandler.ESCAPER.escape(Throwables.getStackTraceAsString((Throwable)this.logRecord.getThrown())) + "\"}";
        ((PrintStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).println(expectedJson);
        ((PrintStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).println(expectedJson2);
        Truth.assertThat((String)expectedJson2).doesNotContain((CharSequence)"\t");
        Truth.assertThat((String)expectedJson2).doesNotContain((CharSequence)"\r");
        Truth.assertThat((String)expectedJson2).doesNotContain((CharSequence)"\n");
    }

    @Test
    public void testPublishNullProject() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        JsonLogHandler handler = new JsonLogHandler(out, true, null, (Formatter)new SimpleFormatter());
        this.logRecord.setSourceMethodName("testPublishNullProject");
        Throwable referenceLine = new Throwable();
        handler.publish(this.logRecord);
        handler.publish(this.logRecord);
        int firstPublishLine = referenceLine.getStackTrace()[0].getLineNumber() + 1;
        int secondPublishLine = firstPublishLine + 1;
        String expectedJson = "{\"logging.googleapis.com/spanId\": \"000000000000004a\", \"severity\": \"INFO\", \"logging.googleapis.com/sourceLocation\": {\"function\": \"com.google.apphosting.runtime.JsonLogHandlerTest.testPublishNullProject\", \"file\": \"JsonLogHandlerTest.java\", \"line\": \"" + firstPublishLine + "\"}, \"message\": \"This is a log message that covers \\\"quotes\\\" \\n newlines and \\\\ escaped characters.\"}";
        String expectedJson2 = "{\"logging.googleapis.com/spanId\": \"000000000000004a\", \"severity\": \"INFO\", \"logging.googleapis.com/sourceLocation\": {\"function\": \"com.google.apphosting.runtime.JsonLogHandlerTest.testPublishNullProject\", \"file\": \"JsonLogHandlerTest.java\", \"line\": \"" + secondPublishLine + "\"}, \"message\": \"This is a log message that covers \\\"quotes\\\" \\n newlines and \\\\ escaped characters.\"}";
        ((PrintStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).println(expectedJson);
        ((PrintStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).println(expectedJson2);
    }

    @Test
    public void testPublishNullMessage() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        JsonLogHandler handler = new JsonLogHandler(out, true, null, (Formatter)new SimpleFormatter());
        this.logRecord = new LogRecord(Level.INFO, null);
        this.logRecord.setSourceMethodName("testPublishNullMessage");
        handler.publish(this.logRecord);
        String expectedJson = "{\"logging.googleapis.com/spanId\": \"000000000000004a\", \"severity\": \"INFO\", \"message\": \"\"}";
        ((PrintStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).println(expectedJson);
    }

    @Test
    public void testMessageParameters() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        JsonLogHandler handler = new JsonLogHandler(out, true, "test-project-id", (Formatter)new SimpleFormatter());
        Logger logger = Logger.getLogger("testMessageParameters");
        logger.addHandler((Handler)handler);
        logger.log(Level.INFO, "Message with parameters {0} and {1}", new String[]{"foo", "bar"});
        ArgumentCaptor string = ArgumentCaptor.forClass(String.class);
        ((PrintStream)Mockito.verify((Object)out)).println((String)string.capture());
        Truth.assertThat((String)((String)string.getValue())).contains((CharSequence)"Message with parameters foo and bar");
    }

    @Before
    public void setUp() {
        APIHostClientInterface apiHost = (APIHostClientInterface)Mockito.mock(APIHostClientInterface.class);
        ApiProxyImpl apiProxyImpl = ApiProxyImpl.builder().setApiHost(apiHost).build();
        AppVersion appVersion = AppVersion.builder().setPublicRoot("/").setAppInfo(AppinfoPb.AppInfo.getDefaultInstance()).build();
        TraceId.TraceIdProto traceId = TraceId.TraceIdProto.newBuilder().setHi(72623859790382856L).setLo(653040715295888662L).build();
        SpanId.SpanIdProto spanId = SpanId.SpanIdProto.newBuilder().setId(74L).build();
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(traceId.toByteString()).setSpanId(spanId.getId()).build();
        RuntimePb.UPRequest upRequest = RuntimePb.UPRequest.newBuilder().setTraceContext(context).buildPartial();
        MutableUpResponse upResponse = new MutableUpResponse();
        ApiProxyImpl.EnvironmentImpl environmentImpl = apiProxyImpl.createEnvironment(appVersion, upRequest, upResponse, null, null, null, null, null, null, null, null);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environmentImpl);
        this.logRecord = new LogRecord(Level.INFO, "This is a log message that covers \"quotes\" \n newlines and \\ escaped characters.");
        this.logRecord.setSourceClassName("com.google.apphosting.runtime.JsonLogHandlerTest");
    }
}

