/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.AppLogsPb;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SourcePb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.Logging;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.NullSandboxLogHandler;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class LoggingTest {
    @Rule
    public TestName testName = new TestName();
    private static final Logger rootLogger = Logger.getLogger("");

    @Test
    public void sourceLocation() {
        APIHostClientInterface apiHost = (APIHostClientInterface)Mockito.mock(APIHostClientInterface.class);
        ApiProxyImpl apiProxyImpl = ApiProxyImpl.builder().setApiHost(apiHost).build();
        AppVersion appVersion = AppVersion.builder().setPublicRoot("/").setAppInfo(AppinfoPb.AppInfo.getDefaultInstance()).build();
        RuntimePb.UPRequest upRequest = RuntimePb.UPRequest.getDefaultInstance();
        MutableUpResponse upResponse = new MutableUpResponse();
        ApiProxyImpl.EnvironmentImpl environmentImpl = apiProxyImpl.createEnvironment(appVersion, upRequest, upResponse, null, null, null, null, null, null, null, null);
        ApiProxy.setDelegate((ApiProxy.Delegate)apiProxyImpl);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environmentImpl);
        new NullSandboxLogHandler().init(rootLogger);
        Logger logger = Logger.getLogger("com.example.SomeApplicationClass");
        Throwable lineNumberCheck = new Throwable();
        logger.info("hello world");
        ImmutableList appLogList = upResponse.getAndClearAppLogList();
        Truth.assertThat((Iterable)appLogList).hasSize(1);
        AppLogsPb.AppLogLine appLogLine = (AppLogsPb.AppLogLine)appLogList.get(0);
        Truth.assertThat((String)appLogLine.getMessage()).contains((CharSequence)"hello world");
        Truth.assertThat((Long)appLogLine.getLevel()).isEqualTo((Object)ApiProxy.LogRecord.Level.info.ordinal());
        SourcePb.SourceLocation sourceLocation = appLogLine.getSourceLocation();
        Truth.assertThat((String)sourceLocation.getFile()).isEqualTo((Object)"LoggingTest.java");
        Truth.assertThat((String)sourceLocation.getFunctionName()).isEqualTo((Object)(this.getClass().getName() + "." + this.testName.getMethodName()));
        Truth.assertThat((Long)sourceLocation.getLine()).isEqualTo((Object)(lineNumberCheck.getStackTrace()[0].getLineNumber() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logJsonToFile_defaultFormatter() throws IOException {
        Logger fakeRootLogger = new Logger("", null){};
        try {
            fakeRootLogger.addHandler((Handler)Mockito.mock(Handler.class));
            File tempLog = File.createTempFile("LoggingTest", ".log");
            tempLog.deleteOnExit();
            Logging logging = new Logging(fakeRootLogger);
            logging.logJsonToFile("projectId", tempLog.toPath(), true);
            Truth.assertThat((Object[])fakeRootLogger.getHandlers()).hasLength(1);
            fakeRootLogger.log(Level.INFO, "Message with parameters {0} and {1}", new String[]{"foo", "bar"});
            List<String> logLines = Files.readAllLines(tempLog.toPath());
            Truth.assertThat(logLines).hasSize(1);
            String expectedPattern = "\\{\"severity\": \"INFO\", \"logging.googleapis.com/sourceLocation\": \\{\"function\": \"com.google.apphosting.runtime.LoggingTest.logJsonToFile_defaultFormatter\", \"file\": \"LoggingTest.java\", \"line\": \"\\d+\"\\}, \"message\": \"Message with parameters foo and bar\"\\}";
            Truth.assertThat((String)logLines.get(0)).matches(expectedPattern);
        }
        finally {
            for (Handler handler : fakeRootLogger.getHandlers()) {
                handler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void logJsonToFile_doNotClearHandlers() throws IOException {
        Logger fakeRootLogger = new Logger("", null){};
        try {
            fakeRootLogger.addHandler((Handler)Mockito.mock(Handler.class));
            File tempLog = File.createTempFile("LoggingTest", ".log");
            tempLog.deleteOnExit();
            Logging logging = new Logging(fakeRootLogger);
            logging.logJsonToFile("projectId", tempLog.toPath(), false);
            Truth.assertThat((Object[])fakeRootLogger.getHandlers()).hasLength(2);
        }
        finally {
            for (Handler handler : fakeRootLogger.getHandlers()) {
                handler.close();
            }
        }
    }
}

