/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.NullSandboxLogHandler;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class NullSandboxLogHandlerTest {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Logger rootLogger = Logger.getLogger("");
    private static final List<Handler> originalRootHandlers = new ArrayList<Handler>();
    private static final ApiProxy.Delegate<ApiProxy.Environment> mockDelegate = (ApiProxy.Delegate)Mockito.mock(ApiProxy.Delegate.class);
    private static final Map<ApiProxy.Environment, List<ApiProxy.LogRecord>> logRecordMap = new ConcurrentHashMap<ApiProxy.Environment, List<ApiProxy.LogRecord>>();
    private static final ByteArrayOutputStream javaLogOutput = new ByteArrayOutputStream();
    @Rule
    public final TestName testName = new TestName();

    @BeforeClass
    public static void setUpClass() {
        rootLogger.addHandler(new JavaLogHandler());
        Collections.addAll(originalRootHandlers, rootLogger.getHandlers());
        new NullSandboxLogHandler().init(rootLogger);
        ApiProxy.setDelegate(mockDelegate);
        ((ApiProxy.Delegate)Mockito.doAnswer(invocationOnMock -> {
            ApiProxy.Environment environment = (ApiProxy.Environment)invocationOnMock.getArgument(0);
            ApiProxy.LogRecord logRecord = (ApiProxy.LogRecord)invocationOnMock.getArgument(1);
            List logRecords = logRecordMap.computeIfAbsent(environment, unused -> new ArrayList());
            logRecords.add(logRecord);
            return null;
        }).when(mockDelegate)).log((ApiProxy.Environment)ArgumentMatchers.any(), (ApiProxy.LogRecord)ArgumentMatchers.any());
    }

    @Before
    public void initMockEnvironment() {
        ApiProxy.Environment mockEnvironment = (ApiProxy.Environment)Mockito.mock(ApiProxy.Environment.class);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)mockEnvironment);
    }

    private static List<ApiProxy.LogRecord> apiProxyLogRecordsForCurrentThread() {
        return logRecordMap.getOrDefault(ApiProxy.getCurrentEnvironment(), (List<ApiProxy.LogRecord>)ImmutableList.of());
    }

    private static String javaLogOutput() {
        try {
            return javaLogOutput.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void clearJavaLogOutput() {
        javaLogOutput.reset();
    }

    @Test
    public void userLogsGoToApiProxy() {
        NullSandboxLogHandlerTest.clearJavaLogOutput();
        Logger.getLogger("com.example.Foo").log(Level.WARNING, "Oops {0}", new Object[]{"!"});
        List<ApiProxy.LogRecord> logRecords = NullSandboxLogHandlerTest.apiProxyLogRecordsForCurrentThread();
        Truth.assertThat(logRecords).hasSize(1);
        ApiProxy.LogRecord logRecord = logRecords.get(0);
        Truth.assertThat((Comparable)logRecord.getLevel()).isEqualTo((Object)ApiProxy.LogRecord.Level.warn);
        String expectedMessage = this.getClass().getName() + " " + this.testName.getMethodName() + ": Oops !\n";
        Truth.assertThat((String)logRecord.getMessage()).isEqualTo((Object)expectedMessage);
        Truth.assertThat((String)NullSandboxLogHandlerTest.javaLogOutput()).isEmpty();
    }

    @Test
    public void runtimeLogsGoToOriginalHandlers() {
        NullSandboxLogHandlerTest.clearJavaLogOutput();
        ((GoogleLogger.Api)logger.atWarning()).log("Runtime log record %s", (Object)"!");
        Truth.assertThat(NullSandboxLogHandlerTest.apiProxyLogRecordsForCurrentThread()).isEmpty();
        String output = NullSandboxLogHandlerTest.javaLogOutput();
        Pattern expectedOutputPattern = Pattern.compile("W \\d{2}:\\d{2}:\\d{2} " + Pattern.quote(this.getClass().getName() + " " + this.testName.getMethodName()) + " Runtime log record !\n");
        Truth.assertThat((String)output).matches(expectedOutputPattern);
    }

    @Test
    public void runtimeLogsGoToOriginalHandlers_exception() {
        NullSandboxLogHandlerTest.clearJavaLogOutput();
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)new VerifyError("oops"))).log("Oops!");
        Truth.assertThat(NullSandboxLogHandlerTest.apiProxyLogRecordsForCurrentThread()).isEmpty();
        String output = NullSandboxLogHandlerTest.javaLogOutput();
        if (StandardSystemProperty.FILE_SEPARATOR.value().equals("/")) {
            Pattern expectedOutputPattern = Pattern.compile("S \\d{2}:\\d{2}:\\d{2} " + Pattern.quote(this.getClass().getName() + " " + this.testName.getMethodName()) + " Oops!\n" + Pattern.quote("java.lang.VerifyError: oops\n") + "\\s+at " + Pattern.quote(this.getClass().getName() + "." + this.testName.getMethodName()) + ".*", 32);
            Truth.assertThat((String)output).matches(expectedOutputPattern);
        }
    }

    @Test
    public void runtimeLogsWithJdkLogger() {
        NullSandboxLogHandlerTest.clearJavaLogOutput();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Oops {0}", "!");
        Truth.assertThat(NullSandboxLogHandlerTest.apiProxyLogRecordsForCurrentThread()).isEmpty();
        String output = NullSandboxLogHandlerTest.javaLogOutput();
        Pattern expectedOutputPattern = Pattern.compile("I \\d{2}:\\d{2}:\\d{2} " + Pattern.quote(this.getClass().getName() + " " + this.testName.getMethodName()) + " Oops !\n");
        Truth.assertThat((String)output).matches(expectedOutputPattern);
    }

    @Test
    public void timestampFormat() {
        NullSandboxLogHandlerTest.clearJavaLogOutput();
        LogRecord record = new LogRecord(Level.INFO, "foo");
        record.setMillis(1550271456774L);
        Logger.getLogger(this.getClass().getName()).log(record);
        String output = NullSandboxLogHandlerTest.javaLogOutput();
        Truth.assertThat((String)output).contains((CharSequence)":57:36");
    }

    private static class JavaLogHandler
    extends StreamHandler {
        JavaLogHandler() {
            this.setOutputStream(javaLogOutput);
            try {
                this.setEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }
}

