/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ApplicationClassLoader;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.ClassPathUtils;
import com.google.apphosting.runtime.NullSandboxPlugin;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class NullSandboxPluginTest {
    @Test
    public void classDirsScannedIfProperty() throws Exception {
        ImmutableMap systemProperties = ImmutableMap.of((Object)"com.google.appengine.always.scan.class.dirs", (Object)"true");
        this.testClassDirScanning((ImmutableMap<String, String>)systemProperties, true);
    }

    @Test
    public void classDirsNotScannedIfNotFlagAndNotProperty() throws Exception {
        this.testClassDirScanning((ImmutableMap<String, String>)ImmutableMap.of(), false);
    }

    private void testClassDirScanning(ImmutableMap<String, String> systemProperties, boolean alwaysScanClassDirs) throws MalformedURLException {
        NullSandboxPlugin plugin = new NullSandboxPlugin();
        URL[] urls = new URL[]{new URL("file:///tmp/nonexistentdirectory/")};
        File contextRoot = new File(".");
        ClassPathUtils classPathUtils = this.mockClassPathUtils();
        ApplicationEnvironment applicationEnvironment = this.mockApplicationEnvironment(systemProperties);
        String appsRoot = "";
        plugin.createRuntimeClassLoader(classPathUtils, appsRoot);
        ApplicationClassLoader loader = (ApplicationClassLoader)plugin.doCreateApplicationClassLoader(urls, contextRoot, applicationEnvironment);
        if (alwaysScanClassDirs) {
            Truth.assertThat((Object[])loader.getActualUrls()).isEqualTo((Object)loader.getURLs());
        } else {
            Truth.assertThat((Object[])loader.getActualUrls()).isNotEqualTo((Object)loader.getURLs());
        }
    }

    private ClassPathUtils mockClassPathUtils() {
        ClassPathUtils classPathUtils = (ClassPathUtils)Mockito.mock(ClassPathUtils.class);
        Mockito.when((Object)classPathUtils.getRuntimeSharedUrls()).thenReturn((Object)new URL[0]);
        Mockito.when((Object)classPathUtils.getRuntimeImplUrls()).thenReturn((Object)new URL[0]);
        Mockito.when((Object)classPathUtils.getPrebundledUrls()).thenReturn((Object)new URL[0]);
        return classPathUtils;
    }

    private ApplicationEnvironment mockApplicationEnvironment(ImmutableMap<String, String> systemProperties) {
        ApplicationEnvironment applicationEnvironment = (ApplicationEnvironment)Mockito.mock(ApplicationEnvironment.class);
        Mockito.when((Object)applicationEnvironment.getSystemProperties()).thenReturn(systemProperties);
        Mockito.when((Object)applicationEnvironment.getRuntimeConfiguration()).thenReturn((Object)ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        return applicationEnvironment;
    }
}

