/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SpanKindOuterClass;
import com.google.apphosting.base.protos.TraceEvents;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.CloudDebuggerAgentWrapper;
import com.google.apphosting.runtime.HardDeadlineExceededError;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RuntimeLogSink;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.test.MockAnyRpcServerContext;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class RequestManagerTest {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final double RPC_DEADLINE = 3.0;
    private static final long SLEEP_TIME = 5000L;
    private static final long SOFT_DEADLINE_DELAY = 750L;
    private static final long HARD_DEADLINE_DELAY = 250L;
    private static final long MAX_RUNTIME_LOG_PER_REQUEST = 0x2EE000L;
    private static final String APP_ID = "app123";
    private static final String ENGINE_ID = "engine";
    private static final String VERSION_ID = "v456";
    private static final long CYCLES_PER_SECOND = 2333414000L;
    private static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";
    private static final String INSTANCE_ID = "abc123";
    private AppVersion appVersion;
    private RuntimePb.UPRequest upRequest;
    private MutableUpResponse upResponse;
    private RuntimeLogSink logSink;
    @Mock
    private CloudDebuggerAgentWrapper cloudDebuggerAgent;
    @Mock
    private APIHostClientInterface mockApiHost;

    private boolean isJava8() {
        return StandardSystemProperty.JAVA_VERSION.value().startsWith("1.8");
    }

    @BeforeClass
    public static void initClasses() {
        Truth.assertThat((Boolean)true).isTrue();
        ((CloudDebuggerAgentWrapper)Mockito.mock(CloudDebuggerAgentWrapper.class)).hasBreakpointUpdates();
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.upRequest = RuntimePb.UPRequest.newBuilder().setAppId(APP_ID).setModuleId(ENGINE_ID).setModuleVersionId(VERSION_ID).buildPartial();
        this.upResponse = new MutableUpResponse();
        this.logSink = new RuntimeLogSink(0x2EE000L);
        File rootDirectory = Files.createTempDirectory("appengine", new FileAttribute[0]).toFile();
        ApplicationEnvironment appEnv = new ApplicationEnvironment(APP_ID, VERSION_ID, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), rootDirectory, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        this.appVersion = AppVersion.builder().setAppVersionKey(AppVersionKey.of((String)APP_ID, (String)VERSION_ID)).setAppInfo(AppinfoPb.AppInfo.getDefaultInstance()).setRootDirectory(rootDirectory).setEnvironment(appEnv).setSessionsConfig(new SessionsConfig(false, false, null)).setPublicRoot("").build();
    }

    private RequestManager.Builder requestManagerBuilder() {
        return RequestManager.builder().setSoftDeadlineDelay(750L).setHardDeadlineDelay(250L).setRuntimeLogSink(Optional.of(this.logSink)).setApiProxyImpl(ApiProxyImpl.builder().setApiHost(this.mockApiHost).build()).setMaxOutstandingApiRpcs(10).setCloudDebuggerAgent(this.cloudDebuggerAgent).setCyclesPerSecond(2333414000L).setWaitForDaemonRequestThreads(true).setDisableDeadlineTimers(false).setThreadStopTerminatesClone(true).setInterruptFirstOnSoftDeadline(false).setEnableCloudDebugger(true);
    }

    private RequestManager createRequestManager() {
        return this.requestManagerBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiEnvironment() {
        RequestManager requestManager = this.createRequestManager();
        Truth.assertThat((Object)ApiProxy.getCurrentEnvironment()).isEqualTo(null);
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        try {
            Truth.assertThat((String)ApiProxy.getCurrentEnvironment().getAppId()).isEqualTo((Object)APP_ID);
            Truth.assertThat((String)ApiProxy.getCurrentEnvironment().getModuleId()).isEqualTo((Object)ENGINE_ID);
            Truth.assertThat((String)ApiProxy.getCurrentEnvironment().getVersionId()).isEqualTo((Object)VERSION_ID);
            Truth.assertThat(ApiProxy.getCurrentEnvironment().getAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE)).isNull();
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Object)ApiProxy.getCurrentEnvironment()).isEqualTo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApiEnvironmentWithInstanceIdFromEnvironmentVariables() {
        RequestManager requestManager = this.requestManagerBuilder().setEnvironment((Map)ImmutableMap.of((Object)"GAE_INSTANCE", (Object)INSTANCE_ID)).build();
        Truth.assertThat((Object)ApiProxy.getCurrentEnvironment()).isEqualTo(null);
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        try {
            Truth.assertThat(ApiProxy.getCurrentEnvironment().getAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE)).isEqualTo((Object)INSTANCE_ID);
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Object)ApiProxy.getCurrentEnvironment()).isEqualTo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoftException() {
        if (!this.isJava8()) {
            return;
        }
        RequestManager requestManager = this.createRequestManager();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        long deadline = Math.round(3000.0) - 750L;
        try {
            try {
                Thread.sleep(deadline * 2L);
                Assert.fail((String)"Slept for double the allotted deadline.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
            }
            catch (DeadlineExceededException ex) {
                double elapsed = System.currentTimeMillis() - rpc.getStartTimeMillis();
                Truth.assertThat((Double)elapsed).isGreaterThan((Comparable)Double.valueOf(deadline));
                Truth.assertThat((Double)elapsed).isWithin(1500.0).of((double)deadline);
            }
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isTrue();
        Truth.assertThat((Boolean)this.upResponse.getCloneIsInUncleanState()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHardException() {
        if (!this.isJava8()) {
            return;
        }
        RequestManager requestManager = this.createRequestManager();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        long deadline = Math.round(3000.0) - 750L;
        try {
            try {
                Thread.sleep(2L * deadline);
                Assert.fail((String)"Slept for double the allotted deadline.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
            }
            catch (DeadlineExceededException softException) {
                double elapsed = System.currentTimeMillis() - rpc.getStartTimeMillis();
                Truth.assertThat((Double)elapsed).isGreaterThan((Comparable)Double.valueOf(deadline));
                Truth.assertThat((Double)elapsed).isWithin(1500.0).of((double)deadline);
                Truth.assertThat((Object[])softException.getStackTrace()).isNotEmpty();
                try {
                    Thread.sleep(5000L);
                    Assert.fail((String)"Slept past the allotted deadline after soft exception.");
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
                }
                catch (HardDeadlineExceededError hardException) {
                    Truth.assertThat((Object[])hardException.getStackTrace()).isNotEmpty();
                    double elapsed2 = System.currentTimeMillis() - rpc.getStartTimeMillis();
                    double hardDeadline = 2750.0;
                    Truth.assertThat((Double)elapsed2).isGreaterThan((Comparable)Double.valueOf(hardDeadline));
                    Truth.assertThat((Double)elapsed2).isWithin(1500.0).of(hardDeadline);
                }
            }
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isTrue();
        Truth.assertThat((Boolean)this.upResponse.getCloneIsInUncleanState()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoftExceptionNoCloneTermination() {
        if (!this.isJava8()) {
            return;
        }
        RequestManager requestManager = this.requestManagerBuilder().setThreadStopTerminatesClone(false).setEnableCloudDebugger(false).build();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        try {
            try {
                Thread.sleep(5000L);
                Assert.fail((String)"Slept for double the allotted deadline.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
            }
            catch (DeadlineExceededException ex) {
                double elapsed = System.currentTimeMillis() - rpc.getStartTimeMillis();
                double deadline = 2250.0;
                Truth.assertThat((Double)elapsed).isGreaterThan((Comparable)Double.valueOf(deadline));
                Truth.assertThat((Double)elapsed).isWithin(1200.0).of(deadline);
            }
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isFalse();
        Truth.assertThat((Boolean)this.upResponse.hasCloneIsInUncleanState()).isFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoftExceptionNoTimer() {
        if (!this.isJava8()) {
            return;
        }
        RequestManager requestManager = this.requestManagerBuilder().setDisableDeadlineTimers(true).setEnableCloudDebugger(false).build();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        try {
            try {
                DeadlineThread.startAndWait(requestManager, token, false);
                Thread.sleep(1000L);
                Assert.fail((String)"Deadline should be raised immediately.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
            }
            catch (DeadlineExceededException deadlineExceededException) {
                // empty catch block
            }
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isTrue();
        Truth.assertThat((Boolean)this.upResponse.getCloneIsInUncleanState()).isTrue();
    }

    @Test
    public void testSoftExceptionWithInterruption() throws Exception {
        RequestManager requestManager = this.requestManagerBuilder().setInterruptFirstOnSoftDeadline(true).setEnableCloudDebugger(false).build();
        MockAnyRpcServerContext rpc = this.createRpc();
        ThreadGroup threadGroup = new ThreadGroup("test-interruption");
        AtomicReference<TestOutcome> outcome = new AtomicReference<TestOutcome>(TestOutcome.NONE);
        Thread t = new Thread(threadGroup, () -> this.doTestSoftExceptionWithInterruption(requestManager, rpc, threadGroup, outcome));
        t.start();
        t.join();
        if (outcome.get() != TestOutcome.OK) {
            Assert.fail((String)outcome.get().getMessage());
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSoftExceptionWithInterruption(RequestManager requestManager, AnyRpcServerContext rpc, ThreadGroup threadGroup, AtomicReference<TestOutcome> outcome) {
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, rpc, this.upRequest, this.upResponse, threadGroup);
        SettableFuture asyncFuture = SettableFuture.create();
        token.getAsyncFutures().add(asyncFuture);
        try {
            try {
                asyncFuture.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if (!asyncFuture.isCancelled()) {
                outcome.set(TestOutcome.ASYNC_FUTURE_NOT_CANCELLED);
            } else {
                try {
                    Thread.sleep(5000L);
                    outcome.set(TestOutcome.THREAD_NOT_INTERRUPTED);
                }
                catch (InterruptedException ex) {
                    outcome.set(TestOutcome.OK);
                }
            }
        }
        catch (DeadlineExceededException ex) {
            outcome.set(TestOutcome.DEADLINE_THROWN);
        }
        finally {
            requestManager.finishRequest(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHardExceptionNoTimer() {
        if (!this.isJava8()) {
            return;
        }
        RequestManager requestManager = this.requestManagerBuilder().setDisableDeadlineTimers(true).setThreadStopTerminatesClone(false).setEnableCloudDebugger(false).build();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        try {
            try {
                DeadlineThread.startAndWait(requestManager, token, true);
                Thread.sleep(1000L);
                Assert.fail((String)"Deadline should be raised immediately.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Assert.fail((String)"Thread was interrupted.  Interesting, but not expected.");
            }
            catch (HardDeadlineExceededError hardException) {
                Truth.assertThat((Object[])hardException.getStackTrace()).isNotEmpty();
            }
        }
        finally {
            requestManager.finishRequest(token);
        }
        Truth.assertThat((Boolean)this.upResponse.getTerminateClone()).isTrue();
        Truth.assertThat((Boolean)this.upResponse.getCloneIsInUncleanState()).isTrue();
    }

    @Test
    public void testTraceDisabled() {
        RequestManager requestManager = this.createRequestManager();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        requestManager.finishRequest(token);
        Truth.assertThat((Boolean)this.upResponse.hasSerializedTrace()).isFalse();
    }

    @Test
    public void testTraceEnabled() throws InvalidProtocolBufferException {
        RequestManager requestManager = this.createRequestManager();
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(1).build();
        RuntimePb.UPRequest.Builder upRequestBuilder = this.upRequest.toBuilder().setTraceContext(context);
        upRequestBuilder.getRequestBuilder().setUrl("http://foo.com/request?a=1");
        this.upRequest = upRequestBuilder.buildPartial();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        this.upResponse.setError(7);
        this.upResponse.setErrorMessage("Error message");
        requestManager.finishRequest(token);
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)1);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_SERVER);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/request");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)1L);
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
    }

    @Test
    public void testTraceEnabledBadURL() throws InvalidProtocolBufferException {
        RequestManager requestManager = this.createRequestManager();
        TracePb.TraceContextProto context = TracePb.TraceContextProto.newBuilder().setTraceId(ByteString.copyFromUtf8((String)"trace id")).setSpanId(1L).setTraceMask(1).build();
        RuntimePb.UPRequest.Builder upRequestBuilder = this.upRequest.toBuilder().setTraceContext(context);
        upRequestBuilder.getRequestBuilder().setUrl("foo.com/request?a=1");
        this.upRequest = upRequestBuilder.buildPartial();
        MockAnyRpcServerContext rpc = this.createRpc();
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        requestManager.finishRequest(token);
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        TraceEvents.StartSpanProto startSpan = traceEvents.getSpanEvents(0).getEvent(0).getStartSpan();
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"Unparsable URL");
    }

    @Test
    public void testRuntimeLogging() {
        RequestManager requestManager = this.createRequestManager();
        MockAnyRpcServerContext rpc = this.createRpc();
        String prefix = "com.google.apphosting.runtime.RequestManagerTest testRuntimeLogging: ";
        ArrayDeque messages = new ArrayDeque(ImmutableList.of((Object)"Before startRequest.\n", (Object)"INFO During request.\n", (Object)"WARNING During request.\n", (Object)"ERROR During request.\n", (Object)"After finishRequest.\n"));
        ArrayDeque levels = new ArrayDeque(ImmutableList.of((Object)0, (Object)0, (Object)1, (Object)2, (Object)0));
        ((GoogleLogger.Api)logger.atInfo()).log("Before startRequest.");
        RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
        ((GoogleLogger.Api)logger.atInfo()).log("INFO During request.");
        ((GoogleLogger.Api)logger.atWarning()).log("WARNING During request.");
        ((GoogleLogger.Api)logger.atSevere()).log("ERROR During request.");
        requestManager.finishRequest(token);
        ((GoogleLogger.Api)logger.atInfo()).log("After finishRequest.");
        for (int i = 0; i < this.upResponse.getRuntimeLogLineCount(); ++i) {
            String message = this.upResponse.getRuntimeLogLine(i).getMessage();
            if (!message.startsWith(prefix)) continue;
            Truth.assertThat((String)message.substring(prefix.length())).isEqualTo(messages.removeFirst());
            Truth.assertThat((Integer)this.upResponse.getRuntimeLogLine(i).getSeverity()).isEqualTo((Object)((Integer)levels.removeFirst()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloudDebugger() {
        RequestManager requestManager = this.createRequestManager();
        ApiProxy.Delegate delegate = (ApiProxy.Delegate)Mockito.mock(ApiProxy.Delegate.class);
        ApiProxy.setDelegate((ApiProxy.Delegate)delegate);
        try {
            Mockito.when((Object)this.cloudDebuggerAgent.hasBreakpointUpdates()).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true);
            MockAnyRpcServerContext rpc = this.createRpc();
            MutableUpResponse upResponse1 = new MutableUpResponse();
            RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, upResponse1, new ThreadGroup("test"));
            requestManager.finishRequest(token);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
            Truth.assertThat((Boolean)upResponse1.hasPendingCloudDebuggerAction()).isTrue();
            Truth.assertThat((Boolean)upResponse1.getPendingCloudDebuggerAction().getDebuggeeRegistration()).isTrue();
            Truth.assertThat((Boolean)upResponse1.getPendingCloudDebuggerAction().getBreakpointUpdates()).isFalse();
            rpc = this.createRpc();
            MutableUpResponse upResponse2 = new MutableUpResponse();
            token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, upResponse2, new ThreadGroup("test"));
            requestManager.finishRequest(token);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
            Truth.assertThat((Boolean)upResponse2.hasPendingCloudDebuggerAction()).isFalse();
            rpc = this.createRpc();
            MutableUpResponse upResponse3 = new MutableUpResponse();
            token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, upResponse3, new ThreadGroup("test"));
            requestManager.finishRequest(token);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
            Truth.assertThat((Boolean)upResponse3.hasPendingCloudDebuggerAction()).isTrue();
            Truth.assertThat((Boolean)upResponse3.getPendingCloudDebuggerAction().getDebuggeeRegistration()).isFalse();
            Truth.assertThat((Boolean)upResponse3.getPendingCloudDebuggerAction().getBreakpointUpdates()).isTrue();
        }
        finally {
            ApiProxy.setDelegate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloudDebuggerDisabled() {
        RequestManager requestManager = this.requestManagerBuilder().setEnableCloudDebugger(false).build();
        ApiProxy.Delegate delegate = (ApiProxy.Delegate)Mockito.mock(ApiProxy.Delegate.class);
        ApiProxy.setDelegate((ApiProxy.Delegate)delegate);
        try {
            MockAnyRpcServerContext rpc = this.createRpc();
            RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
            requestManager.finishRequest(token);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.cloudDebuggerAgent});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
            Truth.assertThat((Boolean)this.upResponse.hasPendingCloudDebuggerAction()).isFalse();
        }
        finally {
            ApiProxy.setDelegate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloudDebuggerApplicationDisabled() {
        RequestManager.Builder builder = this.requestManagerBuilder();
        Truth.assertThat((Boolean)builder.enableCloudDebugger()).isTrue();
        RequestManager requestManager = builder.build();
        requestManager.disableCloudDebugger();
        ApiProxy.Delegate delegate = (ApiProxy.Delegate)Mockito.mock(ApiProxy.Delegate.class);
        ApiProxy.setDelegate((ApiProxy.Delegate)delegate);
        try {
            MockAnyRpcServerContext rpc = this.createRpc();
            RequestManager.RequestToken token = requestManager.startRequest(this.appVersion, (AnyRpcServerContext)rpc, this.upRequest, this.upResponse, new ThreadGroup("test"));
            requestManager.finishRequest(token);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.cloudDebuggerAgent});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
            Truth.assertThat((Boolean)this.upResponse.hasPendingCloudDebuggerAction()).isFalse();
        }
        finally {
            ApiProxy.setDelegate(null);
        }
    }

    private MockAnyRpcServerContext createRpc() {
        return new MockAnyRpcServerContext(Duration.ofNanos(Math.round(3.0E9)));
    }

    static enum TestOutcome {
        NONE("Unexpected outcome"),
        OK("OK"),
        THREAD_NOT_INTERRUPTED("Thread slept past the allotted deadline"),
        ASYNC_FUTURE_NOT_CANCELLED("Async future was not cancelled"),
        DEADLINE_THROWN("Thread was not interrupted, instead got a DeadlineExceededException");

        private final String message;

        private TestOutcome(String message) {
            this.message = message;
        }

        String getMessage() {
            return this.message;
        }
    }

    private static class DeadlineThread
    extends Thread {
        private final RequestManager requestManager;
        private final RequestManager.RequestToken token;
        private final boolean isUncatchable;
        private final CountDownLatch started = new CountDownLatch(1);

        private DeadlineThread(RequestManager requestManager, RequestManager.RequestToken token, boolean isUncatchable) {
            this.requestManager = requestManager;
            this.token = token;
            this.isUncatchable = isUncatchable;
        }

        static void startAndWait(RequestManager requestManager, RequestManager.RequestToken token, boolean isUncatchable) {
            DeadlineThread thread = new DeadlineThread(requestManager, token, isUncatchable);
            thread.start();
            try {
                thread.started.await();
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            this.started.countDown();
            this.requestManager.sendDeadline(this.token, this.isUncatchable);
        }
    }
}

