/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.base.AppVersionKey;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.AppVersion;
import com.google.apphosting.runtime.ApplicationEnvironment;
import com.google.apphosting.runtime.BackgroundRequestCoordinator;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.RequestManager;
import com.google.apphosting.runtime.RequestRunner;
import com.google.apphosting.runtime.SessionsConfig;
import com.google.apphosting.runtime.ThreadGroupPool;
import com.google.apphosting.runtime.UPRequestHandler;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.jetty94.JettyServletEngineAdapter;
import com.google.apphosting.runtime.test.MockAnyRpcServerContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class RequestRunnerTest {
    @Rule
    public final MockitoRule mockito = MockitoJUnit.rule();
    private static final Duration RPC_DEADLINE = Duration.ofSeconds(3L);
    private static final String APP_ID = "app123";
    private static final String ENGINE_ID = "engine";
    private static final String VERSION_ID = "v456";
    private static final String BACKGROUND_REQUEST_ID = "asdf";
    private AppVersion appVersion;
    private MutableUpResponse upResponse;
    BackgroundRequestCoordinator coordinator;
    private BlockingQueue<Throwable> caughtException;
    private ThreadGroupPool threadGroupPool;
    @Mock
    private RequestManager requestManager;
    @Mock
    private RequestManager.RequestToken requestToken;

    MockAnyRpcServerContext createRpc() {
        return new MockAnyRpcServerContext(RPC_DEADLINE);
    }

    @Before
    public void setUp() throws IOException {
        this.upResponse = new MutableUpResponse();
        File rootDirectory = Files.createTempDirectory("appengine", new FileAttribute[0]).toFile();
        ApplicationEnvironment appEnv = new ApplicationEnvironment(APP_ID, VERSION_ID, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), rootDirectory, ApplicationEnvironment.RuntimeConfiguration.DEFAULT_FOR_TEST);
        this.appVersion = AppVersion.builder().setAppVersionKey(AppVersionKey.of((String)APP_ID, (String)VERSION_ID)).setAppInfo(AppinfoPb.AppInfo.getDefaultInstance()).setRootDirectory(rootDirectory).setEnvironment(appEnv).setSessionsConfig(new SessionsConfig(false, false, null)).setPublicRoot("").build();
        this.coordinator = new BackgroundRequestCoordinator();
        ThreadGroup root = new ThreadGroup("root");
        this.caughtException = new ArrayBlockingQueue<Throwable>(100);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (thread, throwable) -> {
            throwable.printStackTrace();
            this.caughtException.offer(throwable);
        };
        this.threadGroupPool = ThreadGroupPool.builder().setParentThreadGroup(root).setThreadGroupNamePrefix("subgroup-").setUncaughtExceptionHandler(uncaughtExceptionHandler).setIgnoreDaemonThreads(false).build();
    }

    @Test
    public void run_dispatchesServletRequest() throws InterruptedException {
        MockAnyRpcServerContext rpc = this.createRpc();
        Mockito.when((Object)this.requestManager.startRequest((AppVersion)ArgumentMatchers.any(), (AnyRpcServerContext)ArgumentMatchers.any(), (RuntimePb.UPRequest)ArgumentMatchers.any(), (MutableUpResponse)ArgumentMatchers.any(), (ThreadGroup)ArgumentMatchers.any())).thenReturn((Object)this.requestToken);
        JettyServletEngineAdapter servletEngine = new JettyServletEngineAdapter(){

            public void serviceRequest(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) throws ServletException, IOException {
                upResponse.setError(0);
            }
        };
        RuntimePb.UPRequest upRequest = RuntimePb.UPRequest.newBuilder().setAppId(APP_ID).setModuleId(ENGINE_ID).setModuleVersionId(VERSION_ID).buildPartial();
        RequestRunner requestRunner = RequestRunner.builder().setAppVersion(this.appVersion).setRpc((AnyRpcServerContext)rpc).setUpRequest(upRequest).setUpResponse(this.upResponse).setRequestManager(this.requestManager).setCoordinator(this.coordinator).setCompressResponse(true).setUpRequestHandler((UPRequestHandler)servletEngine).build();
        this.threadGroupPool.start("test-thread", (Runnable)requestRunner);
        rpc.waitForCompletion();
        RuntimePb.UPResponse response = (RuntimePb.UPResponse)rpc.assertSuccess();
        Truth.assertThat((Integer)response.getError()).isEqualTo((Object)RuntimePb.UPResponse.ERROR.OK.getNumber());
        ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).startRequest((AppVersion)ArgumentMatchers.same((Object)this.appVersion), (AnyRpcServerContext)ArgumentMatchers.same((Object)rpc), (RuntimePb.UPRequest)ArgumentMatchers.same((Object)upRequest), (MutableUpResponse)ArgumentMatchers.same((Object)this.upResponse), (ThreadGroup)ArgumentMatchers.any());
        ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).finishRequest((RequestManager.RequestToken)ArgumentMatchers.same((Object)this.requestToken));
        Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofSeconds(1L));
        Truth.assertThat((Integer)this.threadGroupPool.waitingThreadCount()).isEqualTo((Object)1);
    }

    @Test
    public void run_handlesDispatchServletRequestException() throws InterruptedException {
        MockAnyRpcServerContext rpc = this.createRpc();
        Mockito.when((Object)this.requestManager.startRequest((AppVersion)ArgumentMatchers.any(), (AnyRpcServerContext)ArgumentMatchers.any(), (RuntimePb.UPRequest)ArgumentMatchers.any(), (MutableUpResponse)ArgumentMatchers.any(), (ThreadGroup)ArgumentMatchers.any())).thenReturn((Object)this.requestToken);
        JettyServletEngineAdapter servletEngine = new JettyServletEngineAdapter(){

            public void serviceRequest(RuntimePb.UPRequest upRequest, MutableUpResponse upResponse) throws ServletException, IOException {
                throw new OutOfMemoryError("this is a simulated OOM in the servletEngine");
            }
        };
        RuntimePb.UPRequest upRequest = RuntimePb.UPRequest.newBuilder().setAppId(APP_ID).setModuleId(ENGINE_ID).setModuleVersionId(VERSION_ID).buildPartial();
        RequestRunner requestRunner = RequestRunner.builder().setAppVersion(this.appVersion).setRpc((AnyRpcServerContext)rpc).setUpRequest(upRequest).setUpResponse(this.upResponse).setRequestManager(this.requestManager).setCoordinator(this.coordinator).setCompressResponse(true).setUpRequestHandler((UPRequestHandler)servletEngine).build();
        this.threadGroupPool.start("test-thread", (Runnable)requestRunner);
        rpc.waitForCompletion();
        RuntimePb.UPResponse response = (RuntimePb.UPResponse)rpc.assertSuccess();
        Truth.assertThat((Integer)response.getError()).isEqualTo((Object)RuntimePb.UPResponse.ERROR.APP_FAILURE.getNumber());
        Truth.assertThat((String)response.getErrorMessage()).isEqualTo((Object)"Unexpected exception from servlet: java.lang.OutOfMemoryError: this is a simulated OOM in the servletEngine");
        Truth.assertThat((Boolean)response.getTerminateClone()).isTrue();
        ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).startRequest((AppVersion)ArgumentMatchers.same((Object)this.appVersion), (AnyRpcServerContext)ArgumentMatchers.same((Object)rpc), (RuntimePb.UPRequest)ArgumentMatchers.same((Object)upRequest), (MutableUpResponse)ArgumentMatchers.same((Object)this.upResponse), (ThreadGroup)ArgumentMatchers.any());
        ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).finishRequest((RequestManager.RequestToken)ArgumentMatchers.same((Object)this.requestToken));
        Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofSeconds(1L));
        Truth.assertThat((Integer)this.threadGroupPool.waitingThreadCount()).isEqualTo((Object)1);
    }

    @Test
    public void run_backgroundRequest() throws InterruptedException, TimeoutException, ExecutionException {
        Mockito.when((Object)this.requestManager.startRequest((AppVersion)ArgumentMatchers.any(), (AnyRpcServerContext)ArgumentMatchers.any(), (RuntimePb.UPRequest)ArgumentMatchers.any(), (MutableUpResponse)ArgumentMatchers.any(), (ThreadGroup)ArgumentMatchers.any())).thenReturn((Object)this.requestToken);
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<Boolean> app = executor.submit(() -> {
            ArrayList<String> threadReadyToStart = new ArrayList<String>();
            ArrayList threadFinished = new ArrayList();
            Thread bgThread = this.coordinator.waitForThreadStart(BACKGROUND_REQUEST_ID, () -> {
                Truth.assertThat((Iterable)threadReadyToStart).containsExactly(new Object[]{"ready to start"});
                Truth.assertThat((Object)Thread.currentThread().getContextClassLoader()).isNull();
                try {
                    Thread.sleep(Duration.ofSeconds(1L).toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                threadFinished.add("thread complete");
            }, RPC_DEADLINE.toMillis());
            try {
                Thread.sleep(Duration.ofSeconds(1L).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return true;
            }
            threadReadyToStart.add("ready to start");
            bgThread.start();
            bgThread.join();
            Truth.assertThat(threadFinished).containsExactly(new Object[]{"thread complete"});
            return true;
        });
        Future<Boolean> server = executor.submit(() -> {
            MockAnyRpcServerContext rpc = this.createRpc();
            RuntimePb.UPRequest.Builder upRequestBuilder = RuntimePb.UPRequest.newBuilder().setAppId(APP_ID).setModuleId(ENGINE_ID).setModuleVersionId(VERSION_ID).setRequestType(RuntimePb.UPRequest.RequestType.BACKGROUND);
            HttpPb.HttpRequest.Builder httpRequest = upRequestBuilder.getRequestBuilder();
            httpRequest.addHeaders(HttpPb.ParsedHttpHeader.newBuilder().setKey("X-AppEngine-BackgroundRequest").setValue(BACKGROUND_REQUEST_ID));
            RuntimePb.UPRequest upRequest = upRequestBuilder.buildPartial();
            JettyServletEngineAdapter servletEngine = new JettyServletEngineAdapter();
            RequestRunner requestRunner = RequestRunner.builder().setAppVersion(this.appVersion).setRpc((AnyRpcServerContext)rpc).setUpRequest(upRequest).setUpResponse(this.upResponse).setRequestManager(this.requestManager).setCoordinator(this.coordinator).setCompressResponse(true).setUpRequestHandler((UPRequestHandler)servletEngine).build();
            this.threadGroupPool.start("test-thread", (Runnable)requestRunner);
            rpc.waitForCompletion();
            RuntimePb.UPResponse response = (RuntimePb.UPResponse)rpc.assertSuccess();
            Truth.assertThat((Integer)response.getError()).isEqualTo((Object)RuntimePb.UPResponse.ERROR.OK.getNumber());
            Truth.assertThat((Integer)response.getHttpResponse().getResponsecode()).isEqualTo((Object)200);
            Truth.assertThat((Iterable)response.getHttpResponse().getResponse()).isEqualTo((Object)ByteString.copyFromUtf8((String)"OK"));
            ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).startRequest((AppVersion)ArgumentMatchers.same((Object)this.appVersion), (AnyRpcServerContext)ArgumentMatchers.same((Object)rpc), (RuntimePb.UPRequest)ArgumentMatchers.same((Object)upRequest), (MutableUpResponse)ArgumentMatchers.same((Object)this.upResponse), (ThreadGroup)ArgumentMatchers.any());
            ((RequestManager)Mockito.verify((Object)this.requestManager, (VerificationMode)Mockito.times((int)1))).finishRequest((RequestManager.RequestToken)ArgumentMatchers.same((Object)this.requestToken));
            return true;
        });
        server.get();
        app.get();
        Truth.assertThat((Integer)this.threadGroupPool.waitingThreadCount()).isEqualTo((Object)0);
    }

    @Test
    public void setFailure_doesntOverwriteError() {
        RequestRunner.setFailure((MutableUpResponse)this.upResponse, (RuntimePb.UPResponse.ERROR)RuntimePb.UPResponse.ERROR.APP_FAILURE, (String)"This is a test error");
        RequestRunner.setFailure((MutableUpResponse)this.upResponse, (RuntimePb.UPResponse.ERROR)RuntimePb.UPResponse.ERROR.UNKNOWN_APP, (String)"This should not overwritten");
        Truth.assertThat((Integer)this.upResponse.getError()).isEqualTo((Object)RuntimePb.UPResponse.ERROR.APP_FAILURE.getNumber());
    }
}

