/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.SessionData;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializationTest {
    private static final long FAKE_EXPIRATION_TIME = 123456789012345L;
    private static final ImmutableMap<String, Object> FAKE_VALUE_MAP = ImmutableMap.of((Object)"foo", (Object)23, (Object)"bar", (Object)BigInteger.valueOf(23L));

    @Test
    public void sessionData() throws IOException, ClassNotFoundException {
        SessionData sessionData;
        URL sessionDataResource = this.getClass().getResource("sessiondata.ser");
        Truth.assertThat((Object)sessionDataResource).isNotNull();
        try (InputStream inputStream = sessionDataResource.openStream();
             ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            sessionData = (SessionData)objectInputStream.readObject();
        }
        Truth.assertThat((Long)sessionData.getExpirationTime()).isEqualTo((Object)123456789012345L);
        Truth.assertThat((Map)sessionData.getValueMap()).containsExactlyEntriesIn(FAKE_VALUE_MAP);
    }

    public static void main(String[] args) throws Exception {
        SessionData sessionData = new SessionData();
        sessionData.setExpirationTime(123456789012345L);
        Map valueMap = sessionData.getValueMap();
        valueMap.putAll(FAKE_VALUE_MAP);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(System.out);){
            objectOutputStream.writeObject(sessionData);
        }
    }
}

